/*
 * Decompiled with CFR 0.152.
 */
package com.chatwork.scala.ulid;

import com.chatwork.scala.ulid.ULID;
import com.chatwork.scala.ulid.ULID$lambda$$fromBytes$1;
import com.chatwork.scala.ulid.ULID$lambda$$internalParseCrockford$1;
import com.chatwork.scala.ulid.ULID$lambda$$internalWriteCrockford$1;
import com.chatwork.scala.ulid.ULID$lambda$$parseULID$1;
import com.chatwork.scala.ulid.ULID$lambda$1;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class ULID$
implements Serializable {
    public static final ULID$ MODULE$;
    private final Function0<Object> timestampGenerator;
    private final Function1<Object, byte[]> randomGenerator;
    private final int ULID_STRING_LENGTH;
    private final int ULID_BYTES_LENGTH;
    private final long com$chatwork$scala$ulid$ULID$$TIMESTAMP_MSB_MASK;
    private final long com$chatwork$scala$ulid$ULID$$RANDOM_MSB_MASK;
    private final int MASK_BITS;
    private final int MASK;
    private final char[] ENCODING_CHARS;
    private final int[] DECODING_CHARS;
    private final long TIMESTAMP_OVERFLOW_MASK;

    static {
        new ULID$();
    }

    public Function0<Object> timestampGenerator() {
        return this.timestampGenerator;
    }

    public Function1<Object, byte[]> randomGenerator() {
        return this.randomGenerator;
    }

    public ULID generate(Function0<Object> timestampGen, Function1<Object, byte[]> randomGen) {
        long timestamp = timestampGen.apply$mcJ$sp();
        this.checkTimestamp(timestamp);
        Tuple2<Object, Object> tuple2 = this.generateRandom(randomGen);
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long random1 = tuple2._1$mcJ$sp();
            long random2 = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(random1, random2);
            long random12 = sp3._1$mcJ$sp();
            long random22 = sp3._2$mcJ$sp();
            long mostSignificantBits = timestamp << 16 | random12 >>> 24;
            long leastSignificantBits = random12 << 40 | random22;
            return new ULID(mostSignificantBits, leastSignificantBits);
        }
        throw new MatchError(tuple2);
    }

    public Function0<Object> generate$default$1() {
        return this.timestampGenerator();
    }

    public Function1<Object, byte[]> generate$default$2() {
        return this.randomGenerator();
    }

    public ULID generateMonotonic(ULID previousID, Function0<Object> timestampGen, Function1<Object, byte[]> randomGen) {
        long timestamp = timestampGen.apply$mcJ$sp();
        return previousID.toEpochMilliAsLong() == timestamp ? previousID.increment() : this.generate((Function0<Object>)new Serializable(timestamp){
            public static final long serialVersionUID = 0L;
            private final long timestamp$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.timestamp$1;
            }
            {
                this.timestamp$1 = timestamp$1;
            }
        }, randomGen);
    }

    public Function0<Object> generateMonotonic$default$2() {
        return this.timestampGenerator();
    }

    public Function1<Object, byte[]> generateMonotonic$default$3() {
        return this.randomGenerator();
    }

    public Option<ULID> generateStrictlyMonotonic(ULID previousID, Function0<Object> timestamp, Function1<Object, byte[]> randomGran) {
        ULID result = this.generateMonotonic(previousID, timestamp, randomGran);
        return result.compareTo(previousID) < 1 ? None$.MODULE$ : new Some((Object)result);
    }

    public Function0<Object> generateStrictlyMonotonic$default$2() {
        return this.timestampGenerator();
    }

    public Function1<Object, byte[]> generateStrictlyMonotonic$default$3() {
        return this.randomGenerator();
    }

    private Tuple2<Object, Object> generateRandom(Function1<Object, byte[]> randomGen) {
        byte[] bytes = (byte[])randomGen.apply((Object)BoxesRunTime.boxToInteger((int)10));
        long random1 = 0L;
        long random2 = 0L;
        random1 = (long)(bytes[0] & 0xFF) << 32;
        random1 |= (long)(bytes[1] & 0xFF) << 24;
        random1 |= (long)(bytes[2] & 0xFF) << 16;
        random1 |= (long)(bytes[3] & 0xFF) << 8;
        random2 = (long)(bytes[5] & 0xFF) << 32;
        random2 |= (long)(bytes[6] & 0xFF) << 24;
        random2 |= (long)(bytes[7] & 0xFF) << 16;
        random2 |= (long)(bytes[8] & 0xFF) << 8;
        return new Tuple2.mcJJ.sp(random1 |= (long)(bytes[4] & 0xFF), random2 |= (long)(bytes[9] & 0xFF));
    }

    private int ULID_STRING_LENGTH() {
        return this.ULID_STRING_LENGTH;
    }

    private int ULID_BYTES_LENGTH() {
        return this.ULID_BYTES_LENGTH;
    }

    public long com$chatwork$scala$ulid$ULID$$TIMESTAMP_MSB_MASK() {
        return this.com$chatwork$scala$ulid$ULID$$TIMESTAMP_MSB_MASK;
    }

    public long com$chatwork$scala$ulid$ULID$$RANDOM_MSB_MASK() {
        return this.com$chatwork$scala$ulid$ULID$$RANDOM_MSB_MASK;
    }

    private int MASK_BITS() {
        return this.MASK_BITS;
    }

    private int MASK() {
        return this.MASK;
    }

    public char[] ENCODING_CHARS() {
        return this.ENCODING_CHARS;
    }

    private int[] DECODING_CHARS() {
        return this.DECODING_CHARS;
    }

    public long TIMESTAMP_OVERFLOW_MASK() {
        return this.TIMESTAMP_OVERFLOW_MASK;
    }

    private void checkTimestamp(long timestamp) {
        if ((timestamp & this.TIMESTAMP_OVERFLOW_MASK()) != 0L) {
            throw new IllegalArgumentException("ULID does not support timestamps after +10889-08-02T05:31:50.655Z!");
        }
    }

    public String internalWriteCrockford(long value, int count) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1)new ULID$lambda$$internalWriteCrockford$1(this, value, count), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
    }

    public long internalParseCrockford(String input) {
        int length = input.length();
        if (length > 12) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"input length must not exceed 12 but was ").append((Object)BoxesRunTime.boxToInteger((int)length)).append((Object)"!").toString());
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(input)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new ULID$lambda$$internalParseCrockford$1(this, length)));
    }

    public boolean isValid(String ulidString) {
        return this.parseULID(ulidString).isSuccess();
    }

    public Try<ULID> parseULID(String ulidString) {
        return Try$.MODULE$.apply((Function0)new ULID$lambda$$parseULID$1(this, ulidString));
    }

    public Try<ULID> fromBytes(byte[] data) {
        return Try$.MODULE$.apply((Function0)new ULID$lambda$$fromBytes$1(this, data));
    }

    public ULID apply(long mostSignificantBits, long leastSignificantBits) {
        return new ULID(mostSignificantBits, leastSignificantBits);
    }

    public Option<Tuple2<Object, Object>> unapply(ULID x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2.mcJJ.sp(x$0.mostSignificantBits(), x$0.leastSignificantBits()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final SecureRandom liftedTree1$1() {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            secureRandom = SecureRandom.getInstanceStrong();
        }
        return secureRandom;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ byte[] com$chatwork$scala$ulid$ULID$$$anonfun$1(SecureRandom defaultRandomGen$1, int args) {
        void var2_2;
        byte[] array = new byte[args];
        defaultRandomGen$1.nextBytes(array);
        return var2_2;
    }

    public final /* synthetic */ char com$chatwork$scala$ulid$ULID$$$anonfun$2(long value$1, int count$1, int i) {
        int index = (int)(value$1 >>> (count$1 - i - 1) * this.MASK_BITS() & (long)this.MASK());
        return this.ENCODING_CHARS()[index];
    }

    public final /* synthetic */ long com$chatwork$scala$ulid$ULID$$$anonfun$3(int length$1, long x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            long result = tuple2._1$mcJ$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                int value;
                char current = tuple22._1$mcC$sp();
                int i = tuple22._2$mcI$sp();
                int n = value = current < this.DECODING_CHARS().length ? this.DECODING_CHARS()[current] : -1;
                if (value < 0) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Illegal character '").append((Object)BoxesRunTime.boxToCharacter((char)current)).append((Object)"'!").toString());
                }
                long l = result | (long)value << (length$1 - 1 - i) * this.MASK_BITS();
                return l;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public final /* synthetic */ ULID com$chatwork$scala$ulid$ULID$$$anonfun$4(String ulidString$1) {
        if (ulidString$1.length() != this.ULID_STRING_LENGTH()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ulidString must be exactly ", " chars long."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ULID_STRING_LENGTH())})));
        }
        String timeString = ulidString$1.substring(0, 10);
        long timestamp = this.internalParseCrockford(timeString);
        if ((timestamp & this.TIMESTAMP_OVERFLOW_MASK()) != 0L) {
            throw new IllegalArgumentException("ulidString must not exceed '7ZZZZZZZZZZZZZZZZZZZZZZZZZ'!");
        }
        String part1String = ulidString$1.substring(10, 18);
        long part1 = this.internalParseCrockford(part1String);
        String part2String = ulidString$1.substring(18);
        long part2 = this.internalParseCrockford(part2String);
        long mostSignificantBits = timestamp << 16 | part1 >>> 24;
        long leastSignificantBits = part2 | part1 << 40;
        return new ULID(mostSignificantBits, leastSignificantBits);
    }

    public final /* synthetic */ ULID com$chatwork$scala$ulid$ULID$$$anonfun$5(byte[] data$1) {
        if (data$1.length != this.ULID_BYTES_LENGTH()) {
            throw new IllegalArgumentException("data must be 16 bytes in length!");
        }
        long mostSignificantBits = BoxesRunTime.unboxToLong((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 8).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(data$1){
            public static final long serialVersionUID = 0L;
            private final byte[] data$1;

            public final long apply(long x0$2, int x1$2) {
                return this.apply$mcJJI$sp(x0$2, x1$2);
            }

            public long apply$mcJJI$sp(long x0$2, int x1$2) {
                Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(x0$2, x1$2);
                if (sp2 != null) {
                    long result = sp2._1$mcJ$sp();
                    int i = sp2._2$mcI$sp();
                    long l = result << 8 | (long)(this.data$1[i] & 0xFF);
                    return l;
                }
                throw new MatchError((Object)sp2);
            }
            {
                this.data$1 = data$1;
            }
        }));
        long leastSignificantBits = BoxesRunTime.unboxToLong((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(8), 16).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(data$1){
            public static final long serialVersionUID = 0L;
            private final byte[] data$1;

            public final long apply(long x0$3, int x1$3) {
                return this.apply$mcJJI$sp(x0$3, x1$3);
            }

            public long apply$mcJJI$sp(long x0$3, int x1$3) {
                Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(x0$3, x1$3);
                if (sp2 != null) {
                    long result = sp2._1$mcJ$sp();
                    int i = sp2._2$mcI$sp();
                    long l = result << 8 | (long)(this.data$1[i] & 0xFF);
                    return l;
                }
                throw new MatchError((Object)sp2);
            }
            {
                this.data$1 = data$1;
            }
        }));
        return new ULID(mostSignificantBits, leastSignificantBits);
    }

    private ULID$() {
        MODULE$ = this;
        this.timestampGenerator = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return System.currentTimeMillis();
            }
        };
        SecureRandom defaultRandomGen = this.liftedTree1$1();
        this.randomGenerator = (Function1)new ULID$lambda$1(defaultRandomGen);
        this.ULID_STRING_LENGTH = 26;
        this.ULID_BYTES_LENGTH = 16;
        this.com$chatwork$scala$ulid$ULID$$TIMESTAMP_MSB_MASK = -65536L;
        this.com$chatwork$scala$ulid$ULID$$RANDOM_MSB_MASK = 65535L;
        this.MASK_BITS = 5;
        this.MASK = 31;
        this.ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
        this.DECODING_CHARS = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 1, 20, 21, 0, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 1, 20, 21, 0, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31};
        this.TIMESTAMP_OVERFLOW_MASK = -281474976710656L;
    }
}

