/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle.util.recyclerview;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/charlezz/pickle/util/recyclerview/GridSpaceDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "spanCount", "", "space", "includeEdge", "", "(IIZ)V", "getSpace", "()I", "setSpace", "(I)V", "getSpanCount", "setSpanCount", "getItemOffsets", "", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "pickle_release"})
public final class GridSpaceDecoration
extends RecyclerView.ItemDecoration {
    private int spanCount;
    private int space;
    private final boolean includeEdge;

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.spanCount == 0) {
            return;
        }
        int position = parent.getChildAdapterPosition(view);
        if (position >= 0) {
            int column = position % this.spanCount;
            if (this.includeEdge) {
                outRect.left = this.space - column * this.space / this.spanCount;
                outRect.right = (column + 1) * this.space / this.spanCount;
                if (position < this.spanCount) {
                    outRect.top = this.space;
                }
                outRect.bottom = this.space;
            } else {
                outRect.left = column * this.space / this.spanCount;
                outRect.right = this.space - (column + 1) * this.space / this.spanCount;
                outRect.bottom = this.space;
            }
        } else {
            outRect.left = 0;
            outRect.right = 0;
            outRect.top = 0;
            outRect.bottom = 0;
        }
    }

    public final int getSpanCount() {
        return this.spanCount;
    }

    public final void setSpanCount(int n) {
        this.spanCount = n;
    }

    public final int getSpace() {
        return this.space;
    }

    public final void setSpace(int n) {
        this.space = n;
    }

    public GridSpaceDecoration(int spanCount2, int space, boolean includeEdge) {
        this.spanCount = spanCount2;
        this.space = space;
        this.includeEdge = includeEdge;
    }

    public /* synthetic */ GridSpaceDecoration(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        this(n, n2, bl);
    }

    public GridSpaceDecoration() {
        this(0, 0, false, 7, null);
    }
}

