/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle.data;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.charlezz.pickle.util.PickleConstants;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\fJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0007R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/charlezz/pickle/data/PickleContentObserver;", "Landroid/database/ContentObserver;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "contentChangedEvent", "Landroidx/lifecycle/MutableLiveData;", "Landroid/net/Uri;", "getContext", "()Landroid/content/Context;", "getContentChangedEvent", "Landroidx/lifecycle/LiveData;", "onChange", "", "selfChange", "", "uri", "onPause", "onResume", "pickle_release"})
public final class PickleContentObserver
extends ContentObserver
implements LifecycleObserver {
    private final MutableLiveData<Uri> contentChangedEvent;
    @NotNull
    private final Context context;

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public final void onPause() {
        Timber.d((String)"register()", (Object[])new Object[0]);
        this.context.getContentResolver().registerContentObserver(PickleConstants.INSTANCE.getContentUri(), true, (ContentObserver)this);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public final void onResume() {
        Timber.d((String)"unregister()", (Object[])new Object[0]);
        this.context.getContentResolver().unregisterContentObserver((ContentObserver)this);
    }

    public void onChange(boolean selfChange, @Nullable Uri uri) {
        super.onChange(selfChange, uri);
        StringBuilder stringBuilder = new StringBuilder().append("onChange : selfChange = ").append(selfChange).append(" uri = ").append(uri).append(" onMainThread = ");
        Thread thread = Thread.currentThread();
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"Looper.getMainLooper()");
        Timber.d((String)stringBuilder.append(Intrinsics.areEqual((Object)thread, (Object)looper.getThread())).toString(), (Object[])new Object[0]);
        this.contentChangedEvent.setValue((Object)uri);
    }

    @NotNull
    public final LiveData<Uri> getContentChangedEvent() {
        return (LiveData)this.contentChangedEvent;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Inject
    public PickleContentObserver(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(new Handler(Looper.getMainLooper()));
        this.context = context;
        this.contentChangedEvent = new MutableLiveData();
    }
}

