/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle.util.glide;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class RoundedCornersLineOverDrawTransFormation
extends BitmapTransformation {
    private static final String ID = "com_charlezz_pickle_RoundedCornersLineOverDrawTransFormation";
    private static final byte[] ID_BYTES = "com_charlezz_pickle_RoundedCornersLineOverDrawTransFormation".getBytes(CHARSET);
    private final int roundingRadius;
    private final float lineWidth;
    private final int lineColor;

    public RoundedCornersLineOverDrawTransFormation(int roundingRadius, float lineWidth, int lineColor) {
        Preconditions.checkArgument((roundingRadius > 0 ? 1 : 0) != 0, (String)"roundingRadius must be greater than 0.");
        Preconditions.checkArgument((lineWidth > 0.0f ? 1 : 0) != 0, (String)"lineWidth must be greater than 0.");
        this.roundingRadius = roundingRadius;
        this.lineWidth = lineWidth;
        this.lineColor = lineColor;
    }

    public RoundedCornersLineOverDrawTransFormation(int roundingRadius, float lineWidth) {
        this(roundingRadius, lineWidth, Color.parseColor((String)"#0F000000"));
    }

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        Bitmap result = TransformationUtils.roundedCorners((BitmapPool)pool, (Bitmap)toTransform, (int)this.roundingRadius);
        Paint borderPaint = new Paint();
        borderPaint.setAntiAlias(true);
        borderPaint.setColor(this.lineColor);
        RectF rect = new RectF(0.0f, 0.0f, (float)outWidth, (float)outHeight);
        RectF lineRect = new RectF(this.lineWidth, this.lineWidth, (float)outWidth - this.lineWidth, (float)outHeight - this.lineWidth);
        Canvas canvas = new Canvas(result);
        Path path = new Path();
        path.addRoundRect(lineRect, (float)this.roundingRadius, (float)this.roundingRadius, Path.Direction.CCW);
        canvas.clipPath(path, Region.Op.DIFFERENCE);
        canvas.drawRoundRect(rect, (float)this.roundingRadius, (float)this.roundingRadius, borderPaint);
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof RoundedCornersLineOverDrawTransFormation) {
            RoundedCornersLineOverDrawTransFormation other = (RoundedCornersLineOverDrawTransFormation)((Object)o);
            return this.lineWidth == other.lineWidth && this.roundingRadius == other.roundingRadius;
        }
        return false;
    }

    public int hashCode() {
        return Util.hashCode((int)ID.hashCode(), (int)Util.hashCode((float)(this.lineWidth + (float)this.roundingRadius)));
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(ID_BYTES);
        byte[] radiusData = ByteBuffer.allocate(4).putFloat(this.lineWidth + (float)this.roundingRadius).array();
        messageDigest.update(radiusData);
    }
}

