/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle.fragments.folder;

import android.content.Context;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.charlezz.pickle.R;
import com.charlezz.pickle.data.entity.AlbumItem;
import com.charlezz.pickle.databinding.ViewPickleAlbumBinding;
import com.charlezz.pickle.util.MeasureUtil;
import com.charlezz.pickle.util.glide.RoundedCornersLineOverDrawTransFormation;
import com.charlezz.pickle.util.recyclerview.DataBindingAdapter;
import com.charlezz.pickle.util.recyclerview.DataBindingHolder;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0014\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/charlezz/pickle/fragments/folder/PickleAlbumAdapter;", "Lcom/charlezz/pickle/util/recyclerview/DataBindingAdapter;", "Lcom/charlezz/pickle/data/entity/AlbumItem;", "Lcom/charlezz/pickle/databinding/ViewPickleAlbumBinding;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "folderRadius", "", "outlineColor", "", "outlineWidth", "onBindViewHolder", "", "holder", "Lcom/charlezz/pickle/util/recyclerview/DataBindingHolder;", "position", "submitItems", "newItems", "", "pickle_release"})
public final class PickleAlbumAdapter
extends DataBindingAdapter<AlbumItem, ViewPickleAlbumBinding> {
    private final float folderRadius;
    private final float outlineWidth;
    private final int outlineColor;

    public final void submitItems(@NotNull List<AlbumItem> newItems) {
        Intrinsics.checkNotNullParameter(newItems, (String)"newItems");
        DiffUtil.DiffResult diffResult2 = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(this, newItems){
            final /* synthetic */ PickleAlbumAdapter this$0;
            final /* synthetic */ List $newItems;

            public int getOldListSize() {
                return this.this$0.getItems().size();
            }

            public int getNewListSize() {
                return this.$newItems.size();
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                return Intrinsics.areEqual((Object)((AlbumItem)this.this$0.getItems().get(oldItemPosition)).getAlbum().getBucketId(), (Object)((AlbumItem)this.$newItems.get(newItemPosition)).getAlbum().getBucketId());
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                return Intrinsics.areEqual((Object)((AlbumItem)this.this$0.getItems().get(oldItemPosition)).getAlbum(), (Object)((AlbumItem)this.$newItems.get(newItemPosition)).getAlbum());
            }
            {
                this.this$0 = this$0;
                this.$newItems = $captured_local_variable$1;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)diffResult2, (String)"DiffUtil.calculateDiff(o\u2026\n            }\n        })");
        DiffUtil.DiffResult diffResult3 = diffResult2;
        this.getItems().clear();
        this.getItems().addAll((Collection)newItems);
        diffResult3.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    @Override
    public void onBindViewHolder(@NotNull DataBindingHolder<ViewPickleAlbumBinding> holder, int position) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        Object DBA = this.getItems().get(position);
        Intrinsics.checkNotNullExpressionValue(DBA, (String)"items[position]");
        AlbumItem item = (AlbumItem)DBA;
        ((RequestBuilder)Glide.with((View)((View)holder.getBinding().image)).load(item.getRecentMediaUri()).transform(new Transformation[]{(Transformation)new CenterCrop(), (Transformation)new RoundedCornersLineOverDrawTransFormation((int)this.folderRadius, this.outlineWidth, this.outlineColor)})).into(holder.getBinding().image);
        super.onBindViewHolder(holder, position);
    }

    @Inject
    public PickleAlbumAdapter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(null, 1, null);
        this.folderRadius = MeasureUtil.INSTANCE.getDimension(context, R.dimen.pickle_folder_corner_radius);
        this.outlineWidth = MeasureUtil.INSTANCE.getDimension(context, R.dimen.pickle_folder_outline_width);
        this.outlineColor = ContextCompat.getColor((Context)context, (int)R.color.light_white);
    }
}

