/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import androidx.core.content.FileProvider;
import com.charlezz.pickle.util.DeviceUtil;
import com.charlezz.pickle.util.PickleConstants;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J.\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00160\u0018J\u0014\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/charlezz/pickle/util/CameraUtil;", "", "context", "Landroid/content/Context;", "envDir", "", "dirToSave", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "getContext", "()Landroid/content/Context;", "currentImagePath", "getCurrentImagePath", "()Ljava/lang/String;", "setCurrentImagePath", "(Ljava/lang/String;)V", "getDirToSave", "getEnvDir", "createImageFile", "Ljava/io/File;", "hasCamera", "", "prepareImageCapture", "", "readyToLaunch", "Lkotlin/Function1;", "Landroid/net/Uri;", "fallback", "Ljava/io/IOException;", "saveImageToMediaStore", "callback", "Lkotlin/Function0;", "pickle_release"})
public final class CameraUtil {
    @Nullable
    private String currentImagePath;
    @NotNull
    private final Context context;
    @NotNull
    private final String envDir;
    @NotNull
    private final String dirToSave;

    @Nullable
    public final String getCurrentImagePath() {
        return this.currentImagePath;
    }

    public final void setCurrentImagePath(@Nullable String string2) {
        this.currentImagePath = string2;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private final File createImageFile() {
        File file;
        String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(\"yyyyMMdd_HHmmss\").format(Date())");
        String timeStamp = string2;
        if (DeviceUtil.INSTANCE.isAndroid10Later()) {
            File file2 = this.context.getExternalFilesDir(this.envDir);
            if (file2 == null) {
                throw (Throwable)new IllegalArgumentException("Can't get External file directory(" + this.envDir + ')');
            }
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.getExternalFiles\u2026file directory($envDir)\")");
        } else {
            File file3 = Environment.getExternalStoragePublicDirectory((String)(this.envDir + File.separator + this.dirToSave));
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"Environment.getExternalS\u2026le.separator + dirToSave)");
        }
        File storageDir = file;
        File file4 = File.createTempFile(timeStamp + '_', ".jpg", storageDir);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file4;
        boolean bl3 = false;
        this.currentImagePath = $this$apply.getAbsolutePath();
        Timber.d((String)("path = " + $this$apply.getAbsolutePath()), (Object[])new Object[0]);
        File file5 = file4;
        Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"File.createTempFile(\n   \u2026$absolutePath\")\n        }");
        return file5;
    }

    public final boolean hasCamera() {
        return this.context.getPackageManager().hasSystemFeature("android.hardware.camera") && new Intent("android.media.action.IMAGE_CAPTURE").resolveActivity(this.context.getPackageManager()) != null;
    }

    public final void prepareImageCapture(@NotNull Function1<? super Uri, Unit> readyToLaunch, @NotNull Function1<? super IOException, Unit> fallback) {
        block2: {
            File imageFile;
            File file;
            Intrinsics.checkNotNullParameter(readyToLaunch, (String)"readyToLaunch");
            Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
            try {
                file = this.createImageFile();
            }
            catch (IOException e) {
                fallback.invoke((Object)e);
                Timber.w((Throwable)e);
                file = null;
            }
            File file2 = imageFile = file;
            if (file2 == null) break block2;
            file = file2;
            boolean bl = false;
            boolean bl2 = false;
            File file3 = file;
            boolean bl3 = false;
            Uri uri = FileProvider.getUriForFile((Context)this.context, (String)PickleConstants.INSTANCE.getAuthority(this.context), (File)file3);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"FileProvider.getUriForFi\u2026       file\n            )");
            Uri imageUri = uri;
            readyToLaunch.invoke((Object)imageUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveImageToMediaStore(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        String string2 = this.currentImagePath;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String path = string3;
            boolean bl3 = false;
            File file = new File(path);
            if (DeviceUtil.INSTANCE.isAndroid10Later()) {
                Uri contentUri = MediaStore.Images.Media.getContentUri((String)"external_primary");
                ContentResolver contentResolver = this.context.getContentResolver();
                ContentValues contentValues = new ContentValues();
                boolean bl4 = false;
                boolean bl5 = false;
                ContentValues $this$apply = contentValues;
                boolean bl6 = false;
                $this$apply.put("_display_name", file.getName());
                $this$apply.put("relative_path", this.envDir + File.separator + this.dirToSave);
                $this$apply.put("is_pending", Integer.valueOf(1));
                ContentValues contentValues2 = contentValues;
                Uri imageUri = contentResolver.insert(contentUri, contentValues2);
                Timber.d((String)("insertedUri = " + imageUri), (Object[])new Object[0]);
                if (imageUri != null) {
                    Closeable closeable = (Closeable)this.context.getContentResolver().openFileDescriptor(imageUri, "w");
                    bl5 = false;
                    boolean bl7 = false;
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)closeable;
                        boolean bl8 = false;
                        new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor).write(FilesKt.readBytes((File)file));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    contentValues2.clear();
                    contentValues2.put("is_pending", Integer.valueOf(0));
                    contentResolver.update(imageUri, contentValues2, null, null);
                }
            }
            MediaScannerConnection.scanFile((Context)this.context, (String[])new String[]{this.currentImagePath}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(this, callback){
                final /* synthetic */ CameraUtil this$0;
                final /* synthetic */ Function0 $callback$inlined;
                {
                    this.this$0 = cameraUtil;
                    this.$callback$inlined = function0;
                }

                public final void onScanCompleted(String path, Uri uri) {
                    Timber.d((String)("MediaScannerConnection path = " + path + ", uri = " + uri), (Object[])new Object[0]);
                    this.$callback$inlined.invoke();
                }
            });
        } else {
            Timber.w((String)"No Image to Save", (Object[])new Object[0]);
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getEnvDir() {
        return this.envDir;
    }

    @NotNull
    public final String getDirToSave() {
        return this.dirToSave;
    }

    public CameraUtil(@NotNull Context context, @NotNull String envDir, @NotNull String dirToSave) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)envDir, (String)"envDir");
        Intrinsics.checkNotNullParameter((Object)dirToSave, (String)"dirToSave");
        this.context = context;
        this.envDir = envDir;
        this.dirToSave = dirToSave;
    }
}

