/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.view.View;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.FlowLiveDataConversions;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.paging.CachedPagingDataKt;
import androidx.paging.PagingData;
import androidx.paging.PagingDataKt;
import com.charlezz.pickle.Config;
import com.charlezz.pickle.PickleSharedViewModel$$special$;
import com.charlezz.pickle.Selection;
import com.charlezz.pickle.ToolbarViewModel;
import com.charlezz.pickle.data.entity.Album;
import com.charlezz.pickle.data.entity.Media;
import com.charlezz.pickle.data.entity.MediaItem;
import com.charlezz.pickle.data.entity.MediaKt;
import com.charlezz.pickle.fragments.main.AppPickleRepository;
import com.charlezz.pickle.fragments.main.PicklePagingSource;
import com.charlezz.pickle.fragments.main.PickleRepository;
import com.charlezz.pickle.util.CameraUtil;
import com.charlezz.pickle.util.dagger.AssistedSavedStateViewModelFactory;
import com.charlezz.pickle.util.lifecycle.SingleLiveEvent;
import com.squareup.inject.assisted.Assisted;
import com.squareup.inject.assisted.AssistedInject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 L2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002LMB!\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010;\u001a\b\u0012\u0004\u0012\u00020!0<J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020,H\u0016J \u0010@\u001a\u00020>2\u0006\u0010A\u001a\u00020 2\u0006\u0010?\u001a\u00020,2\u0006\u0010B\u001a\u00020\"H\u0016J\b\u0010C\u001a\u00020>H\u0007J\b\u0010D\u001a\u00020>H\u0007J\b\u0010E\u001a\u00020>H\u0002J\u0010\u0010F\u001a\u00020>2\b\u0010G\u001a\u0004\u0018\u00010\u0019J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001f\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR+\u0010\u001d\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u00010\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0019\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0+0*\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u000204\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006N"}, d2={"Lcom/charlezz/pickle/PickleSharedViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "Landroidx/lifecycle/LifecycleObserver;", "Lcom/charlezz/pickle/data/entity/MediaItem$OnItemClickListener;", "app", "Landroid/app/Application;", "config", "Lcom/charlezz/pickle/Config;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Landroid/app/Application;Lcom/charlezz/pickle/Config;Landroidx/lifecycle/SavedStateHandle;)V", "getApp", "()Landroid/app/Application;", "bindingItemAdapterPosition", "Ljava/util/concurrent/atomic/AtomicInteger;", "getBindingItemAdapterPosition", "()Ljava/util/concurrent/atomic/AtomicInteger;", "cameraUtil", "Lcom/charlezz/pickle/util/CameraUtil;", "getCameraUtil", "()Lcom/charlezz/pickle/util/CameraUtil;", "getConfig", "()Lcom/charlezz/pickle/Config;", "currentFolder", "Landroidx/lifecycle/MutableLiveData;", "Lcom/charlezz/pickle/data/entity/Album;", "kotlin.jvm.PlatformType", "getCurrentFolder", "()Landroidx/lifecycle/MutableLiveData;", "itemClickEvent", "Lcom/charlezz/pickle/util/lifecycle/SingleLiveEvent;", "Lkotlin/Triple;", "Landroid/view/View;", "Lcom/charlezz/pickle/data/entity/Media;", "", "getItemClickEvent", "()Lcom/charlezz/pickle/util/lifecycle/SingleLiveEvent;", "itemCount", "Landroidx/lifecycle/LiveData;", "getItemCount", "()Landroidx/lifecycle/LiveData;", "items", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/paging/PagingData;", "Lcom/charlezz/pickle/data/entity/MediaItem;", "getItems", "()Lkotlinx/coroutines/flow/Flow;", "repository", "Lcom/charlezz/pickle/fragments/main/PickleRepository;", "getRepository", "()Lcom/charlezz/pickle/fragments/main/PickleRepository;", "selection", "Lcom/charlezz/pickle/Selection;", "getSelection", "()Lcom/charlezz/pickle/Selection;", "toolbarViewModel", "Lcom/charlezz/pickle/ToolbarViewModel;", "getToolbarViewModel", "()Lcom/charlezz/pickle/ToolbarViewModel;", "getSelectedMediaList", "", "onCheckBoxClick", "", "item", "onItemClick", "view", "position", "onPause", "onResume", "saveState", "setBucketId", "album", "validateIfExist", "", "uri", "Landroid/net/Uri;", "Companion", "Factory", "pickle_release"})
@ExperimentalCoroutinesApi
public final class PickleSharedViewModel
extends AndroidViewModel
implements LifecycleObserver,
MediaItem.OnItemClickListener {
    @NotNull
    private final PickleRepository repository;
    @NotNull
    private final CameraUtil cameraUtil;
    @NotNull
    private final Selection selection;
    @NotNull
    private final ToolbarViewModel toolbarViewModel;
    @NotNull
    private final AtomicInteger bindingItemAdapterPosition;
    @NotNull
    private final SingleLiveEvent<Triple<View, Media, Integer>> itemClickEvent;
    @NotNull
    private final Flow<PagingData<MediaItem>> items;
    @NotNull
    private final LiveData<Integer> itemCount;
    @NotNull
    private final MutableLiveData<Album> currentFolder;
    @NotNull
    private final Application app;
    @NotNull
    private final Config config;
    private final SavedStateHandle savedStateHandle;
    @NotNull
    public static final String KEY_FOLDER = "key_folder";
    @NotNull
    public static final String KEY_SAVED_SELECTION = "key_saved_selection";
    @NotNull
    public static final String KEY_SAVED_IMAGE_PATH = "KEY_SAVED_IMAGE_PATH";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PickleRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final CameraUtil getCameraUtil() {
        return this.cameraUtil;
    }

    @NotNull
    public final Selection getSelection() {
        return this.selection;
    }

    @NotNull
    public final ToolbarViewModel getToolbarViewModel() {
        return this.toolbarViewModel;
    }

    @NotNull
    public final AtomicInteger getBindingItemAdapterPosition() {
        return this.bindingItemAdapterPosition;
    }

    @NotNull
    public final SingleLiveEvent<Triple<View, Media, Integer>> getItemClickEvent() {
        return this.itemClickEvent;
    }

    @NotNull
    public final Flow<PagingData<MediaItem>> getItems() {
        return this.items;
    }

    @NotNull
    public final LiveData<Integer> getItemCount() {
        return this.itemCount;
    }

    @NotNull
    public final MutableLiveData<Album> getCurrentFolder() {
        return this.currentFolder;
    }

    @Override
    public void onItemClick(@NotNull View view, @NotNull MediaItem item, int position) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
        this.itemClickEvent.setValue((Triple<View, Media, Integer>)new Triple((Object)view, (Object)item.getMedia(), (Object)position));
    }

    @Override
    public void onCheckBoxClick(@NotNull MediaItem item) {
        Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
        this.selection.toggle(item.getId(), item.getMedia());
        item.notifyChange();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public final void onResume() {
        Timber.d((String)"onResume", (Object[])new Object[0]);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public final void onPause() {
        Timber.d((String)"onPause", (Object[])new Object[0]);
        this.saveState();
    }

    private final void saveState() {
        this.savedStateHandle.set(KEY_SAVED_SELECTION, (Object)this.selection);
        this.savedStateHandle.set(KEY_SAVED_IMAGE_PATH, (Object)this.cameraUtil.getCurrentImagePath());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Media> getSelectedMediaList() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.selection.toList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Media media = (Media)element$iv$iv;
            boolean bl = false;
            if (!this.validateIfExist(MediaKt.getUri(media))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean validateIfExist(Uri uri) {
        boolean bl;
        try {
            InputStream inputStream = this.app.getContentResolver().openInputStream(uri);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl4 = false;
                    it.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            bl = true;
        }
        catch (IOException e) {
            Timber.e((Throwable)e);
            bl = false;
        }
        return bl;
    }

    public final void setBucketId(@Nullable Album album) {
        this.savedStateHandle.set(KEY_FOLDER, (Object)album);
    }

    @NotNull
    public final Application getApp() {
        return this.app;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @AssistedInject
    public PickleSharedViewModel(@NotNull Application app, @NotNull Config config, @Assisted @NotNull SavedStateHandle savedStateHandle) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        super(app);
        this.app = app;
        this.config = config;
        this.savedStateHandle = savedStateHandle;
        this.repository = new AppPickleRepository((Context)this.app);
        CameraUtil cameraUtil = new CameraUtil((Context)this.app, this.config.getEnvironmentDir(), this.config.getDirToSave());
        boolean bl = false;
        boolean bl2 = false;
        CameraUtil cameraUtil2 = cameraUtil;
        PickleSharedViewModel pickleSharedViewModel = this;
        boolean bl3 = false;
        String savedImagePath = (String)this.savedStateHandle.get(KEY_SAVED_IMAGE_PATH);
        Timber.d((String)("savedImagePath = " + savedImagePath), (Object[])new Object[0]);
        $this$apply.setCurrentImagePath(savedImagePath);
        Unit unit = Unit.INSTANCE;
        pickleSharedViewModel.cameraUtil = cameraUtil;
        Selection selection = (Selection)this.savedStateHandle.get(KEY_SAVED_SELECTION);
        if (selection == null) {
            selection = new Selection(null, 1, null);
        }
        this.selection = selection;
        this.toolbarViewModel = new ToolbarViewModel();
        this.bindingItemAdapterPosition = new AtomicInteger(-1);
        this.itemClickEvent = new SingleLiveEvent(0L, 1, null);
        MutableLiveData mutableLiveData = this.savedStateHandle.getLiveData(KEY_FOLDER);
        Intrinsics.checkNotNullExpressionValue((Object)mutableLiveData, (String)"savedStateHandle.getLiveData<Album>(KEY_FOLDER)");
        Flow $this$flatMapLatest$iv = FlowLiveDataConversions.asFlow((LiveData)((LiveData)mutableLiveData));
        boolean $i$f$flatMapLatest = false;
        this.items = CachedPagingDataKt.cachedIn((Flow)FlowKt.transformLatest((Flow)$this$flatMapLatest$iv, (Function3)((Function3)new Function3<FlowCollector<? super PagingData<MediaItem>>, Album, Continuation<? super Unit>, Object>(null, this){
            private FlowCollector p$;
            private Object p$0;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ PickleSharedViewModel this$0;
            {
                this.this$0 = pickleSharedViewModel;
                super(3, continuation);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$emitAll$iv;
                        void flow$iv;
                        ResultKt.throwOnFailure((Object)object);
                        FlowCollector $this$transformLatest = this.p$;
                        Object it = this.p$0;
                        FlowCollector flowCollector = $this$transformLatest;
                        Continuation continuation = (Continuation)this;
                        Album album = (Album)it;
                        boolean bl = false;
                        Album album2 = album;
                        Flow<PagingData<Media>> $this$map$iv = this.this$0.getRepository().getItems(PicklePagingSource.SelectionType.IMAGE_AND_VIDEO, album2 != null ? album2.getBucketId() : null, 0, 30);
                        boolean $i$f$map = false;
                        Flow<PagingData<Media>> $this$unsafeTransform$iv$iv = $this$map$iv;
                        boolean $i$f$unsafeTransform = false;
                        boolean $i$f$unsafeFlow = false;
                        Flow flow = (Flow)new Flow<PagingData<MediaItem>>($this$unsafeTransform$iv$iv, this){
                            final /* synthetic */ Flow $this_unsafeTransform$inlined;
                            final /* synthetic */ $special$$inlined$flatMapLatest$1 this$0;
                            {
                                this.$this_unsafeTransform$inlined = flow;
                                this.this$0 = var2_2;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public Object collect(@NotNull FlowCollector flowCollector, @NotNull Continuation $completion) {
                                void $this$collect$iv;
                                void collector;
                                Continuation continuation = $completion;
                                void $receiver = collector;
                                boolean bl = false;
                                Flow flow = this.$this_unsafeTransform$inlined;
                                Continuation continuation2 = $completion;
                                boolean $i$f$collect = false;
                                Object object = $this$collect$iv.collect((FlowCollector)new FlowCollector<PagingData<Media>>((FlowCollector)$receiver, this){
                                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                                    final /* synthetic */ $special$$inlined$flatMapLatest$1$lambda$1 this$0;
                                    {
                                        this.$this_unsafeFlow$inlined = flowCollector;
                                        this.this$0 = var2_2;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                        if (!(var2_2 instanceof $special$$inlined$flatMapLatest$1$lambda$1$1$1)) ** GOTO lbl-1000
                                        var3_3 = var2_2;
                                        if ((var3_3.label & -2147483648) != 0) {
                                            var3_3.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, var2_2){
                                                /* synthetic */ Object result;
                                                int label;
                                                Object L$0;
                                                Object L$1;
                                                Object L$2;
                                                Object L$3;
                                                Object L$4;
                                                Object L$5;
                                                Object L$6;
                                                Object L$7;
                                                final /* synthetic */ $special$$inlined$flatMapLatest$1$lambda$1$1 this$0;
                                                {
                                                    this.this$0 = var1_1;
                                                    super(continuation);
                                                }

                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.emit(null, (Continuation)this);
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var6_6 = $continuation;
                                                value = value;
                                                $i$a$-collect-FlowKt__EmittersKt$unsafeTransform$1$1 = false;
                                                var9_10 = $continuation;
                                                var10_11 = value;
                                                $receiver = this.$this_unsafeFlow$inlined;
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                var13_15 = $receiver;
                                                var14_16 = (Continuation)$continuation;
                                                pagingData = (PagingData)value;
                                                $i$a$-map-PickleSharedViewModel$items$1$1 = false;
                                                var17_19 = PagingDataKt.map((PagingData)pagingData, (Function2)((Function2)new Function2<Media, Continuation<? super MediaItem>, Object>(null, this){
                                                    private /* synthetic */ Object L$0;
                                                    int label;
                                                    final /* synthetic */ $special$$inlined$flatMapLatest$1$lambda$1$1 this$0;
                                                    {
                                                        this.this$0 = var2_2;
                                                        super(2, continuation);
                                                    }

                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object object) {
                                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)object);
                                                                Media media = (Media)this.L$0;
                                                                return new MediaItem(media, this.this$0.this$0.this$0.this$0);
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    @NotNull
                                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                        Function2<Media, Continuation<? super MediaItem>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                        function2.L$0 = value;
                                                        Function2<Media, Continuation<? super MediaItem>, Object> function22 = function2;
                                                        return function22;
                                                    }

                                                    public final Object invoke(Object object, Object object2) {
                                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }));
                                                $continuation.label = 1;
                                                v0 = var13_15.emit((Object)var17_19, (Continuation)$continuation);
                                                if (v0 == var5_5) {
                                                    var18_20 = var5_5;
                                                    return var18_20;
                                                }
                                                ** GOTO lbl36
                                            }
                                            case 1: {
                                                $i$a$-collect-FlowKt__EmittersKt$unsafeTransform$1$1 = false;
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl36:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                }, continuation2);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        };
                        $special$$inlined$flatMapLatest$1 var15_15 = this;
                        boolean $i$f$emitAll = false;
                        this.label = 1;
                        Object object3 = flow$iv.collect((FlowCollector)$this$emitAll$iv, (Continuation)var15_15);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$emitAll = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @NotNull
            public final Continuation create(@NotNull FlowCollector $this$create, Object it, @NotNull Continuation continuation) {
                Function3<FlowCollector<? super PagingData<MediaItem>>, Album, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.p$ = $this$create;
                function3.p$0 = it;
                Function3<FlowCollector<? super PagingData<MediaItem>>, Album, Continuation<? super Unit>, Object> function32 = function3;
                return function32;
            }

            public final Object invoke(Object object, Object object2, Object object3) {
                return (this.create((FlowCollector)object, object2, (Continuation)object3)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this));
        this.itemCount = FlowLiveDataConversions.asLiveData$default(this.repository.getCount(), null, (long)0L, (int)3, null);
        MutableLiveData mutableLiveData2 = this.savedStateHandle.getLiveData(KEY_FOLDER);
        Intrinsics.checkNotNullExpressionValue((Object)mutableLiveData2, (String)"savedStateHandle.getLiveData<Album>(KEY_FOLDER)");
        this.currentFolder = mutableLiveData2;
        Timber.d((String)("init = " + this.hashCode()), (Object[])new Object[0]);
        if (!this.savedStateHandle.contains(KEY_FOLDER)) {
            this.savedStateHandle.set(KEY_FOLDER, null);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/charlezz/pickle/PickleSharedViewModel$Factory;", "Lcom/charlezz/pickle/util/dagger/AssistedSavedStateViewModelFactory;", "Lcom/charlezz/pickle/PickleSharedViewModel;", "pickle_release"})
    @AssistedInject.Factory
    public static interface Factory
    extends AssistedSavedStateViewModelFactory<PickleSharedViewModel> {
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/charlezz/pickle/PickleSharedViewModel$Companion;", "", "()V", "KEY_FOLDER", "", "KEY_SAVED_IMAGE_PATH", "KEY_SAVED_SELECTION", "pickle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

