/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle.util;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import androidx.annotation.DimenRes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lcom/charlezz/pickle/util/MeasureUtil;", "", "()V", "dpToPx", "", "context", "Landroid/content/Context;", "dp", "", "getNavigationBarHeight", "getProperSpanCount", "columnWidthDimen", "minSpan", "getSpanCount", "columnWidthPx", "getStatusBarHeight", "window", "Landroid/view/Window;", "getToolBarHeight", "pickle_release"})
public final class MeasureUtil {
    @NotNull
    public static final MeasureUtil INSTANCE;

    public final int getSpanCount(@NotNull Context context, int columnWidthPx) {
        DisplayMetrics displayMetrics;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        DisplayMetrics displayMetrics2 = displayMetrics = resources.getDisplayMetrics();
        boolean bl = false;
        boolean bl2 = false;
        DisplayMetrics it = displayMetrics2;
        boolean bl3 = false;
        float widthPixels = it.widthPixels;
        return (int)(widthPixels / (float)columnWidthPx);
    }

    public final int getProperSpanCount(@NotNull Context context, @DimenRes int columnWidthDimen, int minSpan) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int columnWidthPx = context.getResources().getDimensionPixelSize(columnWidthDimen);
        int n = this.getSpanCount(context, columnWidthPx);
        boolean bl = false;
        return Math.max(n, minSpan);
    }

    public static /* synthetic */ int getProperSpanCount$default(MeasureUtil measureUtil, Context context, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return measureUtil.getProperSpanCount(context, n, n2);
    }

    public final int dpToPx(@NotNull Context context, float dp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float value = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
        Timber.d((String)("dpToPx = " + value), (Object[])new Object[0]);
        return (int)value;
    }

    public final int getToolBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int[] attrs = new int[]{16843499};
        TypedArray typedArray = context.obtainStyledAttributes(attrs);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttributes(attrs)");
        TypedArray ta = typedArray;
        int toolBarHeight = ta.getDimensionPixelSize(0, -1);
        ta.recycle();
        return toolBarHeight;
    }

    public final int getStatusBarHeight(@NotNull Window window) {
        View contentView;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Rect rectangle = new Rect();
        window.getDecorView().getWindowVisibleDisplayFrame(rectangle);
        int statusBarHeight = rectangle.top;
        View view = contentView = window.findViewById(0x1020002);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"contentView");
        int contentViewTop = view.getTop();
        return statusBarHeight;
    }

    public final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        Resources resources2 = resources;
        int resourceId = resources2.getIdentifier("navigation_bar_height", "dimen", "android");
        return resourceId > 0 ? resources2.getDimensionPixelSize(resourceId) : 0;
    }

    private MeasureUtil() {
    }

    static {
        MeasureUtil measureUtil;
        INSTANCE = measureUtil = new MeasureUtil();
    }
}

