/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import androidx.core.content.FileProvider;
import com.charlezz.pickle.R;
import com.charlezz.pickle.util.DeviceUtil;
import com.charlezz.pickle.util.PickleConstants;
import com.charlezz.pickle.util.ext.ContextExtKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014J\u0014\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/charlezz/pickle/util/CameraUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "currentImagePath", "", "getCurrentImagePath", "()Ljava/lang/String;", "setCurrentImagePath", "(Ljava/lang/String;)V", "createImageFile", "Ljava/io/File;", "isImageCaptureAvailable", "", "prepareImageCapture", "", "readyToLaunch", "Lkotlin/Function1;", "Landroid/net/Uri;", "saveImageToMediaStore", "callback", "Lkotlin/Function0;", "pickle_release"})
public final class CameraUtil {
    @Nullable
    private String currentImagePath;
    @NotNull
    private final Context context;

    @Nullable
    public final String getCurrentImagePath() {
        return this.currentImagePath;
    }

    public final void setCurrentImagePath(@Nullable String string) {
        this.currentImagePath = string;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private final File createImageFile() {
        File file;
        String string = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(\"yyyyMMdd_HHmmss\").format(Date())");
        String timeStamp = string;
        String dirType = Environment.DIRECTORY_PICTURES;
        if (DeviceUtil.INSTANCE.isAndroid10Later()) {
            File file2 = this.context.getExternalFilesDir(dirType);
            if (file2 == null) {
                throw (Throwable)new IllegalArgumentException("Can't get External file directory(" + dirType + ')');
            }
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.getExternalFiles\u2026ile directory($dirType)\")");
        } else {
            File file3 = Environment.getExternalStoragePublicDirectory((String)dirType);
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"Environment.getExternalS\u2026ePublicDirectory(dirType)");
        }
        File storageDir = file;
        File file4 = File.createTempFile("Pickle_" + timeStamp + '_', ".jpg", storageDir);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file4;
        boolean bl3 = false;
        this.currentImagePath = $this$apply.getAbsolutePath();
        Timber.d((String)("path = " + $this$apply.getAbsolutePath()), (Object[])new Object[0]);
        File file5 = file4;
        Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"File.createTempFile(\n   \u2026$absolutePath\")\n        }");
        return file5;
    }

    public final boolean isImageCaptureAvailable() {
        return new Intent("android.media.action.IMAGE_CAPTURE").resolveActivity(this.context.getPackageManager()) != null;
    }

    public final void prepareImageCapture(@NotNull Function1<? super Uri, Unit> readyToLaunch) {
        block3: {
            File imageFile;
            File file;
            Intrinsics.checkNotNullParameter(readyToLaunch, (String)"readyToLaunch");
            if (!this.isImageCaptureAvailable()) break block3;
            try {
                file = this.createImageFile();
            }
            catch (IOException e) {
                ContextExtKt.showToast(this.context, R.string.toast_error_file_create);
                Timber.w((Throwable)e);
                file = null;
            }
            File file2 = imageFile = file;
            if (file2 != null) {
                file = file2;
                boolean bl = false;
                boolean bl2 = false;
                File file3 = file;
                boolean bl3 = false;
                Uri uri = FileProvider.getUriForFile((Context)this.context, (String)PickleConstants.INSTANCE.getAuthority(this.context), (File)file3);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"FileProvider.getUriForFi\u2026   file\n                )");
                Uri imageUri = uri;
                readyToLaunch.invoke((Object)imageUri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveImageToMediaStore(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        String string2 = this.currentImagePath;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String path = string3;
            boolean bl3 = false;
            File file = new File(path);
            if (DeviceUtil.INSTANCE.isAndroid10Later()) {
                Uri contentUri = MediaStore.Images.Media.getContentUri((String)"external_primary");
                ContentResolver contentResolver = this.context.getContentResolver();
                ContentValues contentValues = new ContentValues();
                boolean bl4 = false;
                boolean bl5 = false;
                ContentValues $this$apply = contentValues;
                boolean bl6 = false;
                $this$apply.put("_display_name", file.getName());
                $this$apply.put("relative_path", Environment.DIRECTORY_PICTURES + "/sub");
                $this$apply.put("is_pending", Integer.valueOf(1));
                ContentValues contentValues2 = contentValues;
                Uri imageUri = contentResolver.insert(contentUri, contentValues2);
                Timber.d((String)("insertedUri = " + imageUri), (Object[])new Object[0]);
                if (imageUri != null) {
                    Closeable closeable = (Closeable)this.context.getContentResolver().openFileDescriptor(imageUri, "w");
                    bl5 = false;
                    boolean bl7 = false;
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)closeable;
                        boolean bl8 = false;
                        new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor).write(FilesKt.readBytes((File)file));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    contentValues2.clear();
                    contentValues2.put("is_pending", Integer.valueOf(0));
                    contentResolver.update(imageUri, contentValues2, null, null);
                }
            }
            MediaScannerConnection.scanFile((Context)this.context, (String[])new String[]{this.currentImagePath}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(this, callback){
                final /* synthetic */ CameraUtil this$0;
                final /* synthetic */ Function0 $callback$inlined;
                {
                    this.this$0 = cameraUtil;
                    this.$callback$inlined = function0;
                }

                public final void onScanCompleted(String path, Uri uri) {
                    Timber.d((String)("MediaScannerConnection path = " + path + ", uri = " + uri), (Object[])new Object[0]);
                    this.$callback$inlined.invoke();
                }
            });
        } else {
            Timber.w((String)"No Image to Save", (Object[])new Object[0]);
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public CameraUtil(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }
}

