/*
 * Decompiled with CFR 0.152.
 */
package com.charlezz.pickle.data.repository;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import com.charlezz.pickle.data.entity.Media;
import com.charlezz.pickle.data.repository.PicklePagingSource$WhenMappings;
import com.charlezz.pickle.util.DeviceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ConflatedBroadcastChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001*B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J-\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010 J#\u0010!\u001a\u0004\u0018\u00010\u00022\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030#H\u0016\u00a2\u0006\u0002\u0010$J+\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Lcom/charlezz/pickle/data/repository/PicklePagingSource;", "Landroidx/paging/PagingSource;", "", "Lcom/charlezz/pickle/data/entity/Media;", "context", "Landroid/content/Context;", "bucketId", "selectionType", "Lcom/charlezz/pickle/data/repository/PicklePagingSource$SelectionType;", "countChannel", "Lkotlinx/coroutines/channels/ConflatedBroadcastChannel;", "(Landroid/content/Context;Ljava/lang/Integer;Lcom/charlezz/pickle/data/repository/PicklePagingSource$SelectionType;Lkotlinx/coroutines/channels/ConflatedBroadcastChannel;)V", "cursor", "Landroid/database/Cursor;", "jumpingSupported", "", "getJumpingSupported", "()Z", "projection", "", "", "[Ljava/lang/String;", "uri", "Landroid/net/Uri;", "kotlin.jvm.PlatformType", "closeCursor", "", "getMediaList", "", "key", "nextKey", "loadSize", "(ILjava/lang/Integer;I)Ljava/util/List;", "getRefreshKey", "state", "Landroidx/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Integer;", "load", "Landroidx/paging/PagingSource$LoadResult;", "params", "Landroidx/paging/PagingSource$LoadParams;", "(Landroidx/paging/PagingSource$LoadParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "SelectionType", "pickle_release"})
@SuppressLint(value={"RequiresApi", "InlinedApi"})
public final class PicklePagingSource
extends PagingSource<Integer, Media> {
    private final Cursor cursor;
    private final Uri uri;
    private final String[] projection;

    @Nullable
    public Object load(@NotNull PagingSource.LoadParams<Integer> params, @NotNull Continuation<? super PagingSource.LoadResult<Integer, Media>> $completion) {
        try {
            Integer prevKey;
            Integer n;
            if (this.cursor == null) {
                return new PagingSource.LoadResult.Error((Throwable)new IllegalArgumentException("Cursor is null"));
            }
            Integer n2 = (Integer)params.getKey();
            if (n2 == null) {
                return new PagingSource.LoadResult.Error((Throwable)new IllegalArgumentException("key is null"));
            }
            int key = n2;
            if (key == 0) {
                n = null;
            } else {
                int n3 = key - params.getLoadSize();
                int n4 = 0;
                boolean bl = false;
                n = prevKey = Boxing.boxInt((int)Math.max(n3, n4));
            }
            Integer nextKey = this.cursor.getCount() == key ? null : (key + params.getLoadSize() >= this.cursor.getCount() ? null : Boxing.boxInt((int)(key + params.getLoadSize())));
            Timber.d((String)("load key=" + (Integer)params.getKey() + ", loadSize=" + params.getLoadSize() + ", prevKey=" + prevKey + " nextKey=" + nextKey), (Object[])new Object[0]);
            return new PagingSource.LoadResult.Page(this.getMediaList(key, nextKey, params.getLoadSize()), (Object)prevKey, (Object)nextKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PagingSource.LoadResult.Error((Throwable)e);
        }
    }

    @Nullable
    public Integer getRefreshKey(@NotNull PagingState<Integer, Media> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Integer n = state.getAnchorPosition();
        Integer refreshKey = n != null ? Integer.valueOf(n / 30 * 30) : null;
        Timber.d((String)("refreshKey = " + refreshKey + ", anchorPosition = " + state.getAnchorPosition()), (Object[])new Object[0]);
        return refreshKey;
    }

    private final List<Media> getMediaList(int key, Integer nextKey, int loadSize) {
        ArrayList<Media> mediaList = new ArrayList<Media>();
        Cursor cursor = this.cursor;
        if (cursor != null) {
            Cursor cursor2 = cursor;
            boolean bl = false;
            boolean bl2 = false;
            Cursor cursor3 = cursor2;
            boolean bl3 = false;
            int n = loadSize;
            boolean bl4 = false;
            int n2 = 0;
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                String string2;
                Cursor $this$getIntOrNull$iv;
                Cursor $this$getLongOrNull$iv;
                String string3;
                Cursor $this$getStringOrNull$iv;
                int index$iv;
                Object object;
                int index = n2;
                boolean bl5 = false;
                if (!cursor3.moveToPosition(key + index)) continue;
                if (DeviceUtil.INSTANCE.isAndroid10Later()) {
                    object = cursor3;
                    index$iv = cursor3.getColumnIndex("relative_path");
                    boolean $i$f$getStringOrNull = false;
                    string3 = $this$getStringOrNull$iv.isNull(index$iv) ? null : $this$getStringOrNull$iv.getString(index$iv);
                } else {
                    string3 = null;
                }
                String relativePath = string3;
                Uri uri = this.uri;
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                long l = cursor3.getLong(cursor3.getColumnIndex("_id"));
                int n4 = cursor3.getInt(cursor3.getColumnIndex("media_type"));
                Intrinsics.checkNotNullExpressionValue((Object)cursor3.getString(cursor3.getColumnIndex("mime_type")), (String)"cursor.getString(cursor.\u2026s.FileColumns.MIME_TYPE))");
                $this$getStringOrNull$iv = cursor3;
                index$iv = cursor3.getColumnIndex("date_modified");
                boolean $i$f$getLongOrNull = false;
                Long l2 = $this$getLongOrNull$iv.isNull(index$iv) ? null : Long.valueOf($this$getLongOrNull$iv.getLong(index$iv));
                $this$getLongOrNull$iv = cursor3;
                index$iv = cursor3.getColumnIndex("datetaken");
                $i$f$getLongOrNull = false;
                Long l3 = $this$getLongOrNull$iv.isNull(index$iv) ? null : Long.valueOf($this$getLongOrNull$iv.getLong(index$iv));
                $this$getLongOrNull$iv = cursor3;
                index$iv = cursor3.getColumnIndex("date_added");
                $i$f$getLongOrNull = false;
                Long l4 = $this$getLongOrNull$iv.isNull(index$iv) ? null : Long.valueOf($this$getLongOrNull$iv.getLong(index$iv));
                $this$getLongOrNull$iv = cursor3;
                index$iv = cursor3.getColumnIndex("width");
                boolean $i$f$getIntOrNull = false;
                Integer n5 = $this$getIntOrNull$iv.isNull(index$iv) ? null : Integer.valueOf($this$getIntOrNull$iv.getInt(index$iv));
                $this$getIntOrNull$iv = cursor3;
                index$iv = cursor3.getColumnIndex("height");
                $i$f$getIntOrNull = false;
                Integer n6 = $this$getIntOrNull$iv.isNull(index$iv) ? null : Integer.valueOf($this$getIntOrNull$iv.getInt(index$iv));
                $this$getIntOrNull$iv = cursor3;
                index$iv = cursor3.getColumnIndex("orientation");
                $i$f$getIntOrNull = false;
                Integer n7 = $this$getIntOrNull$iv.isNull(index$iv) ? null : Integer.valueOf($this$getIntOrNull$iv.getInt(index$iv));
                $this$getIntOrNull$iv = cursor3;
                index$iv = cursor3.getColumnIndex("duration");
                $i$f$getLongOrNull = false;
                object = relativePath;
                Long l5 = $this$getLongOrNull$iv.isNull(index$iv) ? null : Long.valueOf($this$getLongOrNull$iv.getLong(index$iv));
                int n8 = cursor3.getInt(cursor3.getColumnIndex("_size"));
                Integer n9 = n7;
                Integer n10 = n6;
                Integer n11 = n5;
                Long l6 = l4;
                Long l7 = l3;
                Long l8 = l2;
                int n12 = n4;
                mediaList.add(new Media(uri, l, (String)object, n12, string2, l8, l7, l6, n11, n10, n9, n8, l5));
            }
        }
        Timber.d((String)("key = " + key + " nextKey = " + nextKey + " loadSize = " + loadSize + " mediaList.size = " + mediaList.size()), (Object[])new Object[0]);
        return mediaList;
    }

    public boolean getJumpingSupported() {
        return true;
    }

    private final void closeCursor() {
        Timber.d((String)"closeCursor", (Object[])new Object[0]);
        Cursor cursor = this.cursor;
        if (cursor != null) {
            if (!cursor.isClosed()) {
                this.cursor.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public PicklePagingSource(@NotNull Context context, @Nullable Integer bucketId, @NotNull SelectionType selectionType, @NotNull ConflatedBroadcastChannel<Integer> countChannel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        Intrinsics.checkNotNullParameter(countChannel, (String)"countChannel");
        this.uri = MediaStore.Files.getContentUri((String)"external");
        ArrayList arrayList = CollectionsKt.arrayListOf((Object[])new String[]{"_id", "media_type", "mime_type", "date_modified", "datetaken", "date_added", "width", "height", "orientation", "_size", "duration"});
        boolean bl = false;
        boolean bl2 = false;
        ArrayList arrayList2 = arrayList;
        PicklePagingSource picklePagingSource = this;
        boolean bl3 = false;
        if (DeviceUtil.INSTANCE.isAndroid10Later()) {
            void $this$apply;
            $this$apply.add("relative_path");
        }
        Unit unit = Unit.INSTANCE;
        Collection $this$toTypedArray$iv = arrayList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        picklePagingSource.projection = stringArray;
        this.registerInvalidatedCallback((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.closeCursor();
            }
        });
        Timber.d((String)("initialized:" + this.hashCode()), (Object[])new Object[0]);
        String selection = null;
        List selectionArgs = null;
        switch (PicklePagingSource$WhenMappings.$EnumSwitchMapping$0[selectionType.ordinal()]) {
            case 1: {
                selection = "media_type=?";
                selectionArgs = CollectionsKt.mutableListOf((Object[])new String[]{String.valueOf(1)});
                break;
            }
            case 2: {
                selection = "media_type=? AND mime_type!=?";
                selectionArgs = CollectionsKt.mutableListOf((Object[])new String[]{String.valueOf(1), "image/gif"});
                break;
            }
            case 3: {
                selection = "media_type=?";
                selectionArgs = CollectionsKt.mutableListOf((Object[])new String[]{String.valueOf(3)});
                break;
            }
            case 4: {
                selection = "media_type=? OR media_type=?";
                selectionArgs = CollectionsKt.mutableListOf((Object[])new String[]{String.valueOf(1), String.valueOf(3)});
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (bucketId != null) {
            selection = '(' + selection + ") AND bucket_id=?";
            selectionArgs.add(String.valueOf(bucketId));
        }
        String sortOrder = "date_modified desc";
        Collection $this$toTypedArray$iv2 = selectionArgs;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Cursor cursor = this.cursor = context.getContentResolver().query(this.uri, this.projection, selection, stringArray2, sortOrder);
        countChannel.offer((Object)(cursor != null ? Integer.valueOf(cursor.getCount()) : null));
        Cursor cursor2 = this.cursor;
        Timber.d((String)("Cursor.count = " + (cursor2 != null ? Integer.valueOf(cursor2.getCount()) : null)), (Object[])new Object[0]);
    }

    public /* synthetic */ PicklePagingSource(Context context, Integer n, SelectionType selectionType, ConflatedBroadcastChannel conflatedBroadcastChannel, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(context, n, selectionType, (ConflatedBroadcastChannel<Integer>)conflatedBroadcastChannel);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/charlezz/pickle/data/repository/PicklePagingSource$SelectionType;", "", "(Ljava/lang/String;I)V", "IMAGE", "IMAGE_AND_GIF", "VIDEO", "IMAGE_AND_VIDEO", "pickle_release"})
    public static final class SelectionType
    extends Enum<SelectionType> {
        public static final /* enum */ SelectionType IMAGE;
        public static final /* enum */ SelectionType IMAGE_AND_GIF;
        public static final /* enum */ SelectionType VIDEO;
        public static final /* enum */ SelectionType IMAGE_AND_VIDEO;
        private static final /* synthetic */ SelectionType[] $VALUES;

        static {
            SelectionType[] selectionTypeArray = new SelectionType[4];
            SelectionType[] selectionTypeArray2 = selectionTypeArray;
            selectionTypeArray[0] = IMAGE = new SelectionType();
            selectionTypeArray[1] = IMAGE_AND_GIF = new SelectionType();
            selectionTypeArray[2] = VIDEO = new SelectionType();
            selectionTypeArray[3] = IMAGE_AND_VIDEO = new SelectionType();
            $VALUES = selectionTypeArray;
        }

        public static SelectionType[] values() {
            return (SelectionType[])$VALUES.clone();
        }

        public static SelectionType valueOf(String string2) {
            return Enum.valueOf(SelectionType.class, string2);
        }
    }
}

