/*
 * Decompiled with CFR 0.152.
 */
package com.chaos.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.v7.widget.AppCompatEditText;
import android.text.InputFilter;
import android.text.TextPaint;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.chaos.view.R;

public class PinView
extends AppCompatEditText {
    private static final String TAG = "PinView";
    private static final boolean DBG = false;
    private static final int DEFAULT_COUNT = 4;
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private int mPinBoxCount;
    private float mPinBoxHeight;
    private int mPinBoxRadius;
    private int mPinBoxMargin;
    private final Paint mPaint;
    private final TextPaint mTextPaint;
    private final Paint mAnimatorTextPaint;
    private ColorStateList mBorderColor;
    private int mCurBorderColor = -16777216;
    private int mBorderWidth;
    private final Rect mTextRect = new Rect();
    private final RectF mBoxBorderRect = new RectF();
    private final Path mPath = new Path();
    private final PointF mBoxCenterPoint = new PointF();
    private ValueAnimator mDefaultAddAnimator;
    private boolean isAnimationEnable = false;

    public PinView(Context context) {
        this(context, null);
    }

    public PinView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.pinViewStyle);
    }

    public PinView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize(this.getTextSize());
        this.mAnimatorTextPaint = new TextPaint((Paint)this.mTextPaint);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.PinView, defStyleAttr, 0);
        this.mPinBoxCount = a.getInt(R.styleable.PinView_boxCount, 4);
        this.mPinBoxHeight = a.getDimensionPixelSize(R.styleable.PinView_boxHeight, res.getDimensionPixelOffset(R.dimen.pv_pin_view_box_height));
        this.mPinBoxMargin = a.getDimensionPixelOffset(R.styleable.PinView_boxMargin, res.getDimensionPixelOffset(R.dimen.pv_pin_view_box_margin));
        this.mBorderWidth = a.getDimensionPixelOffset(R.styleable.PinView_borderWidth, res.getDimensionPixelOffset(R.dimen.pv_pin_view_box_border_width));
        this.mPinBoxRadius = a.getDimensionPixelOffset(R.styleable.PinView_boxRadius, res.getDimensionPixelOffset(R.dimen.pv_pin_view_box_radius));
        this.mBorderColor = a.getColorStateList(R.styleable.PinView_borderColor);
        a.recycle();
        this.setMaxLength(this.mPinBoxCount);
        this.mPaint.setStrokeWidth((float)this.mBorderWidth);
        this.setupAnimator();
        this.setCursorVisible(false);
        this.setTextIsSelectable(false);
    }

    private void setMaxLength(int maxLength) {
        if (maxLength >= 0) {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        } else {
            this.setFilters(NO_FILTERS);
        }
    }

    private void setupAnimator() {
        this.mDefaultAddAnimator = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f});
        this.mDefaultAddAnimator.setDuration(150L);
        this.mDefaultAddAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mDefaultAddAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float scale = ((Float)animation.getAnimatedValue()).floatValue();
                int alpha = (int)(255.0f * scale);
                PinView.this.mAnimatorTextPaint.setTextSize(PinView.this.getTextSize() * scale);
                PinView.this.mAnimatorTextPaint.setAlpha(alpha);
                PinView.this.postInvalidate();
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float boxHeight = this.mPinBoxHeight;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            float boxesWidth = (float)((this.mPinBoxCount - 1) * this.mPinBoxMargin) + (float)this.mPinBoxCount * boxHeight;
            width = Math.round(boxesWidth + (float)this.getPaddingRight() + (float)this.getPaddingLeft());
        }
        int height = heightMode == 0x40000000 ? heightSize : Math.round(boxHeight + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
        this.setMeasuredDimension(width, height);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (start != text.length()) {
            this.moveCursorToEnd();
        }
        if (this.isAnimationEnable) {
            boolean isAdd;
            boolean bl = isAdd = lengthAfter - lengthBefore > 0;
            if (isAdd && this.mDefaultAddAnimator != null) {
                this.mDefaultAddAnimator.end();
                this.mDefaultAddAnimator.start();
            }
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.moveCursorToEnd();
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (selEnd != this.getText().length()) {
            this.moveCursorToEnd();
        }
    }

    private void moveCursorToEnd() {
        this.setSelection(this.getText().length());
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mBorderColor == null || this.mBorderColor.isStateful()) {
            this.updateColors();
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        this.updatePaints();
        this.drawPinView(canvas);
        canvas.restore();
    }

    private void updatePaints() {
        this.mPaint.setColor(this.mCurBorderColor);
        this.mPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mTextPaint.setColor(this.getCurrentTextColor());
    }

    private void drawPinView(Canvas canvas) {
        for (int i = 0; i < this.mPinBoxCount; ++i) {
            this.updateBoxRectF(i);
            this.updateCenterPoint();
            this.drawPinBox(canvas, i);
            if (this.getText().length() <= i) continue;
            if (PinView.isPasswordInputType(this.getInputType())) {
                this.drawCircle(canvas, i);
                continue;
            }
            this.drawText(canvas, i);
        }
    }

    private void drawPinBox(Canvas canvas, int i) {
        boolean r = true;
        boolean l = true;
        if (this.mPinBoxMargin == 0 && this.mPinBoxCount > 1) {
            if (i == 0) {
                r = false;
            } else if (i == this.mPinBoxCount - 1) {
                l = false;
            } else {
                r = false;
                l = false;
            }
        }
        this.updateRoundRectPath(this.mBoxBorderRect, this.mPinBoxRadius, this.mPinBoxRadius, l, r);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private void updateRoundRectPath(RectF rectF, float rx, float ry, boolean l, boolean r) {
        this.updateRoundRectPath(rectF, rx, ry, l, r, r, l);
    }

    private void updateRoundRectPath(RectF rectF, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        this.mPath.reset();
        float l = rectF.left;
        float t = rectF.top;
        float r = rectF.right;
        float b = rectF.bottom;
        float w = r - l;
        float h = b - t;
        float lw = w - 2.0f * rx;
        float lh = h - 2.0f * ry;
        this.mPath.moveTo(l, t + ry);
        if (tl) {
            this.mPath.rQuadTo(0.0f, -ry, rx, -ry);
        } else {
            this.mPath.rLineTo(0.0f, -ry);
            this.mPath.rLineTo(rx, 0.0f);
        }
        this.mPath.rLineTo(lw, 0.0f);
        if (tr) {
            this.mPath.rQuadTo(rx, 0.0f, rx, ry);
        } else {
            this.mPath.rLineTo(rx, 0.0f);
            this.mPath.rLineTo(0.0f, ry);
        }
        this.mPath.rLineTo(0.0f, lh);
        if (br) {
            this.mPath.rQuadTo(0.0f, ry, -rx, ry);
        } else {
            this.mPath.rLineTo(0.0f, ry);
            this.mPath.rLineTo(-rx, 0.0f);
        }
        this.mPath.rLineTo(-lw, 0.0f);
        if (bl) {
            this.mPath.rQuadTo(-rx, 0.0f, -rx, -ry);
        } else {
            this.mPath.rLineTo(-rx, 0.0f);
            this.mPath.rLineTo(0.0f, -ry);
        }
        this.mPath.rLineTo(0.0f, -lh);
        this.mPath.close();
    }

    private void updateBoxRectF(int i) {
        float startX = ((float)(this.getWidth() - (this.mPinBoxCount - 1) * this.mPinBoxMargin) - (float)this.mPinBoxCount * this.mPinBoxHeight) / 2.0f;
        float left = startX + this.mPinBoxHeight * (float)i + (float)(this.mPinBoxMargin * i) + (float)this.mBorderWidth;
        float right = left + this.mPinBoxHeight - (float)(2 * this.mBorderWidth);
        float top = this.mBorderWidth + this.getPaddingTop();
        float bottom = top + this.mPinBoxHeight - (float)(2 * this.mBorderWidth);
        this.mBoxBorderRect.set(left, top, right, bottom);
    }

    private void drawText(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        paint.getTextBounds(this.getText().toString(), i, i + 1, this.mTextRect);
        float cx = this.mBoxCenterPoint.x;
        float cy = this.mBoxCenterPoint.y;
        float x = cx - (float)(Math.abs(this.mTextRect.width()) / 2) - (float)this.mTextRect.left;
        float y = cy + (float)(Math.abs(this.mTextRect.height()) / 2) - (float)this.mTextRect.bottom;
        canvas.drawText((CharSequence)this.getText(), i, i + 1, x, y, paint);
    }

    private void drawCircle(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        float cx = this.mBoxCenterPoint.x;
        float cy = this.mBoxCenterPoint.y;
        canvas.drawCircle(cx, cy, paint.getTextSize() / 2.0f, paint);
    }

    private Paint getPaintByIndex(int i) {
        if (this.isAnimationEnable && i == this.getText().length() - 1) {
            this.mAnimatorTextPaint.setColor(this.mTextPaint.getColor());
            return this.mAnimatorTextPaint;
        }
        return this.mTextPaint;
    }

    private void drawAnchorLine(Canvas canvas) {
        float cx = this.mBoxCenterPoint.x;
        float cy = this.mBoxCenterPoint.y;
        this.mPaint.setStrokeWidth(1.0f);
        cy -= this.mPaint.getStrokeWidth() / 2.0f;
        this.mPath.reset();
        this.mPath.moveTo(cx -= this.mPaint.getStrokeWidth() / 2.0f, this.mBoxBorderRect.top);
        this.mPath.lineTo(cx, this.mBoxBorderRect.top + Math.abs(this.mBoxBorderRect.height()));
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.reset();
        this.mPath.moveTo(this.mBoxBorderRect.left, cy);
        this.mPath.lineTo(this.mBoxBorderRect.left + Math.abs(this.mBoxBorderRect.width()), cy);
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.reset();
        this.mPaint.setStrokeWidth((float)this.mBorderWidth);
    }

    private void updateColors() {
        boolean inval = false;
        int color = this.mBorderColor != null ? this.mBorderColor.getColorForState(this.getDrawableState(), 0) : this.getCurrentTextColor();
        if (color != this.mCurBorderColor) {
            this.mCurBorderColor = color;
            inval = true;
        }
        if (inval) {
            this.invalidate();
        }
    }

    private void updateCenterPoint() {
        float cx = this.mBoxBorderRect.left + Math.abs(this.mBoxBorderRect.width()) / 2.0f;
        float cy = this.mBoxBorderRect.top + Math.abs(this.mBoxBorderRect.height()) / 2.0f;
        this.mBoxCenterPoint.set(cx, cy);
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return null;
    }

    public void setBorderColor(@ColorInt int color) {
        this.mBorderColor = ColorStateList.valueOf((int)color);
        this.updateColors();
    }

    public void setBorderColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mBorderColor = colors;
        this.updateColors();
    }

    public ColorStateList getBorderColors() {
        return this.mBorderColor;
    }

    @ColorInt
    public int getCurrentBorderColor() {
        return this.mCurBorderColor;
    }

    public void setBorderWidth(@Px int borderWidth) {
        this.mBorderWidth = borderWidth;
    }

    @Px
    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBoxCount(int len) {
        this.mPinBoxCount = len;
        this.setMaxLength(len);
        this.requestLayout();
    }

    public int getBoxCount() {
        return this.mPinBoxCount;
    }

    public void setBoxRadius(@Px int pinBoxRadius) {
        this.mPinBoxRadius = pinBoxRadius;
    }

    @Px
    public int getBoxRadius() {
        return this.mPinBoxRadius;
    }

    public void setBoxMargin(@Px int pinBoxMargin) {
        this.mPinBoxMargin = pinBoxMargin;
        this.requestLayout();
    }

    @Px
    public int getBoxMargin() {
        return this.mPinBoxMargin;
    }

    public void setBoxHeight(float boxHeight) {
        this.mPinBoxHeight = boxHeight;
    }

    public float getBoxHeight() {
        return this.mPinBoxHeight;
    }

    public void setAnimationEnable(boolean enable) {
        this.isAnimationEnable = enable;
    }
}

