/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.recyclerview;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.List;

public class RecyclerAdapterWithHF
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int TYPE_MANAGER_OTHER = 0;
    public static final int TYPE_MANAGER_LINEAR = 1;
    public static final int TYPE_MANAGER_GRID = 2;
    public static final int TYPE_MANAGER_STAGGERED_GRID = 3;
    public static final int TYPE_HEADER = 7898;
    public static final int TYPE_FOOTER = 7899;
    private List<View> mHeaders = new ArrayList<View>();
    private List<View> mFooters = new ArrayList<View>();
    private int mManagerType;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;
    private RecyclerView.Adapter<RecyclerView.ViewHolder> mAdapter;
    private RecyclerView.AdapterDataObserver adapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            RecyclerAdapterWithHF.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            RecyclerAdapterWithHF.this.notifyItemRangeChanged(positionStart + RecyclerAdapterWithHF.this.getHeadSize(), itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            RecyclerAdapterWithHF.this.notifyItemRangeInserted(positionStart + RecyclerAdapterWithHF.this.getHeadSize(), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            RecyclerAdapterWithHF.this.notifyItemRangeRemoved(positionStart + RecyclerAdapterWithHF.this.getHeadSize(), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            RecyclerAdapterWithHF.this.notifyItemMoved(fromPosition + RecyclerAdapterWithHF.this.getHeadSize(), toPosition + RecyclerAdapterWithHF.this.getHeadSize());
        }
    };

    public int getHeadSize() {
        return this.mHeaders.size();
    }

    public int getFootSize() {
        return this.mFooters.size();
    }

    public int getManagerType() {
        return this.mManagerType;
    }

    public void notifyDataSetChangedHF() {
        this.notifyDataSetChanged();
    }

    public void notifyItemChangedHF(int position) {
        this.notifyItemChanged(this.getRealPosition(position));
    }

    public void notifyItemMovedHF(int fromPosition, int toPosition) {
        this.notifyItemMovedHF(this.getRealPosition(fromPosition), this.getRealPosition(toPosition));
    }

    public void notifyItemRangeChangedHF(int positionStart, int itemCount) {
        this.notifyItemRangeChanged(this.getRealPosition(positionStart), itemCount);
    }

    public void notifyItemRangeRemovedHF(int positionStart, int itemCount) {
        this.notifyItemRangeRemoved(this.getRealPosition(positionStart), itemCount);
    }

    public void notifyItemRemovedHF(int position) {
        this.notifyItemRemoved(this.getRealPosition(position));
    }

    public void notifyItemInsertedHF(int position) {
        this.notifyItemInserted(this.getRealPosition(position));
    }

    public void notifyItemRangeInsertedHF(int positionStart, int itemCount) {
        this.notifyItemRangeInserted(this.getRealPosition(positionStart), itemCount);
    }

    public final long getItemId(int position) {
        return this.getItemIdHF(this.getRealPosition(position));
    }

    public long getItemIdHF(int position) {
        return this.mAdapter.getItemId(position);
    }

    public RecyclerView.ViewHolder onCreateViewHolderHF(ViewGroup viewGroup, int type) {
        return this.mAdapter.onCreateViewHolder(viewGroup, type);
    }

    public final RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int type) {
        if (type != 7898 && type != 7899) {
            RecyclerView.ViewHolder vh = this.onCreateViewHolderHF(viewGroup, type);
            return vh;
        }
        FrameLayout frameLayout = new FrameLayout(viewGroup.getContext());
        frameLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        return new HeaderFooterViewHolder((View)frameLayout);
    }

    public final void onBindViewHolder(RecyclerView.ViewHolder vh, int position) {
        if (this.isHeader(position)) {
            View v = this.mHeaders.get(position);
            this.prepareHeaderFooter((HeaderFooterViewHolder)vh, v);
        } else if (this.isFooter(position)) {
            View v = this.mFooters.get(position - this.getItemCountHF() - this.mHeaders.size());
            this.prepareHeaderFooter((HeaderFooterViewHolder)vh, v);
        } else {
            vh.itemView.setOnClickListener((View.OnClickListener)new MyOnClickListener(vh));
            vh.itemView.setOnLongClickListener((View.OnLongClickListener)new MyOnLongClickListener(vh));
            this.onBindViewHolderHF(vh, this.getRealPosition(position));
        }
    }

    public int getRealPosition(int position) {
        return position - this.mHeaders.size();
    }

    public void onBindViewHolderHF(RecyclerView.ViewHolder vh, int position) {
        this.mAdapter.onBindViewHolder(vh, position);
    }

    private void prepareHeaderFooter(HeaderFooterViewHolder vh, View view) {
        if (this.mManagerType == 3) {
            StaggeredGridLayoutManager.LayoutParams layoutParams = new StaggeredGridLayoutManager.LayoutParams(-1, -1);
            layoutParams.setFullSpan(true);
            vh.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (view.getParent() != null) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
        vh.base.removeAllViews();
        vh.base.addView(view);
    }

    private boolean isHeader(int position) {
        return position < this.mHeaders.size();
    }

    private boolean isFooter(int position) {
        return position >= this.mHeaders.size() + this.getItemCountHF();
    }

    public final int getItemCount() {
        return this.mHeaders.size() + this.getItemCountHF() + this.mFooters.size();
    }

    public int getItemCountHF() {
        return this.mAdapter.getItemCount();
    }

    public final int getItemViewType(int position) {
        if (this.isHeader(position)) {
            return 7898;
        }
        if (this.isFooter(position)) {
            return 7899;
        }
        int type = this.getItemViewTypeHF(this.getRealPosition(position));
        if (type == 7898 || type == 7899) {
            throw new IllegalArgumentException("Item type cannot equal 7898 or 7899");
        }
        return type;
    }

    public int getItemViewTypeHF(int position) {
        return this.mAdapter.getItemViewType(position);
    }

    public void addHeader(View header) {
        if (!this.mHeaders.contains(header)) {
            this.mHeaders.add(header);
            this.notifyItemInserted(this.mHeaders.size() - 1);
        }
    }

    public void removeHeader(View header) {
        if (this.mHeaders.contains(header)) {
            this.notifyItemRemoved(this.mHeaders.indexOf(header));
            this.mHeaders.remove(header);
        }
    }

    public void addFooter(View footer) {
        if (!this.mFooters.contains(footer)) {
            this.mFooters.add(footer);
            this.notifyItemInserted(this.mHeaders.size() + this.getItemCountHF() + this.mFooters.size() - 1);
        }
    }

    public void removeFooter(View footer) {
        if (this.mFooters.contains(footer)) {
            this.notifyItemRemoved(this.mHeaders.size() + this.getItemCountHF() + this.mFooters.indexOf(footer));
            this.mFooters.remove(footer);
        }
    }

    public OnItemClickListener getOnItemClickListener() {
        return this.onItemClickListener;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        Log.d((String)"eeee", (String)("setOnItemClickListener " + this.onItemClickListener));
    }

    public OnItemLongClickListener getOnItemLongClickListener() {
        return this.onItemLongClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    protected void onItemClick(RecyclerView.ViewHolder vh, int position) {
    }

    protected void onItemLongClick(RecyclerView.ViewHolder vh, int position) {
    }

    public RecyclerAdapterWithHF(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        this.mAdapter = adapter;
        adapter.registerAdapterDataObserver(this.adapterDataObserver);
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(RecyclerAdapterWithHF var1, RecyclerView.ViewHolder var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(RecyclerAdapterWithHF var1, RecyclerView.ViewHolder var2, int var3);
    }

    private class MyOnLongClickListener
    implements View.OnLongClickListener {
        private RecyclerView.ViewHolder vh;

        public MyOnLongClickListener(RecyclerView.ViewHolder vh) {
            this.vh = vh;
        }

        public boolean onLongClick(View v) {
            int position = RecyclerAdapterWithHF.this.getRealPosition(this.vh.getLayoutPosition());
            if (RecyclerAdapterWithHF.this.onItemLongClickListener != null) {
                RecyclerAdapterWithHF.this.onItemLongClickListener.onItemLongClick(RecyclerAdapterWithHF.this, this.vh, position);
            }
            RecyclerAdapterWithHF.this.onItemLongClick(this.vh, position);
            return true;
        }
    }

    private class MyOnClickListener
    implements View.OnClickListener {
        private RecyclerView.ViewHolder vh;

        public MyOnClickListener(RecyclerView.ViewHolder vh) {
            this.vh = vh;
        }

        public void onClick(View v) {
            int position = RecyclerAdapterWithHF.this.getRealPosition(this.vh.getLayoutPosition());
            if (RecyclerAdapterWithHF.this.onItemClickListener != null) {
                RecyclerAdapterWithHF.this.onItemClickListener.onItemClick(RecyclerAdapterWithHF.this, this.vh, position);
            }
            RecyclerAdapterWithHF.this.onItemClick(this.vh, position);
        }
    }

    public static class HeaderFooterViewHolder
    extends RecyclerView.ViewHolder {
        FrameLayout base;

        public HeaderFooterViewHolder(View itemView) {
            super(itemView);
            this.base = (FrameLayout)itemView;
        }
    }
}

