/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.loadmore;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListView;
import com.chanven.lib.cptr.loadmore.ILoadMoreViewFactory;
import com.chanven.lib.cptr.loadmore.LoadMoreHandler;
import com.chanven.lib.cptr.loadmore.OnScrollBottomListener;

public class ListViewHandler
implements LoadMoreHandler {
    private ListView mListView;
    private View mFooter;

    @Override
    public boolean handleSetAdapter(View contentView, ILoadMoreViewFactory.ILoadMoreView loadMoreView, View.OnClickListener onClickLoadMoreListener) {
        ListView listView;
        this.mListView = listView = (ListView)contentView;
        boolean hasInit = false;
        if (loadMoreView != null) {
            final Context context = listView.getContext().getApplicationContext();
            loadMoreView.init(new ILoadMoreViewFactory.FootViewAdder(){

                @Override
                public View addFootView(int layoutId) {
                    View view = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)listView, false);
                    ListViewHandler.this.mFooter = view;
                    return this.addFootView(view);
                }

                @Override
                public View addFootView(View view) {
                    listView.addFooterView(view);
                    return view;
                }
            }, onClickLoadMoreListener);
            hasInit = true;
        }
        return hasInit;
    }

    @Override
    public void setOnScrollBottomListener(View contentView, OnScrollBottomListener onScrollBottomListener) {
        ListView listView = (ListView)contentView;
        listView.setOnScrollListener((AbsListView.OnScrollListener)new ListViewOnScrollListener(onScrollBottomListener));
        listView.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new ListViewOnItemSelectedListener(onScrollBottomListener));
    }

    @Override
    public void removeFooter() {
        if (this.mListView.getFooterViewsCount() > 0 && null != this.mFooter) {
            this.mListView.removeFooterView(this.mFooter);
        }
    }

    @Override
    public void addFooter() {
        if (this.mListView.getFooterViewsCount() <= 0 && null != this.mFooter) {
            this.mListView.addFooterView(this.mFooter);
        }
    }

    private static class ListViewOnScrollListener
    implements AbsListView.OnScrollListener {
        private OnScrollBottomListener onScrollBottomListener;

        public ListViewOnScrollListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onScrollStateChanged(AbsListView listView, int scrollState) {
            if (scrollState == 0 && listView.getLastVisiblePosition() + 1 == listView.getCount() && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }
    }

    private class ListViewOnItemSelectedListener
    implements AdapterView.OnItemSelectedListener {
        private OnScrollBottomListener onScrollBottomListener;

        public ListViewOnItemSelectedListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onItemSelected(AdapterView<?> listView, View view, int position, long id2) {
            if (listView.getLastVisiblePosition() + 1 == listView.getCount() && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }
    }
}

