/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.Scroller;
import android.widget.TextView;
import com.chanven.lib.cptr.PtrHandler;
import com.chanven.lib.cptr.PtrUIHandler;
import com.chanven.lib.cptr.PtrUIHandlerHolder;
import com.chanven.lib.cptr.PtrUIHandlerHook;
import com.chanven.lib.cptr.R;
import com.chanven.lib.cptr.indicator.PtrIndicator;
import com.chanven.lib.cptr.loadmore.DefaultLoadMoreViewFooter;
import com.chanven.lib.cptr.loadmore.GridViewHandler;
import com.chanven.lib.cptr.loadmore.ILoadMoreViewFactory;
import com.chanven.lib.cptr.loadmore.ListViewHandler;
import com.chanven.lib.cptr.loadmore.LoadMoreHandler;
import com.chanven.lib.cptr.loadmore.OnLoadMoreListener;
import com.chanven.lib.cptr.loadmore.OnScrollBottomListener;
import com.chanven.lib.cptr.loadmore.RecyclerViewHandler;
import com.chanven.lib.cptr.utils.PtrCLog;

public class PtrFrameLayout
extends ViewGroup {
    public static final byte PTR_STATUS_INIT = 1;
    public static final byte PTR_STATUS_PREPARE = 2;
    public static final byte PTR_STATUS_LOADING = 3;
    public static final byte PTR_STATUS_COMPLETE = 4;
    private static final boolean DEBUG_LAYOUT = true;
    public static boolean DEBUG = false;
    private static int ID = 1;
    private static byte FLAG_AUTO_REFRESH_AT_ONCE = 1;
    private static byte FLAG_AUTO_REFRESH_BUT_LATER = (byte)2;
    private static byte FLAG_ENABLE_NEXT_PTR_AT_ONCE = (byte)4;
    private static byte FLAG_PIN_CONTENT = (byte)8;
    private static byte MASK_AUTO_REFRESH = (byte)3;
    protected final String LOG_TAG = "ptr-frame-" + ++ID;
    protected View mContent;
    private int mHeaderId = 0;
    private int mContainerId = 0;
    private int mDurationToClose = 200;
    private int mDurationToCloseHeader = 1000;
    private boolean mKeepHeaderWhenRefresh = true;
    private boolean mPullToRefresh = false;
    private View mHeaderView;
    private PtrUIHandlerHolder mPtrUIHandlerHolder = PtrUIHandlerHolder.create();
    private PtrHandler mPtrHandler;
    private ScrollChecker mScrollChecker;
    private int mPagingTouchSlop;
    private int mHeaderHeight;
    private byte mStatus = 1;
    private boolean mDisableWhenHorizontalMove = false;
    private int mFlag = 0;
    private boolean mPreventForHorizontal = false;
    private MotionEvent mLastMoveEvent;
    private PtrUIHandlerHook mRefreshCompleteHook;
    private int mLoadingMinTime = 500;
    private long mLoadingStartTime = 0L;
    private PtrIndicator mPtrIndicator;
    private boolean mHasSendCancelEvent = false;
    private boolean isLoadingMore = false;
    private boolean isAutoLoadMoreEnable = true;
    private boolean isLoadMoreEnable = false;
    private boolean hasInitLoadMoreView = false;
    private ILoadMoreViewFactory loadMoreViewFactory;
    private ILoadMoreViewFactory.ILoadMoreView mLoadMoreView;
    private LoadMoreHandler mLoadMoreHandler;
    private View mContentView;
    private OnScrollBottomListener onScrollBottomListener = new OnScrollBottomListener(){

        @Override
        public void onScorllBootom() {
            if (PtrFrameLayout.this.isAutoLoadMoreEnable && PtrFrameLayout.this.isLoadMoreEnable && !PtrFrameLayout.this.isLoadingMore()) {
                PtrFrameLayout.this.loadMore();
            }
        }
    };
    private View.OnClickListener onClickLoadMoreListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (PtrFrameLayout.this.isLoadMoreEnable && !PtrFrameLayout.this.isLoadingMore()) {
                PtrFrameLayout.this.loadMore();
            }
        }
    };
    OnLoadMoreListener mOnLoadMoreListener;

    public PtrFrameLayout(Context context) {
        this(context, null);
    }

    public PtrFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PtrFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mPtrIndicator = new PtrIndicator();
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.PtrFrameLayout, 0, 0);
        if (arr != null) {
            this.mHeaderId = arr.getResourceId(R.styleable.PtrFrameLayout_ptr_header, this.mHeaderId);
            this.mContainerId = arr.getResourceId(R.styleable.PtrFrameLayout_ptr_content, this.mContainerId);
            this.mPtrIndicator.setResistance(arr.getFloat(R.styleable.PtrFrameLayout_ptr_resistance, this.mPtrIndicator.getResistance()));
            this.mDurationToClose = arr.getInt(R.styleable.PtrFrameLayout_ptr_duration_to_close, this.mDurationToClose);
            this.mDurationToCloseHeader = arr.getInt(R.styleable.PtrFrameLayout_ptr_duration_to_close_header, this.mDurationToCloseHeader);
            float ratio = this.mPtrIndicator.getRatioOfHeaderToHeightRefresh();
            ratio = arr.getFloat(R.styleable.PtrFrameLayout_ptr_ratio_of_header_height_to_refresh, ratio);
            this.mPtrIndicator.setRatioOfHeaderHeightToRefresh(ratio);
            this.mKeepHeaderWhenRefresh = arr.getBoolean(R.styleable.PtrFrameLayout_ptr_keep_header_when_refresh, this.mKeepHeaderWhenRefresh);
            this.mPullToRefresh = arr.getBoolean(R.styleable.PtrFrameLayout_ptr_pull_to_fresh, this.mPullToRefresh);
            arr.recycle();
        }
        this.mScrollChecker = new ScrollChecker();
        ViewConfiguration conf = ViewConfiguration.get((Context)this.getContext());
        this.mPagingTouchSlop = conf.getScaledTouchSlop() * 2;
    }

    protected void onFinishInflate() {
        int childCount = this.getChildCount();
        if (childCount > 2) {
            throw new IllegalStateException("PtrFrameLayout only can host 2 elements");
        }
        if (childCount == 2) {
            if (this.mHeaderId != 0 && this.mHeaderView == null) {
                this.mHeaderView = this.findViewById(this.mHeaderId);
            }
            if (this.mContainerId != 0 && this.mContent == null) {
                this.mContent = this.findViewById(this.mContainerId);
            }
            if (this.mContent == null || this.mHeaderView == null) {
                View child1 = this.getChildAt(0);
                View child2 = this.getChildAt(1);
                if (child1 instanceof PtrUIHandler) {
                    this.mHeaderView = child1;
                    this.mContent = child2;
                } else if (child2 instanceof PtrUIHandler) {
                    this.mHeaderView = child2;
                    this.mContent = child1;
                } else if (this.mContent == null && this.mHeaderView == null) {
                    this.mHeaderView = child1;
                    this.mContent = child2;
                } else if (this.mHeaderView == null) {
                    this.mHeaderView = this.mContent == child1 ? child2 : child1;
                } else {
                    this.mContent = this.mHeaderView == child1 ? child2 : child1;
                }
            }
        } else if (childCount == 1) {
            this.mContent = this.getChildAt(0);
        } else {
            TextView errorView = new TextView(this.getContext());
            errorView.setClickable(true);
            errorView.setTextColor(-39424);
            errorView.setGravity(17);
            errorView.setTextSize(20.0f);
            errorView.setText((CharSequence)"The content view in PtrFrameLayout is empty. Do you forget to specify its id in xml layout file?");
            this.mContent = errorView;
            this.addView(this.mContent);
        }
        if (this.mHeaderView != null) {
            this.mHeaderView.bringToFront();
        }
        super.onFinishInflate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.MarginLayoutParams lp;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (DEBUG) {
            PtrCLog.d(this.LOG_TAG, "onMeasure frame: width: %s, height: %s, padding: %s %s %s %s", this.getMeasuredHeight(), this.getMeasuredWidth(), this.getPaddingLeft(), this.getPaddingRight(), this.getPaddingTop(), this.getPaddingBottom());
        }
        if (this.mHeaderView != null) {
            this.measureChildWithMargins(this.mHeaderView, widthMeasureSpec, 0, heightMeasureSpec, 0);
            lp = (ViewGroup.MarginLayoutParams)this.mHeaderView.getLayoutParams();
            this.mHeaderHeight = this.mHeaderView.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            this.mPtrIndicator.setHeaderHeight(this.mHeaderHeight);
        }
        if (this.mContent != null) {
            this.measureContentView(this.mContent, widthMeasureSpec, heightMeasureSpec);
            if (DEBUG) {
                lp = (ViewGroup.MarginLayoutParams)this.mContent.getLayoutParams();
                PtrCLog.d(this.LOG_TAG, "onMeasure content, width: %s, height: %s, margin: %s %s %s %s", this.getMeasuredWidth(), this.getMeasuredHeight(), lp.leftMargin, lp.topMargin, lp.rightMargin, lp.bottomMargin);
                PtrCLog.d(this.LOG_TAG, "onMeasure, currentPos: %s, lastPos: %s, top: %s", this.mPtrIndicator.getCurrentPosY(), this.mPtrIndicator.getLastPosY(), this.mContent.getTop());
            }
        }
    }

    private void measureContentView(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = PtrFrameLayout.getChildMeasureSpec((int)parentWidthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
        int childHeightMeasureSpec = PtrFrameLayout.getChildMeasureSpec((int)parentHeightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin), (int)lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void onLayout(boolean flag, int i, int j, int k, int l) {
        this.layoutChildren();
    }

    private void layoutChildren() {
        int bottom;
        int right;
        int top;
        int left;
        ViewGroup.MarginLayoutParams lp;
        int offsetX = this.mPtrIndicator.getCurrentPosY();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        if (this.mHeaderView != null) {
            lp = (ViewGroup.MarginLayoutParams)this.mHeaderView.getLayoutParams();
            left = paddingLeft + lp.leftMargin;
            top = paddingTop + lp.topMargin + offsetX - this.mHeaderHeight;
            right = left + this.mHeaderView.getMeasuredWidth();
            bottom = top + this.mHeaderView.getMeasuredHeight();
            this.mHeaderView.layout(left, top, right, bottom);
            if (DEBUG) {
                PtrCLog.d(this.LOG_TAG, "onLayout header: %s %s %s %s", left, top, right, bottom);
            }
        }
        if (this.mContent != null) {
            if (this.isPinContent()) {
                offsetX = 0;
            }
            lp = (ViewGroup.MarginLayoutParams)this.mContent.getLayoutParams();
            left = paddingLeft + lp.leftMargin;
            top = paddingTop + lp.topMargin + offsetX;
            right = left + this.mContent.getMeasuredWidth();
            bottom = top + this.mContent.getMeasuredHeight();
            if (DEBUG) {
                PtrCLog.d(this.LOG_TAG, "onLayout content: %s %s %s %s", left, top, right, bottom);
            }
            this.mContent.layout(left, top, right, bottom);
        }
    }

    public boolean dispatchTouchEventSupper(MotionEvent e) {
        return super.dispatchTouchEvent(e);
    }

    public boolean dispatchTouchEvent(MotionEvent e) {
        if (!this.isEnabled() || this.mContent == null || this.mHeaderView == null) {
            return this.dispatchTouchEventSupper(e);
        }
        int action = e.getAction();
        switch (action) {
            case 1: 
            case 3: {
                this.mPtrIndicator.onRelease();
                if (this.mPtrIndicator.hasLeftStartPosition()) {
                    if (DEBUG) {
                        PtrCLog.d(this.LOG_TAG, "call onRelease when user release");
                    }
                    this.onRelease(false);
                    if (this.mPtrIndicator.hasMovedAfterPressedDown()) {
                        this.sendCancelEvent();
                        return true;
                    }
                    return this.dispatchTouchEventSupper(e);
                }
                return this.dispatchTouchEventSupper(e);
            }
            case 0: {
                this.mHasSendCancelEvent = false;
                this.mPtrIndicator.onPressDown(e.getX(), e.getY());
                this.mScrollChecker.abortIfWorking();
                this.mPreventForHorizontal = false;
                this.dispatchTouchEventSupper(e);
                return true;
            }
            case 2: {
                this.mLastMoveEvent = e;
                this.mPtrIndicator.onMove(e.getX(), e.getY());
                float offsetX = this.mPtrIndicator.getOffsetX();
                float offsetY = this.mPtrIndicator.getOffsetY();
                if (this.mDisableWhenHorizontalMove && !this.mPreventForHorizontal && Math.abs(offsetX) > (float)this.mPagingTouchSlop && Math.abs(offsetX) > Math.abs(offsetY) && this.mPtrIndicator.isInStartPosition()) {
                    this.mPreventForHorizontal = true;
                }
                if (this.mPreventForHorizontal) {
                    return this.dispatchTouchEventSupper(e);
                }
                boolean moveDown = offsetY > 0.0f;
                boolean moveUp = !moveDown;
                boolean canMoveUp = this.mPtrIndicator.hasLeftStartPosition();
                if (DEBUG) {
                    boolean canMoveDown = this.mPtrHandler != null && this.mPtrHandler.checkCanDoRefresh(this, this.mContent, this.mHeaderView);
                    PtrCLog.v(this.LOG_TAG, "ACTION_MOVE: offsetY:%s, currentPos: %s, moveUp: %s, canMoveUp: %s, moveDown: %s: canMoveDown: %s", Float.valueOf(offsetY), this.mPtrIndicator.getCurrentPosY(), moveUp, canMoveUp, moveDown, canMoveDown);
                }
                if (moveDown && this.mPtrHandler != null && !this.mPtrHandler.checkCanDoRefresh(this, this.mContent, this.mHeaderView)) {
                    return this.dispatchTouchEventSupper(e);
                }
                if ((!moveUp || !canMoveUp) && !moveDown) break;
                this.movePos(offsetY);
                return true;
            }
        }
        return this.dispatchTouchEventSupper(e);
    }

    private void movePos(float deltaY) {
        if (deltaY < 0.0f && this.mPtrIndicator.isInStartPosition()) {
            if (DEBUG) {
                PtrCLog.e(this.LOG_TAG, String.format("has reached the top", new Object[0]));
            }
            return;
        }
        int to = this.mPtrIndicator.getCurrentPosY() + (int)deltaY;
        if (this.mPtrIndicator.willOverTop(to)) {
            if (DEBUG) {
                PtrCLog.e(this.LOG_TAG, String.format("over top", new Object[0]));
            }
            to = 0;
        }
        this.mPtrIndicator.setCurrentPos(to);
        int change = to - this.mPtrIndicator.getLastPosY();
        this.updatePos(change);
    }

    private void updatePos(int change) {
        if (change == 0) {
            return;
        }
        boolean isUnderTouch = this.mPtrIndicator.isUnderTouch();
        if (isUnderTouch && !this.mHasSendCancelEvent && this.mPtrIndicator.hasMovedAfterPressedDown()) {
            this.mHasSendCancelEvent = true;
            this.sendCancelEvent();
        }
        if (this.mPtrIndicator.hasJustLeftStartPosition() && this.mStatus == 1 || this.mPtrIndicator.goDownCrossFinishPosition() && this.mStatus == 4 && this.isEnabledNextPtrAtOnce()) {
            this.mStatus = (byte)2;
            this.mPtrUIHandlerHolder.onUIRefreshPrepare(this);
            if (DEBUG) {
                PtrCLog.i(this.LOG_TAG, "PtrUIHandler: onUIRefreshPrepare, mFlag %s", this.mFlag);
            }
        }
        if (this.mPtrIndicator.hasJustBackToStartPosition()) {
            this.tryToNotifyReset();
            if (isUnderTouch) {
                this.sendDownEvent();
            }
        }
        if (this.mStatus == 2) {
            if (isUnderTouch && !this.isAutoRefresh() && this.mPullToRefresh && this.mPtrIndicator.crossRefreshLineFromTopToBottom()) {
                this.tryToPerformRefresh();
            }
            if (this.performAutoRefreshButLater() && this.mPtrIndicator.hasJustReachedHeaderHeightFromTopToBottom()) {
                this.tryToPerformRefresh();
            }
        }
        if (DEBUG) {
            PtrCLog.v(this.LOG_TAG, "updatePos: change: %s, current: %s last: %s, top: %s, headerHeight: %s", change, this.mPtrIndicator.getCurrentPosY(), this.mPtrIndicator.getLastPosY(), this.mContent.getTop(), this.mHeaderHeight);
        }
        this.mHeaderView.offsetTopAndBottom(change);
        if (!this.isPinContent()) {
            this.mContent.offsetTopAndBottom(change);
        }
        this.invalidate();
        if (this.mPtrUIHandlerHolder.hasHandler()) {
            this.mPtrUIHandlerHolder.onUIPositionChange(this, isUnderTouch, this.mStatus, this.mPtrIndicator);
        }
        this.onPositionChange(isUnderTouch, this.mStatus, this.mPtrIndicator);
    }

    protected void onPositionChange(boolean isInTouching, byte status, PtrIndicator mPtrIndicator) {
    }

    public int getHeaderHeight() {
        return this.mHeaderHeight;
    }

    private void onRelease(boolean stayForLoading) {
        this.tryToPerformRefresh();
        if (this.mStatus == 3) {
            if (this.mKeepHeaderWhenRefresh) {
                if (this.mPtrIndicator.isOverOffsetToKeepHeaderWhileLoading() && !stayForLoading) {
                    this.mScrollChecker.tryToScrollTo(this.mPtrIndicator.getOffsetToKeepHeaderWhileLoading(), this.mDurationToClose);
                }
            } else {
                this.tryScrollBackToTopWhileLoading();
            }
        } else if (this.mStatus == 4) {
            this.notifyUIRefreshComplete(false);
        } else {
            this.tryScrollBackToTopAbortRefresh();
        }
    }

    public void setRefreshCompleteHook(PtrUIHandlerHook hook) {
        this.mRefreshCompleteHook = hook;
        hook.setResumeAction(new Runnable(){

            @Override
            public void run() {
                if (DEBUG) {
                    PtrCLog.d(PtrFrameLayout.this.LOG_TAG, "mRefreshCompleteHook resume.");
                }
                PtrFrameLayout.this.notifyUIRefreshComplete(true);
            }
        });
    }

    private void tryScrollBackToTop() {
        if (!this.mPtrIndicator.isUnderTouch()) {
            this.mScrollChecker.tryToScrollTo(0, this.mDurationToCloseHeader);
        }
    }

    private void tryScrollBackToTopWhileLoading() {
        this.tryScrollBackToTop();
    }

    private void tryScrollBackToTopAfterComplete() {
        this.tryScrollBackToTop();
    }

    private void tryScrollBackToTopAbortRefresh() {
        this.tryScrollBackToTop();
    }

    private boolean tryToPerformRefresh() {
        if (this.mStatus != 2) {
            return false;
        }
        if (this.mPtrIndicator.isOverOffsetToKeepHeaderWhileLoading() && this.isAutoRefresh() || this.mPtrIndicator.isOverOffsetToRefresh()) {
            this.mStatus = (byte)3;
            this.performRefresh();
        }
        return false;
    }

    private void performRefresh() {
        this.mLoadingStartTime = System.currentTimeMillis();
        if (this.mPtrUIHandlerHolder.hasHandler()) {
            this.mPtrUIHandlerHolder.onUIRefreshBegin(this);
            if (DEBUG) {
                PtrCLog.i(this.LOG_TAG, "PtrUIHandler: onUIRefreshBegin");
            }
        }
        if (this.mPtrHandler != null) {
            this.mPtrHandler.onRefreshBegin(this);
        }
    }

    private boolean tryToNotifyReset() {
        if ((this.mStatus == 4 || this.mStatus == 2) && this.mPtrIndicator.isInStartPosition()) {
            if (this.mPtrUIHandlerHolder.hasHandler()) {
                this.mPtrUIHandlerHolder.onUIReset(this);
                if (DEBUG) {
                    PtrCLog.i(this.LOG_TAG, "PtrUIHandler: onUIReset");
                }
            }
            this.mStatus = 1;
            this.clearFlag();
            return true;
        }
        return false;
    }

    protected void onPtrScrollAbort() {
        if (this.mPtrIndicator.hasLeftStartPosition() && this.isAutoRefresh()) {
            if (DEBUG) {
                PtrCLog.d(this.LOG_TAG, "call onRelease after scroll abort");
            }
            this.onRelease(true);
        }
    }

    protected void onPtrScrollFinish() {
        if (this.mPtrIndicator.hasLeftStartPosition() && this.isAutoRefresh()) {
            if (DEBUG) {
                PtrCLog.d(this.LOG_TAG, "call onRelease after scroll finish");
            }
            this.onRelease(true);
        }
    }

    public boolean isRefreshing() {
        return this.mStatus == 3;
    }

    public final void refreshComplete() {
        int delay;
        if (DEBUG) {
            PtrCLog.i(this.LOG_TAG, "refreshComplete");
        }
        if (this.mRefreshCompleteHook != null) {
            this.mRefreshCompleteHook.reset();
        }
        if ((delay = (int)((long)this.mLoadingMinTime - (System.currentTimeMillis() - this.mLoadingStartTime))) <= 0) {
            if (DEBUG) {
                PtrCLog.d(this.LOG_TAG, "performRefreshComplete at once");
            }
            this.performRefreshComplete();
        } else {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PtrFrameLayout.this.performRefreshComplete();
                }
            }, delay);
            if (DEBUG) {
                PtrCLog.d(this.LOG_TAG, "performRefreshComplete after delay: %s", delay);
            }
        }
    }

    private void performRefreshComplete() {
        this.mStatus = (byte)4;
        if (this.mScrollChecker.mIsRunning && this.isAutoRefresh()) {
            if (DEBUG) {
                PtrCLog.d(this.LOG_TAG, "performRefreshComplete do nothing, scrolling: %s, auto refresh: %s", this.mScrollChecker.mIsRunning, this.mFlag);
            }
            return;
        }
        this.notifyUIRefreshComplete(false);
    }

    private void notifyUIRefreshComplete(boolean ignoreHook) {
        if (this.mPtrIndicator.hasLeftStartPosition() && !ignoreHook && this.mRefreshCompleteHook != null) {
            if (DEBUG) {
                PtrCLog.d(this.LOG_TAG, "notifyUIRefreshComplete mRefreshCompleteHook run.");
            }
            this.mRefreshCompleteHook.takeOver();
            return;
        }
        if (this.mPtrUIHandlerHolder.hasHandler()) {
            if (DEBUG) {
                PtrCLog.i(this.LOG_TAG, "PtrUIHandler: onUIRefreshComplete");
            }
            this.mPtrUIHandlerHolder.onUIRefreshComplete(this);
        }
        this.mPtrIndicator.onUIRefreshComplete();
        this.tryScrollBackToTopAfterComplete();
        this.tryToNotifyReset();
    }

    public void autoRefresh() {
        this.autoRefresh(true, this.mDurationToCloseHeader);
    }

    public void autoRefresh(boolean atOnce) {
        this.autoRefresh(atOnce, this.mDurationToCloseHeader);
    }

    private void clearFlag() {
        this.mFlag &= ~MASK_AUTO_REFRESH;
    }

    public void autoRefresh(boolean atOnce, int duration) {
        if (this.mStatus != 1) {
            return;
        }
        this.mFlag |= atOnce ? FLAG_AUTO_REFRESH_AT_ONCE : FLAG_AUTO_REFRESH_BUT_LATER;
        this.mStatus = (byte)2;
        if (this.mPtrUIHandlerHolder.hasHandler()) {
            this.mPtrUIHandlerHolder.onUIRefreshPrepare(this);
            if (DEBUG) {
                PtrCLog.i(this.LOG_TAG, "PtrUIHandler: onUIRefreshPrepare, mFlag %s", this.mFlag);
            }
        }
        this.mScrollChecker.tryToScrollTo(this.mPtrIndicator.getOffsetToRefresh(), duration);
        if (atOnce) {
            this.mStatus = (byte)3;
            this.performRefresh();
        }
    }

    public boolean isAutoRefresh() {
        return (this.mFlag & MASK_AUTO_REFRESH) > 0;
    }

    private boolean performAutoRefreshButLater() {
        return (this.mFlag & MASK_AUTO_REFRESH) == FLAG_AUTO_REFRESH_BUT_LATER;
    }

    public void setEnabledNextPtrAtOnce(boolean enable) {
        this.mFlag = enable ? (this.mFlag |= FLAG_ENABLE_NEXT_PTR_AT_ONCE) : (this.mFlag &= ~FLAG_ENABLE_NEXT_PTR_AT_ONCE);
    }

    public boolean isEnabledNextPtrAtOnce() {
        return (this.mFlag & FLAG_ENABLE_NEXT_PTR_AT_ONCE) > 0;
    }

    public void setPinContent(boolean pinContent) {
        this.mFlag = pinContent ? (this.mFlag |= FLAG_PIN_CONTENT) : (this.mFlag &= ~FLAG_PIN_CONTENT);
    }

    public boolean isPinContent() {
        return (this.mFlag & FLAG_PIN_CONTENT) > 0;
    }

    public void disableWhenHorizontalMove(boolean disable) {
        this.mDisableWhenHorizontalMove = disable;
    }

    public void setLoadingMinTime(int time) {
        this.mLoadingMinTime = time;
    }

    @Deprecated
    public void setInterceptEventWhileWorking(boolean yes) {
    }

    public View getContentView() {
        return this.mContent;
    }

    public void setPtrHandler(PtrHandler ptrHandler) {
        this.mPtrHandler = ptrHandler;
    }

    public void addPtrUIHandler(PtrUIHandler ptrUIHandler) {
        PtrUIHandlerHolder.addHandler(this.mPtrUIHandlerHolder, ptrUIHandler);
    }

    public void removePtrUIHandler(PtrUIHandler ptrUIHandler) {
        this.mPtrUIHandlerHolder = PtrUIHandlerHolder.removeHandler(this.mPtrUIHandlerHolder, ptrUIHandler);
    }

    public void setPtrIndicator(PtrIndicator slider) {
        if (this.mPtrIndicator != null && this.mPtrIndicator != slider) {
            slider.convertFrom(this.mPtrIndicator);
        }
        this.mPtrIndicator = slider;
    }

    public float getResistance() {
        return this.mPtrIndicator.getResistance();
    }

    public void setResistance(float resistance) {
        this.mPtrIndicator.setResistance(resistance);
    }

    public float getDurationToClose() {
        return this.mDurationToClose;
    }

    public void setDurationToClose(int duration) {
        this.mDurationToClose = duration;
    }

    public long getDurationToCloseHeader() {
        return this.mDurationToCloseHeader;
    }

    public void setDurationToCloseHeader(int duration) {
        this.mDurationToCloseHeader = duration;
    }

    public void setRatioOfHeaderHeightToRefresh(float ratio) {
        this.mPtrIndicator.setRatioOfHeaderHeightToRefresh(ratio);
    }

    public int getOffsetToRefresh() {
        return this.mPtrIndicator.getOffsetToRefresh();
    }

    public void setOffsetToRefresh(int offset) {
        this.mPtrIndicator.setOffsetToRefresh(offset);
    }

    public float getRatioOfHeaderToHeightRefresh() {
        return this.mPtrIndicator.getRatioOfHeaderToHeightRefresh();
    }

    public void setOffsetToKeepHeaderWhileLoading(int offset) {
        this.mPtrIndicator.setOffsetToKeepHeaderWhileLoading(offset);
    }

    public int getOffsetToKeepHeaderWhileLoading() {
        return this.mPtrIndicator.getOffsetToKeepHeaderWhileLoading();
    }

    public boolean isKeepHeaderWhenRefresh() {
        return this.mKeepHeaderWhenRefresh;
    }

    public void setKeepHeaderWhenRefresh(boolean keepOrNot) {
        this.mKeepHeaderWhenRefresh = keepOrNot;
    }

    public boolean isPullToRefresh() {
        return this.mPullToRefresh;
    }

    public void setPullToRefresh(boolean pullToRefresh) {
        this.mPullToRefresh = pullToRefresh;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    public void setHeaderView(View header) {
        Object lp;
        if (this.mHeaderView != null && header != null && this.mHeaderView != header) {
            this.removeView(this.mHeaderView);
        }
        if ((lp = header.getLayoutParams()) == null) {
            lp = new LayoutParams(-1, -2);
            header.setLayoutParams(lp);
        }
        this.mHeaderView = header;
        this.addView(header);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p != null && p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private void sendCancelEvent() {
        if (DEBUG) {
            PtrCLog.d(this.LOG_TAG, "send cancel event");
        }
        if (this.mLastMoveEvent == null) {
            return;
        }
        MotionEvent last = this.mLastMoveEvent;
        MotionEvent e = MotionEvent.obtain((long)last.getDownTime(), (long)(last.getEventTime() + (long)ViewConfiguration.getLongPressTimeout()), (int)3, (float)last.getX(), (float)last.getY(), (int)last.getMetaState());
        this.dispatchTouchEventSupper(e);
    }

    private void sendDownEvent() {
        if (DEBUG) {
            PtrCLog.d(this.LOG_TAG, "send down event");
        }
        MotionEvent last = this.mLastMoveEvent;
        MotionEvent e = MotionEvent.obtain((long)last.getDownTime(), (long)last.getEventTime(), (int)0, (float)last.getX(), (float)last.getY(), (int)last.getMetaState());
        this.dispatchTouchEventSupper(e);
    }

    public void setAutoLoadMoreEnable(boolean isAutoLoadMoreEnable) {
        this.isAutoLoadMoreEnable = isAutoLoadMoreEnable;
    }

    public void setFooterView(ILoadMoreViewFactory factory) {
        if (null == factory || null != this.loadMoreViewFactory && this.loadMoreViewFactory == factory) {
            return;
        }
        this.loadMoreViewFactory = factory;
        if (this.hasInitLoadMoreView) {
            this.mLoadMoreHandler.removeFooter();
            this.mLoadMoreView = this.loadMoreViewFactory.madeLoadMoreView();
            this.hasInitLoadMoreView = this.mLoadMoreHandler.handleSetAdapter(this.mContentView, this.mLoadMoreView, this.onClickLoadMoreListener);
            if (!this.isLoadMoreEnable) {
                this.mLoadMoreHandler.removeFooter();
            }
        }
    }

    public void setLoadMoreEnable(boolean loadMoreEnable) {
        if (this.isLoadMoreEnable == loadMoreEnable) {
            return;
        }
        this.isLoadMoreEnable = loadMoreEnable;
        if (!this.hasInitLoadMoreView && this.isLoadMoreEnable) {
            this.mContentView = this.getContentView();
            if (null == this.loadMoreViewFactory) {
                this.loadMoreViewFactory = new DefaultLoadMoreViewFooter();
            }
            this.mLoadMoreView = this.loadMoreViewFactory.madeLoadMoreView();
            if (null == this.mLoadMoreHandler) {
                if (this.mContentView instanceof GridView) {
                    this.mLoadMoreHandler = new GridViewHandler();
                } else if (this.mContentView instanceof AbsListView) {
                    this.mLoadMoreHandler = new ListViewHandler();
                } else if (this.mContentView instanceof RecyclerView) {
                    this.mLoadMoreHandler = new RecyclerViewHandler();
                }
            }
            if (null == this.mLoadMoreHandler) {
                throw new IllegalStateException("unSupported contentView !");
            }
            this.hasInitLoadMoreView = this.mLoadMoreHandler.handleSetAdapter(this.mContentView, this.mLoadMoreView, this.onClickLoadMoreListener);
            this.mLoadMoreHandler.setOnScrollBottomListener(this.mContentView, this.onScrollBottomListener);
            return;
        }
        if (this.hasInitLoadMoreView) {
            if (this.isLoadMoreEnable) {
                this.mLoadMoreHandler.addFooter();
            } else {
                this.mLoadMoreHandler.removeFooter();
            }
        }
    }

    public boolean isLoadMoreEnable() {
        return this.isLoadMoreEnable;
    }

    void loadMore() {
        this.isLoadingMore = true;
        this.mLoadMoreView.showLoading();
        this.mOnLoadMoreListener.loadMore();
    }

    public void loadMoreComplete(boolean hasMore) {
        this.isLoadingMore = false;
        this.isLoadMoreEnable = hasMore;
        if (hasMore) {
            this.mLoadMoreView.showNormal();
        } else {
            this.setNoMoreData();
        }
    }

    public void setNoMoreData() {
        this.mLoadMoreView.showNomore();
    }

    public boolean isLoadingMore() {
        return this.isLoadingMore;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener loadMoreListener) {
        this.mOnLoadMoreListener = loadMoreListener;
    }

    class ScrollChecker
    implements Runnable {
        private int mLastFlingY;
        private Scroller mScroller;
        private boolean mIsRunning = false;
        private int mStart;
        private int mTo;

        public ScrollChecker() {
            this.mScroller = new Scroller(PtrFrameLayout.this.getContext());
        }

        @Override
        public void run() {
            boolean finish = !this.mScroller.computeScrollOffset() || this.mScroller.isFinished();
            int curY = this.mScroller.getCurrY();
            int deltaY = curY - this.mLastFlingY;
            if (DEBUG && deltaY != 0) {
                PtrCLog.v(PtrFrameLayout.this.LOG_TAG, "scroll: %s, start: %s, to: %s, currentPos: %s, current :%s, last: %s, delta: %s", finish, this.mStart, this.mTo, PtrFrameLayout.this.mPtrIndicator.getCurrentPosY(), curY, this.mLastFlingY, deltaY);
            }
            if (!finish) {
                this.mLastFlingY = curY;
                PtrFrameLayout.this.movePos(deltaY);
                PtrFrameLayout.this.post(this);
            } else {
                this.finish();
            }
        }

        private void finish() {
            if (DEBUG) {
                PtrCLog.v(PtrFrameLayout.this.LOG_TAG, "finish, currentPos:%s", PtrFrameLayout.this.mPtrIndicator.getCurrentPosY());
            }
            this.reset();
            PtrFrameLayout.this.onPtrScrollFinish();
        }

        private void reset() {
            this.mIsRunning = false;
            this.mLastFlingY = 0;
            PtrFrameLayout.this.removeCallbacks(this);
        }

        public void abortIfWorking() {
            if (this.mIsRunning) {
                if (!this.mScroller.isFinished()) {
                    this.mScroller.forceFinished(true);
                }
                PtrFrameLayout.this.onPtrScrollAbort();
                this.reset();
            }
        }

        public void tryToScrollTo(int to, int duration) {
            if (PtrFrameLayout.this.mPtrIndicator.isAlreadyHere(to)) {
                return;
            }
            this.mStart = PtrFrameLayout.this.mPtrIndicator.getCurrentPosY();
            this.mTo = to;
            int distance = to - this.mStart;
            if (DEBUG) {
                PtrCLog.d(PtrFrameLayout.this.LOG_TAG, "tryToScrollTo: start: %s, distance:%s, to:%s", this.mStart, distance, to);
            }
            PtrFrameLayout.this.removeCallbacks(this);
            this.mLastFlingY = 0;
            if (!this.mScroller.isFinished()) {
                this.mScroller.forceFinished(true);
            }
            this.mScroller.startScroll(0, 0, 0, distance, duration);
            PtrFrameLayout.this.post(this);
            this.mIsRunning = true;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

