/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.loadmore;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.WrapperListAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class GridViewWithHeaderAndFooter
extends GridView {
    public static boolean DEBUG = false;
    private AdapterView.OnItemClickListener mOnItemClickListener;
    private AdapterView.OnItemLongClickListener mOnItemLongClickListener;
    private int mNumColumns = -1;
    private View mViewForMeasureRowHeight = null;
    private int mRowHeight = -1;
    private static final String LOG_TAG = "GridViewHeaderAndFooter";
    private ArrayList<FixedViewInfo> mHeaderViewInfos = new ArrayList();
    private ArrayList<FixedViewInfo> mFooterViewInfos = new ArrayList();
    private ListAdapter mOriginalAdapter;
    private ItemClickHandler mItemClickHandler;

    private void initHeaderGridView() {
    }

    public GridViewWithHeaderAndFooter(Context context) {
        super(context);
        this.initHeaderGridView();
    }

    public GridViewWithHeaderAndFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initHeaderGridView();
    }

    public GridViewWithHeaderAndFooter(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initHeaderGridView();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && adapter instanceof HeaderViewGridAdapter) {
            ((HeaderViewGridAdapter)adapter).setNumColumns(this.getNumColumnsCompatible());
            ((HeaderViewGridAdapter)adapter).setRowHeight(this.getRowHeight());
        }
    }

    public void setClipChildren(boolean clipChildren) {
    }

    public void setClipChildrenSupper(boolean clipChildren) {
        super.setClipChildren(false);
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && !(adapter instanceof HeaderViewGridAdapter)) {
            throw new IllegalStateException("Cannot add header view to grid -- setAdapter has already been called.");
        }
        ViewGroup.LayoutParams lyp = v.getLayoutParams();
        FixedViewInfo info = new FixedViewInfo();
        FullWidthFixedViewLayout fl = new FullWidthFixedViewLayout(this.getContext());
        if (lyp != null) {
            v.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(lyp.width, lyp.height));
            fl.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(lyp.width, lyp.height));
        }
        fl.addView(v);
        info.view = v;
        info.viewContainer = fl;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
        if (adapter != null) {
            ((HeaderViewGridAdapter)adapter).notifyDataSetChanged();
        }
    }

    public void addFooterView(View v) {
        this.addFooterView(v, null, true);
    }

    public void addFooterView(View v, Object data, boolean isSelectable) {
        ListAdapter mAdapter = this.getAdapter();
        if (mAdapter == null || !(mAdapter instanceof HeaderViewGridAdapter)) {
            // empty if block
        }
        ViewGroup.LayoutParams lyp = v.getLayoutParams();
        FixedViewInfo info = new FixedViewInfo();
        FullWidthFixedViewLayout fl = new FullWidthFixedViewLayout(this.getContext());
        if (lyp != null) {
            v.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(lyp.width, lyp.height));
            fl.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(lyp.width, lyp.height));
        }
        fl.addView(v);
        info.view = v;
        info.viewContainer = fl;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mFooterViewInfos.add(info);
        if (mAdapter != null) {
            // empty if block
        }
    }

    public int getHeaderViewCount() {
        return this.mHeaderViewInfos.size();
    }

    public int getFooterViewCount() {
        return this.mFooterViewInfos.size();
    }

    public boolean removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            ListAdapter adapter = this.getAdapter();
            if (adapter != null && ((HeaderViewGridAdapter)adapter).removeHeader(v)) {
                result = true;
            }
            this.removeFixedViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    public boolean removeFooterView(View v) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean result = false;
            ListAdapter adapter = this.getAdapter();
            if (adapter != null && ((HeaderViewGridAdapter)adapter).removeFooter(v)) {
                result = true;
            }
            this.removeFixedViewInfo(v, this.mFooterViewInfos);
            return result;
        }
        return false;
    }

    private void removeFixedViewInfo(View v, ArrayList<FixedViewInfo> where) {
        int len = where.size();
        for (int i = 0; i < len; ++i) {
            FixedViewInfo info = where.get(i);
            if (info.view != v) continue;
            where.remove(i);
            break;
        }
    }

    @TargetApi(value=11)
    private int getNumColumnsCompatible() {
        if (Build.VERSION.SDK_INT >= 11) {
            return super.getNumColumns();
        }
        try {
            Field numColumns = GridView.class.getDeclaredField("mNumColumns");
            numColumns.setAccessible(true);
            return numColumns.getInt((Object)this);
        }
        catch (Exception e) {
            if (this.mNumColumns != -1) {
                return this.mNumColumns;
            }
            throw new RuntimeException("Can not determine the mNumColumns for this API platform, please call setNumColumns to set it.");
        }
    }

    @TargetApi(value=16)
    private int getColumnWidthCompatible() {
        if (Build.VERSION.SDK_INT >= 16) {
            return super.getColumnWidth();
        }
        try {
            Field numColumns = GridView.class.getDeclaredField("mColumnWidth");
            numColumns.setAccessible(true);
            return numColumns.getInt((Object)this);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mViewForMeasureRowHeight = null;
    }

    public void invalidateRowHeight() {
        this.mRowHeight = -1;
    }

    public int getHeaderHeight(int row) {
        if (row >= 0) {
            return this.mHeaderViewInfos.get((int)row).view.getMeasuredHeight();
        }
        return 0;
    }

    @TargetApi(value=16)
    public int getVerticalSpacing() {
        int value = 0;
        try {
            int currentapiVersion = Build.VERSION.SDK_INT;
            if (currentapiVersion < 16) {
                Field field = GridView.class.getDeclaredField("mVerticalSpacing");
                field.setAccessible(true);
                value = field.getInt((Object)this);
            } else {
                value = super.getVerticalSpacing();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @TargetApi(value=16)
    public int getHorizontalSpacing() {
        int value = 0;
        try {
            int currentapiVersion = Build.VERSION.SDK_INT;
            if (currentapiVersion < 16) {
                Field field = GridView.class.getDeclaredField("mHorizontalSpacing");
                field.setAccessible(true);
                value = field.getInt((Object)this);
            } else {
                value = super.getHorizontalSpacing();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int getRowHeight() {
        if (this.mRowHeight > 0) {
            return this.mRowHeight;
        }
        ListAdapter adapter = this.getAdapter();
        int numColumns = this.getNumColumnsCompatible();
        if (adapter == null || adapter.getCount() <= numColumns * (this.mHeaderViewInfos.size() + this.mFooterViewInfos.size())) {
            return -1;
        }
        int mColumnWidth = this.getColumnWidthCompatible();
        View view = this.getAdapter().getView(numColumns * this.mHeaderViewInfos.size(), this.mViewForMeasureRowHeight, (ViewGroup)this);
        AbsListView.LayoutParams p = (AbsListView.LayoutParams)view.getLayoutParams();
        if (p == null) {
            p = new AbsListView.LayoutParams(-1, -2, 0);
            view.setLayoutParams((ViewGroup.LayoutParams)p);
        }
        int childHeightSpec = GridViewWithHeaderAndFooter.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)0, (int)0), (int)0, (int)p.height);
        int childWidthSpec = GridViewWithHeaderAndFooter.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)mColumnWidth, (int)0x40000000), (int)0, (int)p.width);
        view.measure(childWidthSpec, childHeightSpec);
        this.mViewForMeasureRowHeight = view;
        this.mRowHeight = view.getMeasuredHeight();
        return this.mRowHeight;
    }

    @TargetApi(value=11)
    public void tryToScrollToBottomSmoothly() {
        int lastPos = this.getAdapter().getCount() - 1;
        if (Build.VERSION.SDK_INT >= 11) {
            this.smoothScrollToPositionFromTop(lastPos, 0);
        } else {
            this.setSelection(lastPos);
        }
    }

    @TargetApi(value=11)
    public void tryToScrollToBottomSmoothly(int duration) {
        int lastPos = this.getAdapter().getCount() - 1;
        if (Build.VERSION.SDK_INT >= 11) {
            this.smoothScrollToPositionFromTop(lastPos, 0, duration);
        } else {
            this.setSelection(lastPos);
        }
    }

    public void setAdapter(ListAdapter adapter) {
        this.mOriginalAdapter = adapter;
        if (this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0) {
            HeaderViewGridAdapter headerViewGridAdapter = new HeaderViewGridAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, adapter);
            int numColumns = this.getNumColumnsCompatible();
            if (numColumns > 1) {
                headerViewGridAdapter.setNumColumns(numColumns);
            }
            headerViewGridAdapter.setRowHeight(this.getRowHeight());
            super.setAdapter((ListAdapter)headerViewGridAdapter);
        } else {
            super.setAdapter(adapter);
        }
    }

    public ListAdapter getOriginalAdapter() {
        return this.mOriginalAdapter;
    }

    public void setNumColumns(int numColumns) {
        super.setNumColumns(numColumns);
        this.mNumColumns = numColumns;
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && adapter instanceof HeaderViewGridAdapter) {
            ((HeaderViewGridAdapter)adapter).setNumColumns(numColumns);
        }
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        this.mOnItemClickListener = l;
        super.setOnItemClickListener((AdapterView.OnItemClickListener)this.getItemClickHandler());
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
        super.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this.getItemClickHandler());
    }

    private ItemClickHandler getItemClickHandler() {
        if (this.mItemClickHandler == null) {
            this.mItemClickHandler = new ItemClickHandler();
        }
        return this.mItemClickHandler;
    }

    private class ItemClickHandler
    implements AdapterView.OnItemClickListener,
    AdapterView.OnItemLongClickListener {
        private ItemClickHandler() {
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            int resPos;
            if (GridViewWithHeaderAndFooter.this.mOnItemClickListener != null && (resPos = position - GridViewWithHeaderAndFooter.this.getHeaderViewCount() * GridViewWithHeaderAndFooter.this.getNumColumnsCompatible()) >= 0) {
                GridViewWithHeaderAndFooter.this.mOnItemClickListener.onItemClick(parent, view, resPos, id2);
            }
        }

        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
            int resPos;
            if (GridViewWithHeaderAndFooter.this.mOnItemLongClickListener != null && (resPos = position - GridViewWithHeaderAndFooter.this.getHeaderViewCount() * GridViewWithHeaderAndFooter.this.getNumColumnsCompatible()) >= 0) {
                GridViewWithHeaderAndFooter.this.mOnItemLongClickListener.onItemLongClick(parent, view, resPos, id2);
            }
            return true;
        }
    }

    private static class HeaderViewGridAdapter
    implements WrapperListAdapter,
    Filterable {
        private final DataSetObservable mDataSetObservable = new DataSetObservable();
        private final ListAdapter mAdapter;
        static final ArrayList<FixedViewInfo> EMPTY_INFO_LIST = new ArrayList();
        ArrayList<FixedViewInfo> mHeaderViewInfos;
        ArrayList<FixedViewInfo> mFooterViewInfos;
        private int mNumColumns = 1;
        private int mRowHeight = -1;
        boolean mAreAllFixedViewsSelectable;
        private final boolean mIsFilterable;
        private boolean mCachePlaceHoldView = true;
        private boolean mCacheFirstHeaderView = false;

        public HeaderViewGridAdapter(ArrayList<FixedViewInfo> headerViewInfos, ArrayList<FixedViewInfo> footViewInfos, ListAdapter adapter) {
            this.mAdapter = adapter;
            this.mIsFilterable = adapter instanceof Filterable;
            this.mHeaderViewInfos = headerViewInfos == null ? EMPTY_INFO_LIST : headerViewInfos;
            this.mFooterViewInfos = footViewInfos == null ? EMPTY_INFO_LIST : footViewInfos;
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
        }

        public void setNumColumns(int numColumns) {
            if (numColumns < 1) {
                return;
            }
            if (this.mNumColumns != numColumns) {
                this.mNumColumns = numColumns;
                this.notifyDataSetChanged();
            }
        }

        public void setRowHeight(int height) {
            this.mRowHeight = height;
        }

        public int getHeadersCount() {
            return this.mHeaderViewInfos.size();
        }

        public int getFootersCount() {
            return this.mFooterViewInfos.size();
        }

        public boolean isEmpty() {
            return this.mAdapter == null || this.mAdapter.isEmpty();
        }

        private boolean areAllListInfosSelectable(ArrayList<FixedViewInfo> infos) {
            if (infos != null) {
                for (FixedViewInfo info : infos) {
                    if (info.isSelectable) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean removeHeader(View v) {
            for (int i = 0; i < this.mHeaderViewInfos.size(); ++i) {
                FixedViewInfo info = this.mHeaderViewInfos.get(i);
                if (info.view != v) continue;
                this.mHeaderViewInfos.remove(i);
                this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
                this.mDataSetObservable.notifyChanged();
                return true;
            }
            return false;
        }

        public boolean removeFooter(View v) {
            for (int i = 0; i < this.mFooterViewInfos.size(); ++i) {
                FixedViewInfo info = this.mFooterViewInfos.get(i);
                if (info.view != v) continue;
                this.mFooterViewInfos.remove(i);
                this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
                this.mDataSetObservable.notifyChanged();
                return true;
            }
            return false;
        }

        public int getCount() {
            if (this.mAdapter != null) {
                return (this.getFootersCount() + this.getHeadersCount()) * this.mNumColumns + this.getAdapterAndPlaceHolderCount();
            }
            return (this.getFootersCount() + this.getHeadersCount()) * this.mNumColumns;
        }

        public boolean areAllItemsEnabled() {
            return this.mAdapter == null || this.mAreAllFixedViewsSelectable && this.mAdapter.areAllItemsEnabled();
        }

        private int getAdapterAndPlaceHolderCount() {
            return (int)(Math.ceil(1.0f * (float)this.mAdapter.getCount() / (float)this.mNumColumns) * (double)this.mNumColumns);
        }

        public boolean isEnabled(int position) {
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders) {
                return position % this.mNumColumns == 0 && this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).isSelectable;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.getAdapterAndPlaceHolderCount())) {
                return adjPosition < this.mAdapter.getCount() && this.mAdapter.isEnabled(adjPosition);
            }
            int footerPosition = adjPosition - adapterCount;
            return footerPosition % this.mNumColumns == 0 && this.mFooterViewInfos.get((int)(footerPosition / this.mNumColumns)).isSelectable;
        }

        public Object getItem(int position) {
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders) {
                if (position % this.mNumColumns == 0) {
                    return this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).data;
                }
                return null;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.getAdapterAndPlaceHolderCount())) {
                if (adjPosition < this.mAdapter.getCount()) {
                    return this.mAdapter.getItem(adjPosition);
                }
                return null;
            }
            int footerPosition = adjPosition - adapterCount;
            if (footerPosition % this.mNumColumns == 0) {
                return this.mFooterViewInfos.get((int)footerPosition).data;
            }
            return null;
        }

        public long getItemId(int position) {
            int adapterCount;
            int adjPosition;
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (this.mAdapter != null && position >= numHeadersAndPlaceholders && (adjPosition = position - numHeadersAndPlaceholders) < (adapterCount = this.mAdapter.getCount())) {
                return this.mAdapter.getItemId(adjPosition);
            }
            return -1L;
        }

        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            int numHeadersAndPlaceholders;
            if (DEBUG) {
                Log.d((String)GridViewWithHeaderAndFooter.LOG_TAG, (String)String.format("getView: %s, reused: %s", position, convertView == null));
            }
            if (position < (numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns)) {
                ViewGroup headerViewContainer = this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).viewContainer;
                if (position % this.mNumColumns == 0) {
                    return headerViewContainer;
                }
                if (convertView == null) {
                    convertView = new View(parent.getContext());
                }
                convertView.setVisibility(4);
                convertView.setMinimumHeight(headerViewContainer.getHeight());
                return convertView;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.getAdapterAndPlaceHolderCount())) {
                if (adjPosition < this.mAdapter.getCount()) {
                    return this.mAdapter.getView(adjPosition, convertView, parent);
                }
                if (convertView == null) {
                    convertView = new View(parent.getContext());
                }
                convertView.setVisibility(4);
                convertView.setMinimumHeight(this.mRowHeight);
                return convertView;
            }
            int footerPosition = adjPosition - adapterCount;
            if (footerPosition < this.getCount()) {
                ViewGroup footViewContainer = this.mFooterViewInfos.get((int)(footerPosition / this.mNumColumns)).viewContainer;
                if (position % this.mNumColumns == 0) {
                    return footViewContainer;
                }
                if (convertView == null) {
                    convertView = new View(parent.getContext());
                }
                convertView.setVisibility(4);
                convertView.setMinimumHeight(footViewContainer.getHeight());
                return convertView;
            }
            throw new ArrayIndexOutOfBoundsException(position);
        }

        public int getItemViewType(int position) {
            int footerPosition;
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            int adapterViewTypeStart = this.mAdapter == null ? 0 : this.mAdapter.getViewTypeCount() - 1;
            int type = -2;
            if (this.mCachePlaceHoldView && position < numHeadersAndPlaceholders) {
                if (position == 0 && this.mCacheFirstHeaderView) {
                    type = adapterViewTypeStart + this.mHeaderViewInfos.size() + this.mFooterViewInfos.size() + 1 + 1;
                }
                if (position % this.mNumColumns != 0) {
                    type = adapterViewTypeStart + (position / this.mNumColumns + 1);
                }
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null) {
                adapterCount = this.getAdapterAndPlaceHolderCount();
                if (adjPosition >= 0 && adjPosition < adapterCount) {
                    if (adjPosition < this.mAdapter.getCount()) {
                        type = this.mAdapter.getItemViewType(adjPosition);
                    } else if (this.mCachePlaceHoldView) {
                        type = adapterViewTypeStart + this.mHeaderViewInfos.size() + 1;
                    }
                }
            }
            if (this.mCachePlaceHoldView && (footerPosition = adjPosition - adapterCount) >= 0 && footerPosition < this.getCount() && footerPosition % this.mNumColumns != 0) {
                type = adapterViewTypeStart + this.mHeaderViewInfos.size() + 1 + (footerPosition / this.mNumColumns + 1);
            }
            if (DEBUG) {
                Log.d((String)GridViewWithHeaderAndFooter.LOG_TAG, (String)String.format("getItemViewType: pos: %s, result: %s", position, type, this.mCachePlaceHoldView, this.mCacheFirstHeaderView));
            }
            return type;
        }

        public int getViewTypeCount() {
            int count;
            int n = count = this.mAdapter == null ? 1 : this.mAdapter.getViewTypeCount();
            if (this.mCachePlaceHoldView) {
                int offset = this.mHeaderViewInfos.size() + 1 + this.mFooterViewInfos.size();
                if (this.mCacheFirstHeaderView) {
                    ++offset;
                }
                count += offset;
            }
            if (DEBUG) {
                Log.d((String)GridViewWithHeaderAndFooter.LOG_TAG, (String)String.format("getViewTypeCount: %s", count));
            }
            return count;
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            this.mDataSetObservable.registerObserver((Object)observer);
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            this.mDataSetObservable.unregisterObserver((Object)observer);
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }

        public Filter getFilter() {
            if (this.mIsFilterable) {
                return ((Filterable)this.mAdapter).getFilter();
            }
            return null;
        }

        public ListAdapter getWrappedAdapter() {
            return this.mAdapter;
        }

        public void notifyDataSetChanged() {
            this.mDataSetObservable.notifyChanged();
        }
    }

    private class FullWidthFixedViewLayout
    extends FrameLayout {
        public FullWidthFixedViewLayout(Context context) {
            super(context);
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            int realLeft = GridViewWithHeaderAndFooter.this.getPaddingLeft() + this.getPaddingLeft();
            if (realLeft != left) {
                this.offsetLeftAndRight(realLeft - left);
            }
            super.onLayout(changed, left, top, right, bottom);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int targetWidth = GridViewWithHeaderAndFooter.this.getMeasuredWidth() - GridViewWithHeaderAndFooter.this.getPaddingLeft() - GridViewWithHeaderAndFooter.this.getPaddingRight();
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)targetWidth, (int)View.MeasureSpec.getMode((int)widthMeasureSpec));
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private static class FixedViewInfo {
        public View view;
        public ViewGroup viewContainer;
        public Object data;
        public boolean isSelectable;

        private FixedViewInfo() {
        }
    }
}

