/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.loadmore;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.chanven.lib.cptr.loadmore.GridViewWithHeaderAndFooter;
import com.chanven.lib.cptr.loadmore.ILoadViewMoreFactory;
import com.chanven.lib.cptr.loadmore.OnScrollBottomListener;
import com.chanven.lib.cptr.loadmore.ViewHandler;

public class GridViewHandler
implements ViewHandler {
    @Override
    public boolean handleSetAdapter(View contentView, ILoadViewMoreFactory.ILoadMoreView loadMoreView, View.OnClickListener onClickLoadMoreListener) {
        final GridViewWithHeaderAndFooter gridView = (GridViewWithHeaderAndFooter)contentView;
        ListAdapter adapter = gridView.getAdapter();
        boolean hasInit = false;
        if (loadMoreView != null) {
            final Context context = gridView.getContext().getApplicationContext();
            loadMoreView.init(new ILoadViewMoreFactory.FootViewAdder(){

                @Override
                public View addFootView(int layoutId) {
                    View view = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)gridView, false);
                    return this.addFootView(view);
                }

                @Override
                public View addFootView(View view) {
                    gridView.addFooterView(view);
                    return view;
                }
            }, onClickLoadMoreListener);
            hasInit = true;
            if (null != adapter) {
                gridView.setAdapter(adapter);
            }
        }
        return hasInit;
    }

    @Override
    public void setOnScrollBottomListener(View contentView, OnScrollBottomListener onScrollBottomListener) {
        GridViewWithHeaderAndFooter gridView = (GridViewWithHeaderAndFooter)contentView;
        gridView.setOnScrollListener(new GridViewOnScrollListener(onScrollBottomListener));
        gridView.setOnItemSelectedListener(new GridViewOnItemSelectedListener(onScrollBottomListener));
    }

    private static class GridViewOnScrollListener
    implements AbsListView.OnScrollListener {
        private OnScrollBottomListener onScrollBottomListener;

        public GridViewOnScrollListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (scrollState == 0 && view.getLastVisiblePosition() + 1 == view.getCount() && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }
    }

    private class GridViewOnItemSelectedListener
    implements AdapterView.OnItemSelectedListener {
        private OnScrollBottomListener onScrollBottomListener;

        public GridViewOnItemSelectedListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id2) {
            if (adapterView.getLastVisiblePosition() + 1 == adapterView.getCount() && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }
    }
}

