/*
 * Decompiled with CFR 0.152.
 */
package com.chabbal.slidingdotsplash;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.chabbal.slidingdotsplash.ImageViewPagerAdapter;
import com.chabbal.slidingdotsplash.OnItemClickListener;
import com.chabbal.slidingdotsplash.OnSetImageListener;
import com.chabbal.slidingdotsplash.R;

public class SlidingSplashView
extends FrameLayout {
    private ViewPager mViewPager;
    private ImageViewPagerAdapter mViewPagerAdapter;
    private OnSetImageListener mOnSetImageListener;
    ViewPager.OnPageChangeListener mOnPageChangeListener;

    public SlidingSplashView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SlidingSplashView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.sliding_splash_view, (ViewGroup)this);
        this.mViewPager = (ViewPager)this.findViewById(R.id.pager_splash);
        this.mViewPagerAdapter = new ImageViewPagerAdapter(context, this.mOnSetImageListener);
        if (!this.isInEditMode() && attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SlidingSplashView, 0, 0);
            int id2 = typedArray.getResourceId(R.styleable.SlidingSplashView_imageResources, 0);
            if (id2 != 0) {
                TypedArray typed = context.getResources().obtainTypedArray(id2);
                int[] drawables = new int[typed.length()];
                for (int i = 0; i < drawables.length; ++i) {
                    drawables[i] = typed.getResourceId(i, 0);
                }
                typed.recycle();
                this.mViewPagerAdapter.setImageResources(drawables);
            }
            typedArray.recycle();
        }
        this.mViewPager.setAdapter((PagerAdapter)this.mViewPagerAdapter);
        TabLayout tabLayout = (TabLayout)this.findViewById(R.id.tabDots);
        tabLayout.setupWithViewPager(this.mViewPager, true);
    }

    public void setImageResources(@NonNull @ArrayRes @Size(min=2L) int[] imageResources) {
        this.mViewPagerAdapter.setImageResources(imageResources);
    }

    public void setOnShowImageListener(OnSetImageListener onShowImageListener) {
        this.mOnSetImageListener = onShowImageListener;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mViewPagerAdapter.setOnPagerItemClick(onItemClickListener);
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
        this.mViewPager.addOnPageChangeListener(this.mOnPageChangeListener);
    }

    public void removeOnPageChangeListener() {
        this.mViewPager.removeOnPageChangeListener(this.mOnPageChangeListener);
    }
}

