/*
 * Decompiled with CFR 0.152.
 */
package com.chabbal.slidingdotsplash;

import android.content.Context;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import com.chabbal.slidingdotsplash.OnItemClickListener;
import com.chabbal.slidingdotsplash.OnSetImageListener;
import com.chabbal.slidingdotsplash.R;
import com.chabbal.slidingdotsplash.ViewPagerAdapter;

public class ImageViewPagerAdapter
extends ViewPagerAdapter {
    private Context mContext;
    private OnItemClickListener mOnPagerItemClick;
    private OnSetImageListener mOnSetImageListener;
    private int[] mImageResources;

    public ImageViewPagerAdapter(Context context, @NonNull OnSetImageListener onSetImageListener) {
        this.mContext = context;
        this.mOnSetImageListener = onSetImageListener;
        this.mImageResources = new int[0];
    }

    @Override
    public View getItem(final int position) {
        ImageView imageView = (ImageView)LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_view_pager_image, null);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageViewPagerAdapter.this.mOnPagerItemClick != null) {
                    ImageViewPagerAdapter.this.mOnPagerItemClick.onPagerItemClick(v, position);
                }
            }
        });
        if (this.mOnSetImageListener != null) {
            this.mOnSetImageListener.setImage(imageView, position);
        } else {
            imageView.setImageResource(this.mImageResources[position]);
        }
        return imageView;
    }

    public int getCount() {
        return this.mImageResources.length;
    }

    public void setImageResources(@NonNull @ArrayRes @Size(min=2L) int[] imageResources) {
        this.mImageResources = imageResources;
        this.notifyDataSetChanged();
    }

    public void setOnPagerItemClick(@NonNull OnItemClickListener onPagerItemClickListener) {
        this.mOnPagerItemClick = onPagerItemClickListener;
    }
}

