/*
 * Decompiled with CFR 0.152.
 */
package com.cepheuen.elegantnumberbutton.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.cepheuen.elegantnumberbutton.R;

public class ElegantNumberButton
extends RelativeLayout {
    private Context context;
    private AttributeSet attrs;
    private int styleAttr;
    private OnClickListener mListener;
    private int currentNumber;
    private TextView textView;
    private View view;

    public ElegantNumberButton(Context context) {
        super(context);
        this.context = context;
        this.initView();
    }

    public ElegantNumberButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.attrs = attrs;
        this.initView();
    }

    public ElegantNumberButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.attrs = attrs;
        this.styleAttr = defStyleAttr;
        this.initView();
    }

    private void initView() {
        this.view = this;
        ElegantNumberButton.inflate((Context)this.context, (int)R.layout.layout, (ViewGroup)this);
        Resources res = this.getResources();
        int defaultColor = res.getColor(R.color.colorPrimary);
        int defaultTextColor = res.getColor(R.color.colorText);
        Drawable defaultDrawable = res.getDrawable(R.drawable.background);
        TypedArray a = this.context.obtainStyledAttributes(this.attrs, R.styleable.ElegantNumberButton, this.styleAttr, 0);
        int initialText = a.getInt(R.styleable.ElegantNumberButton_initialText, 0);
        float textSize = a.getDimension(R.styleable.ElegantNumberButton_textSize, 13.0f);
        int color2 = a.getColor(R.styleable.ElegantNumberButton_backGroundColor, defaultColor);
        int textColor = a.getColor(R.styleable.ElegantNumberButton_textColor, defaultTextColor);
        Drawable drawable2 = a.getDrawable(R.styleable.ElegantNumberButton_backgroundDrawable);
        Button button1 = (Button)this.findViewById(R.id.subtract_btn);
        Button button2 = (Button)this.findViewById(R.id.add_btn);
        this.textView = (TextView)this.findViewById(R.id.number_counter);
        LinearLayout mLayout = (LinearLayout)this.findViewById(R.id.layout);
        button1.setTextColor(textColor);
        button2.setTextColor(textColor);
        this.textView.setTextColor(textColor);
        button1.setTextSize(textSize);
        button2.setTextSize(textSize);
        this.textView.setTextSize(textSize);
        if (drawable2 == null) {
            drawable2 = defaultDrawable;
        }
        assert (drawable2 != null);
        drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC));
        if (Build.VERSION.SDK_INT > 16) {
            mLayout.setBackground(drawable2);
        } else {
            mLayout.setBackgroundDrawable(drawable2);
        }
        this.textView.setText((CharSequence)String.valueOf(initialText));
        this.currentNumber = initialText;
        button1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View mView) {
                int num = Integer.valueOf(ElegantNumberButton.this.textView.getText().toString());
                if (num != 0) {
                    --num;
                }
                ElegantNumberButton.this.currentNumber = num;
                ElegantNumberButton.this.textView.setText((CharSequence)String.valueOf(num));
                ElegantNumberButton.this.callListener(ElegantNumberButton.this.view);
            }
        });
        button2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View mView) {
                int num = Integer.valueOf(ElegantNumberButton.this.textView.getText().toString());
                ElegantNumberButton.this.textView.setText((CharSequence)String.valueOf(num + 1));
                ElegantNumberButton.this.currentNumber = num + 1;
                ElegantNumberButton.this.callListener(ElegantNumberButton.this.view);
            }
        });
        a.recycle();
    }

    private void callListener(View view) {
        if (this.mListener != null) {
            this.mListener.onClick(view);
        }
    }

    public String getNumber() {
        return String.valueOf(this.currentNumber);
    }

    public void setNumber(String number) {
        this.currentNumber = Integer.parseInt(number);
        this.textView.setText((CharSequence)number);
    }

    public void setOnClickListener(OnClickListener onClickListener) {
        this.mListener = onClickListener;
    }

    public static interface OnClickListener {
        public void onClick(View var1);
    }
}

