/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rbd;

import com.ceph.rados.IoCTX;
import com.ceph.rbd.Library;
import com.ceph.rbd.RbdException;
import com.ceph.rbd.RbdImage;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;

public class Rbd {
    Pointer io;

    public static int[] getVersion() {
        IntByReference minor = new IntByReference();
        IntByReference major = new IntByReference();
        IntByReference extra = new IntByReference();
        Library.rbd.rbd_version(minor, major, extra);
        int[] returnValue = new int[]{minor.getValue(), major.getValue(), extra.getValue()};
        return returnValue;
    }

    public Rbd(IoCTX io) {
        this.io = io.getPointer();
    }

    public void create(String name, long size, int order) throws RbdException {
        IntByReference orderRef = new IntByReference(order);
        int r = Library.rbd.rbd_create(this.io, name, size, orderRef);
        if (r < 0) {
            throw new RbdException("Failed to create image " + name, r);
        }
    }

    public void create(String name, long size) throws RbdException {
        this.create(name, size, 0);
    }

    public void create(String name, long size, long features, int order) throws RbdException {
        IntByReference orderRef = new IntByReference(order);
        int r = Library.rbd.rbd_create2(this.io, name, size, features, orderRef);
        if (r < 0) {
            throw new RbdException("Failed to create image " + name, r);
        }
    }

    public void create(String name, long size, long features) throws RbdException {
        this.create(name, size, features, 0);
    }

    public void create(String name, long size, long features, int order, long stripe_unit, long stripe_count) throws RbdException {
        IntByReference orderRef = new IntByReference(order);
        int r = Library.rbd.rbd_create3(this.io, name, size, features, orderRef, stripe_unit, stripe_count);
        if (r < 0) {
            throw new RbdException("Failed to create image " + name, r);
        }
    }

    public void remove(String name) throws RbdException {
        int r = Library.rbd.rbd_remove(this.io, name);
        if (r < 0) {
            throw new RbdException("Failed to remove image " + name, r);
        }
    }

    public void rename(String srcName, String destName) throws RbdException {
        int r = Library.rbd.rbd_rename(this.io, srcName, destName);
        if (r < 0) {
            throw new RbdException("Failed to rename image " + srcName + " to " + destName, r);
        }
    }

    public String[] list() throws RbdException {
        int initialBufferSize = 1024;
        return this.list(initialBufferSize);
    }

    public String[] list(int initialBufferSize) throws RbdException {
        byte[] names = new byte[initialBufferSize];
        LongByReference sizePointer = new LongByReference((long)initialBufferSize);
        int r = Library.rbd.rbd_list(this.io, names, sizePointer);
        if (r < 0 && r != -34) {
            throw new RbdException("Failed to list RBD images", r);
        }
        if ((r == -34 || sizePointer.getValue() > (long)initialBufferSize) && (r = Library.rbd.rbd_list(this.io, names = new byte[(int)sizePointer.getValue()], sizePointer)) < 0) {
            throw new RbdException("Failed to list RBD images", r);
        }
        return new String(names).split("\u0000");
    }

    public RbdImage open(String name) throws RbdException {
        return this.open(name, null);
    }

    public RbdImage open(String name, String snapName) throws RbdException {
        Memory p = new Memory((long)Native.POINTER_SIZE);
        int r = Library.rbd.rbd_open(this.io, name, (Pointer)p, snapName);
        if (r < 0) {
            throw new RbdException("Failed to open image " + name, r);
        }
        return new RbdImage((Pointer)p, name);
    }

    public RbdImage openReadOnly(String name) throws RbdException {
        return this.openReadOnly(name, null);
    }

    public RbdImage openReadOnly(String name, String snapName) throws RbdException {
        Memory p = new Memory((long)Native.POINTER_SIZE);
        int r = Library.rbd.rbd_open_read_only(this.io, name, (Pointer)p, snapName);
        if (r < 0) {
            throw new RbdException("Failed to open image " + name, r);
        }
        return new RbdImage((Pointer)p, name);
    }

    public void close(RbdImage image) throws RbdException {
        int r = Library.rbd.rbd_close(image.getPointer());
        if (r < 0) {
            throw new RbdException("Failed to close image", r);
        }
    }

    public void clone(String parentImage, String parentSnap, IoCTX childIo, String childName, long features, int order, long stripe_unit, long stripe_count) throws RbdException {
        IntByReference orderRef = new IntByReference(order);
        int r = Library.rbd.rbd_clone2(this.io, parentImage, parentSnap, childIo.getPointer(), childName, features, orderRef, stripe_unit, stripe_count);
        if (r < 0) {
            throw new RbdException("Failed to clone image " + parentImage + "@" + parentSnap + " to " + childName, r);
        }
    }

    public void clone(String parentImage, String parentSnap, IoCTX childIo, String childName, long features, int order) throws RbdException {
        IntByReference orderRef = new IntByReference(order);
        int r = Library.rbd.rbd_clone(this.io, parentImage, parentSnap, childIo.getPointer(), childName, features, orderRef);
        if (r < 0) {
            throw new RbdException("Failed to clone image " + parentImage + "@" + parentSnap + " to " + childName, r);
        }
    }

    public void copy(RbdImage sourceImage, RbdImage destImage) throws RbdException {
        int r = Library.rbd.rbd_copy2(sourceImage.getPointer(), destImage.getPointer());
        if (r < 0) {
            throw new RbdException("Failed to copy image " + sourceImage.getName() + " to " + destImage.getName(), r);
        }
    }
}

