/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.IoCTX;
import com.ceph.rados.Library;
import com.ceph.rados.RadosBase;
import com.ceph.rados.exceptions.RadosException;
import com.ceph.rados.jna.RadosClusterInfo;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.util.concurrent.Callable;

public class Rados
extends RadosBase {
    public static final int OPERATION_NOFLAG = 0;
    public static final int OPERATION_BALANCE_READS = 1;
    public static final int OPERATION_LOCALIZE_READS = 2;
    public static final int OPERATION_ORDER_READS_WRITES = 4;
    public static final int OPERATION_IGNORE_CACHE = 8;
    public static final int OPERATION_SKIPRWLOCKS = 16;
    public static final int OPERATION_IGNORE_OVERLAY = 32;
    public static final int OPERATION_FULL_TRY = 64;
    protected Pointer clusterPtr;
    private boolean connected;

    public Rados(String id) {
        PointerByReference clusterPtr = new PointerByReference();
        Library.rados.rados_create(clusterPtr, id);
        this.clusterPtr = clusterPtr.getValue();
    }

    public Rados(String clustername, String name, long flags) {
        PointerByReference clusterPtr = new PointerByReference();
        Library.rados.rados_create2(clusterPtr, clustername, name, flags);
        this.clusterPtr = clusterPtr.getValue();
    }

    public Rados() {
        this(null);
    }

    private void verifyConnected(boolean required) throws RadosException {
        if (required && !this.connected) {
            throw new RadosException("This method should not be called in a disconnected state.");
        }
        if (!required && this.connected) {
            throw new RadosException("This method should not be called in a connected state.");
        }
    }

    public void confReadFile(final File file) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_conf_read_file(Rados.this.clusterPtr, file.getAbsolutePath());
            }
        }, "Failed reading configuration file %s", file.getAbsolutePath());
    }

    public void confSet(final String option, final String value) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_conf_set(Rados.this.clusterPtr, option, value);
            }
        }, "Could not set configuration option %s", option);
    }

    public String confGet(final String option) throws RadosException {
        final byte[] buf = new byte[256];
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_conf_get(Rados.this.clusterPtr, option, buf, buf.length);
            }
        }, "Unable to retrieve the value of configuration option %s", option);
        return Native.toString((byte[])buf);
    }

    public void connect() throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_connect(Rados.this.clusterPtr);
            }
        }, "Failed to connect to the Ceph cluster", new Object[0]);
        this.connected = true;
    }

    public String clusterFsid() throws RadosException {
        this.verifyConnected(true);
        final byte[] buf = new byte[256];
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_cluster_fsid(Rados.this.clusterPtr, buf, buf.length);
            }
        }, "Failed to retrieve the cluster's fsid", new Object[0]);
        return Native.toString((byte[])buf);
    }

    public RadosClusterInfo clusterStat() throws RadosException {
        this.verifyConnected(true);
        final RadosClusterInfo result = new RadosClusterInfo();
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_cluster_stat(Rados.this.clusterPtr, result);
            }
        }, "Failed to retrieve cluster's status", new Object[0]);
        return result;
    }

    public void poolCreate(final String name) throws RadosException {
        this.verifyConnected(true);
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_pool_create(Rados.this.clusterPtr, name);
            }
        }, "Failed to create pool %s", name);
    }

    public void poolCreate(final String name, final long auid) throws RadosException {
        this.verifyConnected(true);
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_pool_create_with_auid(Rados.this.clusterPtr, name, auid);
            }
        }, "Failed to create pool %s with auid %s", name, auid);
    }

    public void poolCreate(final String name, final long auid, final long crushrule) throws RadosException {
        this.verifyConnected(true);
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_pool_create_with_all(Rados.this.clusterPtr, name, auid, crushrule);
            }
        }, "Failed to create pool %s with auid %s and crushrule %s", name, auid, crushrule);
    }

    public void poolDelete(final String name) throws RadosException {
        this.verifyConnected(true);
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_pool_delete(Rados.this.clusterPtr, name);
            }
        }, "Failed to delete pool %s", name);
    }

    protected void finalize() throws Throwable {
        if (this.clusterPtr != null) {
            Library.rados.rados_shutdown(this.clusterPtr);
            this.clusterPtr = null;
        }
        super.finalize();
    }

    public String[] poolList() throws RadosException {
        this.verifyConnected(true);
        byte[] temp_buf = new byte[]{};
        int len = Library.rados.rados_pool_list(this.clusterPtr, temp_buf, temp_buf.length);
        byte[] buf = this.getPoolList(len);
        return new String(buf).split("\u0000");
    }

    private byte[] getPoolList(int len) throws RadosException {
        final byte[] buf = new byte[len];
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_pool_list(Rados.this.clusterPtr, buf, buf.length);
            }
        }, "Failed to retrieve list of pools", new Object[0]);
        return buf;
    }

    public long poolLookup(final String name) throws RadosException {
        return this.handleReturnCode(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return Library.rados.rados_pool_lookup(Rados.this.clusterPtr, name);
            }
        }, "Failed to retrieve id of the pool", new Object[0]);
    }

    public String poolReverseLookup(final long id) throws RadosException {
        final byte[] buf = new byte[512];
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_pool_reverse_lookup(Rados.this.clusterPtr, id, buf, buf.length);
            }
        }, "Failed to fetch name of the pool", new Object[0]);
        return new String(buf).trim();
    }

    public IoCTX ioCtxCreate(final String pool) throws RadosException {
        Memory p = new Memory((long)Native.POINTER_SIZE);
        this.handleReturnCode(new Callable<Integer>((Pointer)p){
            final /* synthetic */ Pointer val$p;
            {
                this.val$p = pointer;
            }

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_ioctx_create(Rados.this.clusterPtr, pool, this.val$p);
            }
        }, "Failed to create the IoCTX for pool %s", pool);
        return new IoCTX((Pointer)p);
    }

    public void ioCtxDestroy(IoCTX io) {
        Library.rados.rados_ioctx_destroy(io.getPointer());
    }

    public long getInstanceId() throws RadosException {
        this.verifyConnected(true);
        return Library.rados.rados_get_instance_id(this.clusterPtr);
    }

    public static int[] getVersion() {
        IntByReference minor = new IntByReference();
        IntByReference major = new IntByReference();
        IntByReference extra = new IntByReference();
        Library.rados.rados_version(minor, major, extra);
        return new int[]{minor.getValue(), major.getValue(), extra.getValue()};
    }

    public void shutDown() {
        if (this.clusterPtr != null) {
            Library.rados.rados_shutdown(this.clusterPtr);
            this.clusterPtr = null;
        }
    }

    public RadosCommandResult executeRadosMonCommand(String[] commands, String in) throws RadosException {
        String status;
        PointerByReference outBuf = new PointerByReference();
        IntByReference outBufLen = new IntByReference();
        PointerByReference statusBuf = new PointerByReference();
        IntByReference statusBufLen = new IntByReference();
        int r = Library.rados.rados_mon_command(this.clusterPtr, commands, commands.length, in, in.length(), outBuf, outBufLen, statusBuf, statusBufLen);
        String string = status = statusBuf.getValue() == null ? "" : new String(statusBuf.getValue().getByteArray(0L, statusBufLen.getValue()));
        if (r != 0) {
            throw new RadosException("Error when executing Rados monitor commands: " + status, r);
        }
        String out = outBuf.getValue() == null ? "" : new String(outBuf.getValue().getByteArray(0L, outBufLen.getValue()));
        return new RadosCommandResult(out, status);
    }

    public RadosCommandResult executeRadosMonCommandTarget(String[] commands, String target, String in) throws RadosException {
        String status;
        PointerByReference outBuf = new PointerByReference();
        IntByReference outBufLen = new IntByReference();
        PointerByReference statusBuf = new PointerByReference();
        IntByReference statusBufLen = new IntByReference();
        int r = Library.rados.rados_mon_command_target(this.clusterPtr, target, commands, commands.length, in, in.length(), outBuf, outBufLen, statusBuf, statusBufLen);
        String string = status = statusBuf.getValue() == null ? "" : new String(statusBuf.getValue().getByteArray(0L, statusBufLen.getValue()));
        if (r != 0) {
            throw new RadosException("Error when executing Rados monitor commands: " + status, r);
        }
        String out = outBuf.getValue() == null ? "" : new String(outBuf.getValue().getByteArray(0L, outBufLen.getValue()));
        return new RadosCommandResult(out, status);
    }

    public RadosCommandResult executeRadosOsdCommand(String[] commands, int osdId, String in) throws RadosException {
        String status;
        PointerByReference outBuf = new PointerByReference();
        IntByReference outBufLen = new IntByReference();
        PointerByReference statusBuf = new PointerByReference();
        IntByReference statusBufLen = new IntByReference();
        int r = Library.rados.rados_osd_command(this.clusterPtr, osdId, commands, commands.length, in, in.length(), outBuf, outBufLen, statusBuf, statusBufLen);
        String string = status = statusBuf.getValue() == null ? "" : new String(statusBuf.getValue().getByteArray(0L, statusBufLen.getValue()));
        if (r != 0) {
            throw new RadosException("Error when executing Rados osd command: " + status, r);
        }
        String out = outBuf.getValue() == null ? "" : new String(outBuf.getValue().getByteArray(0L, outBufLen.getValue()));
        return new RadosCommandResult(out, status);
    }

    public class RadosCommandResult {
        private final String output;
        private final String statusOutput;

        protected RadosCommandResult(String output, String statusOutput) {
            this.output = output;
            this.statusOutput = statusOutput;
        }

        public String getOutput() {
            return this.output;
        }

        public String getStatus() {
            return this.statusOutput;
        }
    }
}

