/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager;

import android.content.Context;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.celerysoft.imagepager.R;
import com.celerysoft.imagepager.adapter.ImagePagerAdapter;
import com.celerysoft.imagepager.util.DensityUtil;
import com.celerysoft.imagepager.view.Pager;
import com.celerysoft.imagepager.view.indicator.Indicator;

public class ImagePager
extends ViewGroup {
    private static final String TAG = "ImagePager";
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    public static final int TOP_LEFT = 4;
    public static final int TOP_RIGHT = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_RIGHT = 7;
    private static int CHILD_COUNT = 1;
    private Pager mPager;
    private Indicator mIndicator;
    private int mIndicatorPosition = 3;
    private float mIndicatorMargin = 16.0f;
    private ImagePagerAdapter mAdapter;
    private OnImageChangeListener mOnImageChangeListener;
    private OnImageClickListener mOnImageClickListener;
    private OnPageClickListener mOnPageClickListener;

    public ImagePagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(ImagePagerAdapter adapter) {
        this.mAdapter = adapter;
        ImagePagerAdapter imagePagerAdapter = adapter;
        if (this.mOnPageClickListener != null) {
            imagePagerAdapter.setOnPageClickListenerListener(this.mOnPageClickListener);
        }
        if (this.mOnImageClickListener != null) {
            imagePagerAdapter.setOnImageClickListener(this.mOnImageClickListener);
        }
        this.mPager.setAdapter(adapter);
        if (this.mIndicator != null) {
            this.mIndicator.onPageAdapterChanged(adapter.getCount());
            this.mAdapter.setIndicator(this.mIndicator);
        }
    }

    public OnImageChangeListener getOnImageChangeListener() {
        return this.mOnImageChangeListener;
    }

    public void setOnImageChangeListener(OnImageChangeListener onImageChangeListener) {
        this.mOnImageChangeListener = onImageChangeListener;
    }

    public OnImageClickListener getOnImageClickListener() {
        return this.mOnImageClickListener;
    }

    public void setOnImageClickListener(OnImageClickListener onImageClickListener) {
        this.mOnImageClickListener = onImageClickListener;
        if (this.mAdapter != null) {
            this.mAdapter.setOnImageClickListener(onImageClickListener);
        }
    }

    public OnPageClickListener getOnPageClickListener() {
        return this.mOnPageClickListener;
    }

    public void setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        if (this.mAdapter != null) {
            this.mAdapter.setOnPageClickListenerListener(onPageClickListener);
        }
    }

    public ImagePager(Context context) {
        super(context);
        this.initImagePager();
    }

    public ImagePager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initImagePager();
    }

    private void initImagePager() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.setBackgroundColor(this.getResources().getColor(R.color.image_pager_background, null));
        } else {
            this.setBackgroundColor(this.getResources().getColor(R.color.image_pager_background));
        }
        this.mPager = new Pager(this.getContext());
        this.addView((View)this.mPager, new ViewGroup.LayoutParams(-1, -1));
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (ImagePager.this.mOnImageChangeListener != null) {
                    ImagePager.this.mOnImageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
                }
            }

            public void onPageSelected(int position) {
                if (ImagePager.this.mOnImageChangeListener != null) {
                    ImagePager.this.mOnImageChangeListener.onPageSelected(position);
                }
                if (ImagePager.this.mIndicator != null) {
                    ImagePager.this.mIndicator.onPageSelected(position);
                }
            }

            public void onPageScrollStateChanged(int state) {
                if (ImagePager.this.mOnImageChangeListener != null) {
                    ImagePager.this.mOnImageChangeListener.onPageScrollStateChanged(state);
                }
            }
        });
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int childCount = this.getChildCount();
        if (childCount != CHILD_COUNT) {
            Log.e((String)TAG, (String)("wtf, child count must be " + CHILD_COUNT + "!"));
        }
        int childWidth = 0;
        int childHeight = 0;
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(0);
            if (!(childView instanceof Pager)) continue;
            childWidth = childView.getMeasuredWidth();
            childHeight = childView.getMeasuredHeight();
        }
        int measureWidth = childWidth;
        int measureHeight = childHeight;
        measureWidth = widthMode == Integer.MIN_VALUE ? measureWidth : widthSize;
        measureHeight = heightMode == Integer.MIN_VALUE ? measureHeight : heightSize;
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        if (childCount != CHILD_COUNT) {
            Log.e((String)TAG, (String)("wtf, child count must be " + CHILD_COUNT + "!"));
        }
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            int left = l;
            int top = t;
            int right = r;
            int bottom = b;
            if (childView instanceof Indicator) {
                int[] positions = this.deriveIndicatorPosition(l, t, r, b, childView);
                left = positions[0];
                top = positions[1];
                right = positions[2];
                bottom = positions[3];
            } else if (!(childView instanceof Pager)) {
                Log.e((String)TAG, (String)"wtfffff!");
            }
            childView.layout(left, top, right, bottom);
        }
    }

    private int[] deriveIndicatorPosition(int left, int top, int right, int bottom, View indicatorView) {
        int[] positions = new int[4];
        switch (this.mIndicatorPosition) {
            case 0: {
                int verticalMargin = (this.getMeasuredHeight() - indicatorView.getMeasuredHeight()) / 2;
                left = DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                right = left + indicatorView.getMeasuredWidth();
                top += verticalMargin;
                bottom -= verticalMargin;
                break;
            }
            case 1: {
                int horizontalMargin = (this.getMeasuredWidth() - indicatorView.getMeasuredWidth()) / 2;
                left += horizontalMargin;
                right -= horizontalMargin;
                top = DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                bottom = top + indicatorView.getMeasuredHeight();
                break;
            }
            case 2: {
                int verticalMargin = (this.getMeasuredHeight() - indicatorView.getMeasuredHeight()) / 2;
                right = this.getMeasuredWidth() - DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                left = right - indicatorView.getMeasuredWidth();
                top += verticalMargin;
                bottom -= verticalMargin;
                break;
            }
            case 4: {
                left = DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                right = left + indicatorView.getMeasuredWidth();
                top = DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                bottom = top + indicatorView.getMeasuredHeight();
                break;
            }
            case 5: {
                right = this.getMeasuredWidth() - DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                left = right - indicatorView.getMeasuredWidth();
                top = DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                bottom = top + indicatorView.getMeasuredHeight();
                break;
            }
            case 6: {
                left = DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                right = left + indicatorView.getMeasuredWidth();
                bottom = this.getMeasuredHeight() - indicatorView.getMeasuredHeight();
                top = bottom - indicatorView.getMeasuredHeight();
                break;
            }
            case 7: {
                right = this.getMeasuredWidth() - DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                left = right - indicatorView.getMeasuredWidth();
                bottom = this.getMeasuredHeight() - indicatorView.getMeasuredHeight();
                top = bottom - indicatorView.getMeasuredHeight();
                break;
            }
            default: {
                int horizontalMargin = (this.getMeasuredWidth() - indicatorView.getMeasuredWidth()) / 2;
                left += horizontalMargin;
                right -= horizontalMargin;
                bottom = this.getMeasuredHeight() - DensityUtil.dp2px(this.getContext(), this.mIndicatorMargin);
                top = bottom - indicatorView.getMeasuredHeight();
            }
        }
        positions[0] = left;
        positions[1] = top;
        positions[2] = right;
        positions[3] = bottom;
        return positions;
    }

    public void setIndicator(Indicator indicator) {
        if (this.mIndicator != null) {
            this.removeView((View)this.mIndicator);
        }
        CHILD_COUNT = 2;
        this.mIndicator = indicator;
        if (this.mAdapter != null) {
            this.mIndicator.onPageAdapterChanged(this.mAdapter.getCount());
            this.mIndicator.onPageSelected(this.getCurrentImagePosition());
            this.mAdapter.setIndicator(this.mIndicator);
        }
        this.addView((View)this.mIndicator, new ViewGroup.LayoutParams(-2, -2));
    }

    public void setIndicatorMargin(float marginInDp) {
        this.mIndicatorMargin = marginInDp;
    }

    public void setIndicatorPosition(int position) {
        this.mIndicatorPosition = position;
        this.requestLayout();
    }

    public int getCurrentImagePosition() {
        return this.mPager.getCurrentItem();
    }

    public void moveToImage(int imagePosition) {
        this.mPager.setCurrentItem(imagePosition);
    }

    public void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.mPager.setPageTransformer(reverseDrawingOrder, transformer);
    }

    public void setOffscreenPageLimit(int limit) {
        this.mPager.setOffscreenPageLimit(limit);
    }

    public void setPlaceholder(@DrawableRes int placeholderResInt) {
        this.mAdapter.setPlaceholder(placeholderResInt);
    }

    public void resetPlaceholder() {
        this.mAdapter.resetPlaceholder();
    }

    public static interface OnPageClickListener {
        public void onPageClick();
    }

    public static interface OnImageClickListener {
        public void onImageClick();
    }

    public static interface OnImageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }
}

