/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.StatFs;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.LruCache;
import android.widget.ImageView;
import com.celerysoft.imagepager.R;
import com.celerysoft.imagepager.util.DiskLruCache;
import com.celerysoft.imagepager.util.ImageUtil;
import com.celerysoft.imagepager.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import uk.co.senab.photoview.PhotoView;

public class ImageLoader {
    private static final String TAG = "ImageLoader";
    private static final long DISK_CACHE_SIZE = 0x3200000L;
    private static final int DISK_CACHE_VALUE_COUNT = 1;
    private static final int DISK_CACHE_INDEX = 0;
    private static final int IO_BUFFER_SIZE = 8192;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final long KEEP_ALIVE = 10L;
    private static final int INTERNET_KEEP_ALIVE = 5000;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(@NonNull Runnable r) {
            return new Thread(r, "ImageLoader#" + this.mCount.getAndIncrement());
        }
    };
    public static final Executor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), sThreadFactory);
    private Context mContext;
    private LruCache<String, Bitmap> mMemoryCache;
    private DiskLruCache mDiskLruCache;
    private final int MESSAGE_START = 0;
    private final int MESSAGE_LOADED = 1;
    private Handler mUiThreadHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            LoaderResult result = (LoaderResult)msg.obj;
            ImageView imageView = result.imageView;
            switch (msg.what) {
                case 0: {
                    imageView.setImageResource(R.mipmap.loading);
                    break;
                }
                case 1: {
                    imageView.setImageBitmap(result.bitmap);
                    String uri = (String)imageView.getTag();
                    if (uri.equals(result.uri)) {
                        imageView.setImageBitmap(result.bitmap);
                        break;
                    }
                    Log.w((String)ImageLoader.TAG, (String)"set image bitmap, but url has changed, ignored!");
                    break;
                }
            }
        }
    };

    private ImageLoader(Context context) {
        this.mContext = context.getApplicationContext();
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 8;
        this.mMemoryCache = new LruCache<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap value) {
                return value.getRowBytes() * value.getHeight() / 1024;
            }
        };
        File diskCacheDir = this.getDiskCacheDir(this.mContext, "bitmap");
        if (!diskCacheDir.exists()) {
            diskCacheDir.mkdirs();
        }
        if (this.getUsableSpace(diskCacheDir) > 0x3200000L) {
            try {
                this.mDiskLruCache = DiskLruCache.open(diskCacheDir, 1, 1, 0x3200000L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ImageLoader build(Context context) {
        return new ImageLoader(context);
    }

    public void bindImageView(String uri, PhotoView photoView) {
        int reqWidth = 2 * this.mContext.getResources().getDisplayMetrics().widthPixels;
        int reqHeight = 2 * this.mContext.getResources().getDisplayMetrics().heightPixels;
        this.bindImageView(uri, photoView, reqWidth, reqHeight);
    }

    public void bindImageView(final String uri, final PhotoView photoView, final int reqWidth, final int reqHeight) {
        photoView.setTag((Object)uri);
        Bitmap bitmap = this.loadBitmapFromMemoryCache(uri);
        if (bitmap != null) {
            photoView.setImageBitmap(bitmap);
            return;
        }
        Runnable loadBitmapTask = new Runnable(){

            @Override
            public void run() {
                LoaderResult result = new LoaderResult((ImageView)photoView, null, null);
                ImageLoader.this.mUiThreadHandler.obtainMessage(0, (Object)result).sendToTarget();
                Bitmap bitmap = ImageLoader.this.loadBitmap(uri, reqWidth, reqHeight);
                if (bitmap != null) {
                    result = new LoaderResult((ImageView)photoView, uri, bitmap);
                    ImageLoader.this.mUiThreadHandler.obtainMessage(1, (Object)result).sendToTarget();
                }
            }
        };
        THREAD_POOL_EXECUTOR.execute(loadBitmapTask);
    }

    private void addBitmapToMemoryCache(String key, Bitmap bitmap) {
        if (this.getBitmapFromMemoryCache(key) == null) {
            this.mMemoryCache.put((Object)key, (Object)bitmap);
        }
    }

    private Bitmap getBitmapFromMemoryCache(String key) {
        return (Bitmap)this.mMemoryCache.get((Object)key);
    }

    public Bitmap loadBitmap(String uri, int reqWidth, int reqHeight) {
        Bitmap bitmap = this.loadBitmapFromMemoryCache(uri);
        if (bitmap != null) {
            Log.d((String)TAG, (String)("Load Bitmap from memory cache, url: " + uri));
            return bitmap;
        }
        try {
            bitmap = this.loadBitmapFromDiskCache(uri, reqWidth, reqHeight);
            if (bitmap != null) {
                Log.d((String)TAG, (String)("Load Bitmap from disk cache, url: " + uri));
                return bitmap;
            }
            if (uri.charAt(0) == 'h') {
                bitmap = this.loadBitmapFromHttp(uri, reqWidth, reqHeight);
                if (bitmap != null) {
                    Log.d((String)TAG, (String)("Load Bitmap from HTTP, url: " + uri));
                    return bitmap;
                }
            } else if (uri.charAt(0) == '/') {
                bitmap = this.loadBitmapFromExternalStorage(uri, reqWidth, reqHeight);
                if (bitmap != null) {
                    Log.d((String)TAG, (String)("Load Bitmap from external storage, url: " + uri));
                    return bitmap;
                }
            } else {
                bitmap = this.loadBitmapFromResource(uri, reqWidth, reqHeight);
                if (bitmap != null) {
                    Log.d((String)TAG, (String)("Load Bitmap from resource, url: " + uri));
                    return bitmap;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.mDiskLruCache == null) {
            Log.w((String)TAG, (String)"DiskLruCache did not created.");
            bitmap = uri.charAt(0) == 'h' ? this.downloadBitmapFromUrl(uri) : (uri.charAt(0) == '/' ? this.downloadBitmapFromExternalStorage(uri) : this.downloadBitmapFromResource(uri));
        }
        return bitmap;
    }

    private Bitmap loadBitmapFromMemoryCache(String url) {
        String key = this.hashKeyFromUrl(url);
        return this.getBitmapFromMemoryCache(key);
    }

    private Bitmap loadBitmapFromHttp(String url, int reqWidth, int reqHeight) throws IOException {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("Could not access network from UI Thread.");
        }
        if (this.mDiskLruCache == null) {
            return null;
        }
        String key = this.hashKeyFromUrl(url);
        DiskLruCache.Editor editor = this.mDiskLruCache.edit(key);
        if (editor != null) {
            OutputStream outputStream = editor.newOutputStream(0);
            if (this.downloadUrlToStream(url, outputStream)) {
                editor.commit();
            } else {
                editor.abort();
            }
            this.mDiskLruCache.flush();
        }
        return this.loadBitmapFromDiskCache(url, reqWidth, reqHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean downloadUrlToStream(String urlString, OutputStream outputStream) {
        boolean bl;
        BufferedOutputStream out;
        BufferedInputStream in;
        block6: {
            HttpURLConnection urlConnection = null;
            in = null;
            out = null;
            try {
                int b;
                URL url = new URL(urlString);
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setConnectTimeout(5000);
                in = new BufferedInputStream(urlConnection.getInputStream(), 8192);
                out = new BufferedOutputStream(outputStream, 8192);
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                bl = true;
                if (urlConnection == null) break block6;
                urlConnection.disconnect();
            }
            catch (IOException e) {
                block7: {
                    try {
                        e.printStackTrace();
                        Log.e((String)TAG, (String)("download bitmap failed. " + e.getMessage()));
                        if (urlConnection == null) break block7;
                        urlConnection.disconnect();
                    }
                    catch (Throwable throwable) {
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                        Util.close(in);
                        Util.close(out);
                        throw throwable;
                    }
                }
                Util.close(in);
                Util.close(out);
                return false;
            }
        }
        Util.close(in);
        Util.close(out);
        return bl;
    }

    private Bitmap loadBitmapFromExternalStorage(String url, int reqWidth, int reqHeight) throws IOException {
        if (this.mDiskLruCache == null) {
            return null;
        }
        String key = this.hashKeyFromUrl(url);
        DiskLruCache.Editor editor = this.mDiskLruCache.edit(key);
        if (editor != null) {
            OutputStream outputStream = editor.newOutputStream(0);
            if (this.downloadExternalStorageUrlToStream(url, outputStream)) {
                editor.commit();
            } else {
                editor.abort();
            }
            this.mDiskLruCache.flush();
        }
        return this.loadBitmapFromDiskCache(url, reqWidth, reqHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean downloadExternalStorageUrlToStream(String urlString, OutputStream outputStream) {
        boolean bl;
        FileInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int length;
            in = new FileInputStream(urlString);
            out = new BufferedOutputStream(outputStream, 8192);
            int bufferSize = 8192;
            byte[] buffer = new byte[bufferSize];
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            bl = true;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                Log.e((String)TAG, (String)("download bitmap from external storage failed. " + e.getMessage()));
            }
            catch (Throwable throwable) {
                Util.close(in);
                Util.close(out);
                throw throwable;
            }
            Util.close(in);
            Util.close(out);
            return false;
        }
        Util.close(in);
        Util.close(out);
        return bl;
    }

    private Bitmap loadBitmapFromResource(String resId, int reqWidth, int reqHeight) throws IOException {
        if (this.mDiskLruCache == null) {
            return null;
        }
        String key = this.hashKeyFromUrl(resId);
        DiskLruCache.Editor editor = this.mDiskLruCache.edit(key);
        if (editor != null) {
            OutputStream outputStream = editor.newOutputStream(0);
            if (this.downloadResourceToStream(resId, outputStream)) {
                editor.commit();
            } else {
                editor.abort();
            }
            this.mDiskLruCache.flush();
        }
        return this.loadBitmapFromDiskCache(resId, reqWidth, reqHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean downloadResourceToStream(String resIdString, OutputStream outputStream) {
        boolean bl;
        InputStream in = null;
        BufferedOutputStream out = null;
        int resId = Integer.valueOf(resIdString);
        try {
            int b;
            in = this.mContext.getResources().openRawResource(resId);
            out = new BufferedOutputStream(outputStream, 8192);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            bl = true;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                Log.e((String)TAG, (String)("download bitmap from external storage failed. " + e.getMessage()));
            }
            catch (Throwable throwable) {
                Util.close(in);
                Util.close(out);
                throw throwable;
            }
            Util.close(in);
            Util.close(out);
            return false;
        }
        Util.close(in);
        Util.close(out);
        return bl;
    }

    private Bitmap loadBitmapFromDiskCache(String url, int reqWidth, int reqHeight) throws IOException {
        FileInputStream fileInputStream;
        FileDescriptor fileDescriptor;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Log.w((String)TAG, (String)"load bitmap from UI Thread, it is not recommended!");
        }
        if (this.mDiskLruCache == null) {
            return null;
        }
        Bitmap bitmap = null;
        String key = this.hashKeyFromUrl(url);
        DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key);
        if (snapshot != null && (bitmap = ImageUtil.getBitmap(fileDescriptor = (fileInputStream = (FileInputStream)snapshot.getInputStream(0)).getFD(), reqWidth, reqHeight)) != null) {
            this.addBitmapToMemoryCache(key, bitmap);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap downloadBitmapFromUrl(String urlString) {
        BufferedInputStream in;
        Bitmap bitmap;
        block5: {
            bitmap = null;
            HttpURLConnection urlConnection = null;
            in = null;
            try {
                URL url = new URL(urlString);
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setConnectTimeout(5000);
                in = new BufferedInputStream(urlConnection.getInputStream(), 8192);
                bitmap = BitmapFactory.decodeStream((InputStream)in);
                if (urlConnection == null) break block5;
                urlConnection.disconnect();
            }
            catch (IOException e) {
                block6: {
                    try {
                        e.printStackTrace();
                        Log.e((String)TAG, (String)("download bitmap failed. " + e.getMessage()));
                        if (urlConnection == null) break block6;
                        urlConnection.disconnect();
                    }
                    catch (Throwable throwable) {
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                        Util.close(in);
                        throw throwable;
                    }
                }
                Util.close(in);
            }
        }
        Util.close(in);
        return bitmap;
    }

    private Bitmap downloadBitmapFromExternalStorage(String url) {
        return ImageUtil.getBitmap(this.mContext, url);
    }

    private Bitmap downloadBitmapFromResource(String resId) {
        int id = Integer.valueOf(resId);
        return ImageUtil.getBitmap(this.mContext, id);
    }

    private String hashKeyFromUrl(String url) {
        String cacheKey;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(url.getBytes());
            cacheKey = this.bytesToHexString(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(url.hashCode());
        }
        return cacheKey;
    }

    private String bytesToHexString(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(hex);
        }
        return stringBuilder.toString();
    }

    public File getDiskCacheDir(Context context, String uniqueName) {
        boolean isExternalStorageAvailable = Environment.getExternalStorageState().equals("mounted");
        String cachePath = isExternalStorageAvailable ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    @TargetApi(value=9)
    private long getUsableSpace(File path) {
        if (Build.VERSION.SDK_INT >= 9) {
            return path.getUsableSpace();
        }
        StatFs statFs = new StatFs(path.getPath());
        return statFs.getBlockSizeLong() * statFs.getAvailableBlocksLong();
    }

    public static class LoaderResult {
        public ImageView imageView;
        public String uri;
        public Bitmap bitmap;

        public LoaderResult(ImageView imageView, String uri, Bitmap bitmap) {
            this.imageView = imageView;
            this.uri = uri;
            this.bitmap = bitmap;
        }
    }
}

