/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.adapter;

import android.content.Context;
import android.util.Log;
import android.widget.ImageView;
import com.celerysoft.imagepager.adapter.ImagePagerAdapter;
import com.celerysoft.imagepager.util.ImageLoader;
import java.util.ArrayList;
import uk.co.senab.photoview.PhotoView;

public class SimpleImagePagerAdapter
extends ImagePagerAdapter {
    private static final String TAG = SimpleImagePagerAdapter.class.getSimpleName();
    private Context mContext;
    private ImageLoader mImageLoader;
    private ImageView.ScaleType mScaleType;
    private ArrayList<Image> mImages;

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    public ArrayList<Image> getImages() {
        return this.mImages;
    }

    public void setImages(ArrayList<Image> images) {
        this.mImages = images;
    }

    public void addImage(Image image) {
        this.mImages.add(image);
    }

    public void addImage(int index, Image image) {
        this.mImages.add(index, image);
    }

    public SimpleImagePagerAdapter(Context context) {
        this.mContext = context;
        this.mImageLoader = ImageLoader.build(context);
    }

    public SimpleImagePagerAdapter(Context context, ImageView.ScaleType scaleType) {
        this(context);
        this.mScaleType = scaleType;
    }

    @Override
    public PhotoView getItem(int position) {
        PhotoView photoView = null;
        if (this.mImages != null && this.mImages.size() > position) {
            photoView = new PhotoView(this.mContext);
            if (this.mScaleType != null) {
                photoView.setScaleType(this.mScaleType);
            }
            this.mImageLoader.bindImageView(this.mImages.get(position).getUrl(), photoView);
        }
        return photoView;
    }

    @Override
    public int getCount() {
        if (this.mImages != null) {
            return this.mImages.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeImage(int imagePosition) {
        boolean succeeded = true;
        try {
            if (this.mImages != null) {
                this.mImages.remove(imagePosition);
            } else {
                succeeded = false;
                Log.w((String)TAG, (String)"remove image failed, no collection to handle removing operation.");
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("remove image failed, image position: " + imagePosition + ", image count: " + this.getCount()));
            Log.w((String)TAG, (String)("detail: " + e.getMessage()));
            succeeded = false;
        }
        finally {
            if (succeeded) {
                this.mIsRemovedImage = true;
                this.notifyDataSetChanged();
            }
        }
        return succeeded;
    }

    public static class Image {
        int mImageResId = -1;
        String mImagePath = null;
        String mImageUrl = null;

        public void setImageResId(int imageResId) {
            this.mImageResId = imageResId;
            this.mImagePath = null;
            this.mImageUrl = null;
        }

        public void setImagePath(String imagePath) {
            this.mImageResId = -1;
            this.mImagePath = imagePath;
            this.mImageUrl = null;
        }

        public void setImageUrl(String imageUrl) {
            this.mImageResId = -1;
            this.mImageUrl = null;
            this.mImageUrl = imageUrl;
        }

        public String getUrl() {
            if (this.mImageResId != -1) {
                return Integer.toString(this.mImageResId);
            }
            if (this.mImagePath != null) {
                return this.mImagePath;
            }
            if (this.mImageUrl != null) {
                return this.mImageUrl;
            }
            Log.w((String)TAG, (String)"this image has no url");
            return null;
        }
    }
}

