/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.view.indicator;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.widget.TextView;
import com.celerysoft.imagepager.R;
import com.celerysoft.imagepager.view.indicator.Indicator;
import java.util.Locale;

public class TextIndicator
extends TextView
implements Indicator {
    private static final String TAG = "TextIndicator";
    private Context mContext;
    private int mImageCount;
    private int mCurrentImagePosition = 0;
    private float mTextSize = 16.0f;

    public TextIndicator(Context context) {
        super(context);
        this.mContext = context;
        this.setGravity(17);
        this.setTextSize(this.mTextSize);
        this.setBackgroundResource(R.drawable.indicator_background);
        if (Build.VERSION.SDK_INT >= 23) {
            this.setTextColor(context.getResources().getColor(R.color.text_indicator_text_color, null));
        } else {
            this.setTextColor(context.getResources().getColor(R.color.text_indicator_text_color));
        }
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.mTextSize = size;
    }

    @Override
    public void onPageSelected(int position) {
        String text = String.format(Locale.getDefault(), "%d/%d", position + 1, this.mImageCount);
        this.setText(text);
        this.mCurrentImagePosition = position;
    }

    @Override
    public void onPageDeleted() {
        String text;
        --this.mImageCount;
        int n = this.mCurrentImagePosition = this.mCurrentImagePosition < this.mImageCount ? this.mCurrentImagePosition : this.mImageCount - 1;
        if (this.mImageCount <= 0) {
            this.setTextSize(this.mTextSize * 1.25f);
            text = this.mContext.getString(R.string.no_images);
            if (this.mImageCount < 0) {
                Log.e((String)TAG, (String)"image count less than 0, it could not be happened!");
            }
        } else {
            this.setTextSize(this.mTextSize);
            text = String.format(Locale.getDefault(), "%d/%d", this.mCurrentImagePosition + 1, this.mImageCount);
        }
        this.setText(text);
    }

    @Override
    public void onPageAdapterChanged(int imageCount) {
        this.mImageCount = imageCount;
        this.mCurrentImagePosition = 0;
        String text = String.format(Locale.getDefault(), "1/%d", this.mImageCount);
        this.setText(text);
    }
}

