/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.view.indicator;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.celerysoft.imagepager.R;
import com.celerysoft.imagepager.util.DensityUtil;
import com.celerysoft.imagepager.view.indicator.Indicator;

public class DotIndicator
extends LinearLayout
implements Indicator {
    private static final String TAG = "DotIndicator";
    private int mImageCount;
    private int mCurrentImagePosition;
    private int mSelectedImageResourceId = R.drawable.ic_selected;
    private int mUnselectedImageResourceId = R.drawable.ic_unselected;

    public DotIndicator(Context context) {
        super(context);
        this.setOrientation(0);
        this.setBackgroundResource(R.drawable.indicator_background);
    }

    public void setSelectedImageResource(int resId) {
        this.mSelectedImageResourceId = resId;
    }

    public void setUnselectedImageResource(int resId) {
        this.mUnselectedImageResourceId = resId;
    }

    @Override
    public void onPageSelected(int position) {
        this.mCurrentImagePosition = position;
        this.updateUi(position);
    }

    @Override
    public void onPageDeleted() {
        this.removeViewAt(this.mImageCount - 1);
        --this.mImageCount;
        int n = this.mCurrentImagePosition = this.mCurrentImagePosition < this.mImageCount ? this.mCurrentImagePosition : this.mImageCount - 1;
        if (this.mImageCount <= 0) {
            TextView textView = new TextView(this.getContext());
            textView.setTextSize(20.0f);
            String text = this.getContext().getString(R.string.no_images);
            textView.setText((CharSequence)text);
            this.addView((View)textView);
            if (this.mImageCount < 0) {
                Log.e((String)TAG, (String)"image count less than 0, it could not be happened!");
            }
        } else {
            this.updateUi(this.mCurrentImagePosition);
        }
    }

    @Override
    public void onPageAdapterChanged(int imageCount) {
        this.mImageCount = imageCount;
        this.mCurrentImagePosition = 0;
        this.removeAllViews();
        for (int i = 0; i < this.mImageCount; ++i) {
            View view = new View(this.getContext());
            if (i == 0) {
                view.setBackgroundResource(this.mSelectedImageResourceId);
            } else {
                view.setBackgroundResource(this.mUnselectedImageResourceId);
            }
            this.addView(view);
            view.getLayoutParams().width = DensityUtil.dp2px(this.getContext(), 12.0f);
            view.getLayoutParams().height = DensityUtil.dp2px(this.getContext(), 12.0f);
            view.requestLayout();
        }
    }

    private void updateUi(int selectedImagePosition) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View v = this.getChildAt(i);
            if (i == selectedImagePosition) {
                if (this.mSelectedImageResourceId == -1) continue;
                v.setBackgroundResource(this.mSelectedImageResourceId);
                continue;
            }
            if (this.mUnselectedImageResourceId == -1) continue;
            v.setBackgroundResource(this.mUnselectedImageResourceId);
        }
    }
}

