/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.celerysoft.imagepager.R;
import com.celerysoft.imagepager.adapter.ImagePagerAdapter;
import com.celerysoft.imagepager.view.Pager;
import com.celerysoft.imagepager.view.indicator.Indicator;
import com.celerysoft.imagepager.view.indicator.TextIndicator;

public class ImagePager
extends ViewGroup {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private final int CHILD_COUNT = 2;
    private Context mContext;
    private Pager mPager;
    private Indicator mIndicator;
    private ImagePagerAdapter mAdapter;
    private OnImageChangeListener mOnImageChangeListener;
    private OnImageClickListener mOnImageClickListener;
    private OnPageClickListener mOnPageClickListener;

    public ImagePagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(ImagePagerAdapter adapter) {
        this.mAdapter = adapter;
        ImagePagerAdapter imagePagerAdapter = adapter;
        if (this.mOnPageClickListener != null) {
            imagePagerAdapter.setOnPageClickListenerListener(this.mOnPageClickListener);
        }
        if (this.mOnImageClickListener != null) {
            imagePagerAdapter.setOnImageClickListener(this.mOnImageClickListener);
        }
        this.mPager.setAdapter(adapter);
        this.mIndicator.onPageAdapterChanged(adapter.getCount());
        this.mAdapter.setIndicator(this.mIndicator);
    }

    public OnImageChangeListener getOnImageChangeListener() {
        return this.mOnImageChangeListener;
    }

    public void setOnImageChangeListener(OnImageChangeListener onImageChangeListener) {
        this.mOnImageChangeListener = onImageChangeListener;
    }

    public OnImageClickListener getOnImageClickListener() {
        return this.mOnImageClickListener;
    }

    public void setOnImageClickListener(OnImageClickListener onImageClickListener) {
        this.mOnImageClickListener = onImageClickListener;
        if (this.mAdapter != null) {
            this.mAdapter.setOnImageClickListener(onImageClickListener);
        }
    }

    public OnPageClickListener getOnPageClickListener() {
        return this.mOnPageClickListener;
    }

    public void setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        if (this.mAdapter != null) {
            this.mAdapter.setOnPageClickListenerListener(onPageClickListener);
        }
    }

    public ImagePager(Context context) {
        super(context);
        this.initImagePager();
    }

    public ImagePager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initImagePager();
    }

    private void initImagePager() {
        this.mContext = this.getContext();
        try {
            this.setBackgroundColor(this.getResources().getColor(R.color.image_pager_background, null));
        }
        catch (NoSuchMethodError e) {
            this.setBackgroundColor(this.getResources().getColor(R.color.image_pager_background));
        }
        this.mPager = new Pager(this.mContext);
        this.addView((View)this.mPager, new ViewGroup.LayoutParams(-1, -1));
        this.mIndicator = new TextIndicator(this.mContext);
        this.addView((View)this.mIndicator, new ViewGroup.LayoutParams(-2, -2));
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (ImagePager.this.mOnImageChangeListener != null) {
                    ImagePager.this.mOnImageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
                }
            }

            public void onPageSelected(int position) {
                if (ImagePager.this.mOnImageChangeListener != null) {
                    ImagePager.this.mOnImageChangeListener.onPageSelected(position);
                }
                ImagePager.this.mIndicator.onPageSelected(position);
            }

            public void onPageScrollStateChanged(int state) {
                if (ImagePager.this.mOnImageChangeListener != null) {
                    ImagePager.this.mOnImageChangeListener.onPageScrollStateChanged(state);
                }
            }
        });
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int childCount = this.getChildCount();
        if (childCount != 2) {
            Log.e((String)this.TAG, (String)"wtf, child count must be 3!");
        }
        int childWidth = 0;
        int childHeight = 0;
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(0);
            if (!(childView instanceof Pager)) continue;
            childWidth = childView.getMeasuredWidth();
            childHeight = childView.getMeasuredHeight();
        }
        int measureWidth = childWidth;
        int measureHeight = childHeight;
        measureWidth = widthMode == Integer.MIN_VALUE ? measureWidth : widthSize;
        measureHeight = heightMode == Integer.MIN_VALUE ? measureHeight : heightSize;
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        if (childCount != 2) {
            Log.e((String)this.TAG, (String)"wtf, child count must be 2!");
        }
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            int left = l;
            int top = t;
            int right = r;
            int bottom = b;
            if (childView instanceof Indicator) {
                int horizontalMargin = (this.getMeasuredWidth() - childView.getMeasuredWidth()) / 2;
                left += horizontalMargin;
                right -= horizontalMargin;
                top = this.getMeasuredHeight() - (int)((double)childView.getMeasuredHeight() * 2.5);
                bottom = top + childView.getMeasuredHeight();
            } else if (!(childView instanceof Pager)) {
                Log.e((String)this.TAG, (String)"wtfffff!");
                childView.layout(l, t, r, b);
                continue;
            }
            childView.layout(left, top, right, bottom);
        }
    }

    public int getCurrentImagePosition() {
        return this.mPager.getCurrentItem();
    }

    public void moveToImage(int imagePosition) {
        this.mPager.setCurrentItem(imagePosition);
    }

    public void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.mPager.setPageTransformer(reverseDrawingOrder, transformer);
    }

    public void setOffscreenPageLimit(int limit) {
        this.mPager.setOffscreenPageLimit(limit);
    }

    public static interface OnPageClickListener {
        public void onPageClick();
    }

    public static interface OnImageClickListener {
        public void onImageClick();
    }

    public static interface OnImageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }
}

