/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.adapter;

import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.celerysoft.imagepager.ImagePager;
import com.celerysoft.imagepager.view.indicator.Indicator;
import java.util.ArrayList;
import uk.co.senab.photoview.PhotoView;
import uk.co.senab.photoview.PhotoViewAttacher;

public abstract class ImagePagerAdapter
extends PagerAdapter {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private final boolean DEBUG = false;
    private ArrayList<PhotoView> mImageViews = new ArrayList();
    private PhotoView mCurrentPrimaryItem = null;
    private int mImageViewCount;
    private Indicator mIndicator;
    private ImagePager.OnImageClickListener mOnPhotoTapListener;
    private ImagePager.OnPageClickListener mOnPageClickListener;

    public void setIndicator(Indicator indicator) {
        this.mIndicator = indicator;
    }

    public void setOnImageClickListener(ImagePager.OnImageClickListener onImageClickListener) {
        this.mOnPhotoTapListener = onImageClickListener;
    }

    public void setOnPageClickListenerListener(ImagePager.OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
    }

    public abstract PhotoView getItem(int var1);

    public abstract boolean removeImage(int var1);

    public abstract int getCount();

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        PhotoView v;
        if (this.mImageViews.size() > position && (v = this.mImageViews.get(position)) != null) {
            container.addView((View)v, -1, -1);
            return v;
        }
        PhotoView imageView = this.getItem(position);
        while (this.mImageViews.size() <= position) {
            this.mImageViews.add(null);
        }
        imageView.setVisibility(0);
        this.mImageViews.set(position, imageView);
        if (this.mOnPageClickListener != null) {
            imageView.setOnViewTapListener(new PhotoViewAttacher.OnViewTapListener(){

                public void onViewTap(View view, float x, float y) {
                    ImagePagerAdapter.this.mOnPageClickListener.onPageClick();
                }
            });
        }
        if (this.mOnPhotoTapListener != null) {
            imageView.setOnPhotoTapListener(new PhotoViewAttacher.OnPhotoTapListener(){

                public void onPhotoTap(View view, float x, float y) {
                    ImagePagerAdapter.this.mOnPhotoTapListener.onImageClick();
                }
            });
        }
        container.addView((View)imageView, -1, -1);
        return imageView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        PhotoView imageView = (PhotoView)object;
        if (imageView != null && this.mImageViews.size() > 0) {
            int index = this.mImageViews.indexOf(imageView);
            this.mImageViews.set(index, null);
        }
        container.removeView((View)object);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        PhotoView imageView;
        this.mCurrentPrimaryItem = imageView = (PhotoView)object;
    }

    public int getItemPosition(Object object) {
        PhotoView imageView = (PhotoView)object;
        int positon = this.mImageViews.indexOf(imageView);
        if (positon == -1) {
            return -2;
        }
        return positon;
    }

    public Parcelable saveState() {
        return super.saveState();
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        super.restoreState(state, loader);
    }

    public void notifyDataSetChanged() {
        if (this.isDeleteAction()) {
            this.mIndicator.onPageDeleted();
        }
        this.mImageViews = new ArrayList();
        super.notifyDataSetChanged();
    }

    private boolean isDeleteAction() {
        return this.mImageViews.size() - this.getCount() == 1;
    }
}

