/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.reflect;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.SystemUtilities;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class Accessor {
    private static final boolean IS_JDK17_OR_HIGHER;
    private static final Object LOOKUP;
    private static final Method PRIVATE_LOOKUP_IN_METHOD;
    private static final Method FIND_VAR_HANDLE_METHOD;
    private static final MethodHandle VAR_HANDLE_GET_METHOD;
    private final String uniqueFieldName;
    private final Field field;
    private final boolean isMethod;
    private final String fieldOrMethodName;
    private final MethodHandle methodHandle;
    private final Object varHandle;
    private final boolean isPublic;

    private Accessor(Field field, MethodHandle methodHandle, String uniqueFieldName, String fieldOrMethodName, boolean isPublic, boolean isMethod) {
        this.field = field;
        this.methodHandle = methodHandle;
        this.varHandle = null;
        this.uniqueFieldName = uniqueFieldName;
        this.fieldOrMethodName = fieldOrMethodName;
        this.isPublic = isPublic;
        this.isMethod = isMethod;
    }

    private Accessor(Field field, Object varHandle, String uniqueFieldName, String fieldOrMethodName, boolean isPublic) {
        this.field = field;
        this.methodHandle = null;
        this.varHandle = varHandle;
        this.uniqueFieldName = uniqueFieldName;
        this.fieldOrMethodName = fieldOrMethodName;
        this.isPublic = isPublic;
        this.isMethod = false;
    }

    public static Accessor createFieldAccessor(Field field, String uniqueFieldName) {
        boolean isPublicField;
        boolean bl = isPublicField = Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers());
        if (!isPublicField) {
            ExceptionUtilities.safelyIgnoreException(() -> field.setAccessible(true));
        }
        try {
            MethodHandle handle = MethodHandles.lookup().unreflectGetter(field);
            return new Accessor(field, handle, uniqueFieldName, field.getName(), Modifier.isPublic(field.getModifiers()), false);
        }
        catch (IllegalAccessException ex) {
            Accessor varHandleAccessor;
            if (IS_JDK17_OR_HIGHER && (varHandleAccessor = Accessor.createWithVarHandle(field, uniqueFieldName)) != null) {
                return varHandleAccessor;
            }
            return new Accessor(field, null, uniqueFieldName, field.getName(), Modifier.isPublic(field.getModifiers()), false);
        }
    }

    private static Accessor createWithVarHandle(Field field, String uniqueFieldName) {
        if (PRIVATE_LOOKUP_IN_METHOD == null || FIND_VAR_HANDLE_METHOD == null || VAR_HANDLE_GET_METHOD == null || LOOKUP == null) {
            return null;
        }
        try {
            Class<?> declaringClass = field.getDeclaringClass();
            Object privateLookup = PRIVATE_LOOKUP_IN_METHOD.invoke(null, declaringClass, LOOKUP);
            if (privateLookup == null) {
                return null;
            }
            Object varHandle = FIND_VAR_HANDLE_METHOD.invoke(privateLookup, declaringClass, field.getName(), field.getType());
            if (varHandle == null) {
                return null;
            }
            return new Accessor(field, varHandle, uniqueFieldName, field.getName(), Modifier.isPublic(field.getModifiers()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Accessor createMethodAccessor(Field field, String methodName, String uniqueFieldName) {
        try {
            MethodType type = MethodType.methodType(field.getType());
            MethodHandle handle = MethodHandles.publicLookup().findVirtual(field.getDeclaringClass(), methodName, type);
            return new Accessor(field, handle, uniqueFieldName, methodName, true, true);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public Object retrieve(Object o) {
        if (o == null) {
            throw new JsonIoException("Cannot retrieve field value from null object for field: " + this.getActualFieldName());
        }
        try {
            if (this.varHandle != null) {
                try {
                    return VAR_HANDLE_GET_METHOD.invoke(this.varHandle, o);
                }
                catch (Throwable t) {
                    return this.field.get(o);
                }
            }
            if (this.methodHandle != null) {
                try {
                    return this.methodHandle.invoke(o);
                }
                catch (Throwable t) {
                    return this.field.get(o);
                }
            }
            return this.field.get(o);
        }
        catch (IllegalAccessException e) {
            Class<?> dc = this.field.getDeclaringClass();
            if (Accessor.isJdkInternalClass(dc)) {
                return Accessor.handleInaccessibleJdkField(dc, this.getActualFieldName());
            }
            throw new JsonIoException("Failed to retrieve field value: " + this.getActualFieldName() + " in class: " + dc.getName(), e);
        }
        catch (Throwable t) {
            throw new JsonIoException("Failed to retrieve field value: " + this.getActualFieldName() + " in class: " + this.field.getDeclaringClass().getName(), t);
        }
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getActualFieldName() {
        return this.field.getName();
    }

    public String getUniqueFieldName() {
        return this.uniqueFieldName;
    }

    public String getFieldOrMethodName() {
        return this.fieldOrMethodName;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    private static boolean isJdkInternalClass(Class<?> clazz) {
        String className = clazz.getName();
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.contains(".internal.");
    }

    private static Object handleInaccessibleJdkField(Class<?> declaringClass, String fieldName) {
        return null;
    }

    static {
        int javaVersion = SystemUtilities.currentJdkMajorVersion();
        IS_JDK17_OR_HIGHER = javaVersion >= 17;
        Object lookup = null;
        Method privateLookupInMethod = null;
        Method findVarHandleMethod = null;
        MethodHandle varHandleGetMethod = null;
        if (javaVersion >= 9) {
            try {
                Class<?> methodHandlesClass = Class.forName("java.lang.invoke.MethodHandles");
                Class<?> lookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup");
                Method lookupMethod = ReflectionUtils.getMethod(methodHandlesClass, (String)"lookup", (Class[])new Class[0]);
                lookup = lookupMethod.invoke(null, new Object[0]);
                privateLookupInMethod = ReflectionUtils.getMethod(methodHandlesClass, (String)"privateLookupIn", (Class[])new Class[]{Class.class, lookupClass});
                Class<?> varHandleClass = Class.forName("java.lang.invoke.VarHandle");
                findVarHandleMethod = ReflectionUtils.getMethod(lookupClass, (String)"findVarHandle", (Class[])new Class[]{Class.class, String.class, Class.class});
                MethodType getType = MethodType.methodType(Object.class, Object.class);
                varHandleGetMethod = MethodHandles.publicLookup().findVirtual(varHandleClass, "get", getType);
            }
            catch (Exception e) {
                lookup = null;
                privateLookupInMethod = null;
                findVarHandleMethod = null;
                varHandleGetMethod = null;
            }
        }
        LOOKUP = lookup;
        PRIVATE_LOOKUP_IN_METHOD = privateLookupInMethod;
        FIND_VAR_HANDLE_METHOD = findVarHandleMethod;
        VAR_HANDLE_GET_METHOD = varHandleGetMethod;
    }
}

