/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.ClassFactory;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.CompactMap;
import java.util.Map;

public class CompactMapFactory
implements ClassFactory {
    @Override
    public Map newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        String order;
        String orderCode;
        String configStr = resolver.readString(jObj, "config");
        if (configStr == null) {
            throw new JsonIoException("CompactMap requires a config string");
        }
        Object dataObj = jObj.get("data");
        if (!(dataObj instanceof Map)) {
            throw new JsonIoException("CompactMap requires a data section");
        }
        String[] parts = configStr.split("/");
        if (parts.length != 5) {
            throw new JsonIoException("Invalid CompactMap config format: " + configStr);
        }
        String mapClassName = parts[0];
        boolean caseSensitive = "CS".equals(parts[1]);
        int compactSize = Integer.parseInt(parts[2].substring(1));
        String singleKey = "-".equals(parts[3]) ? null : parts[3];
        switch (orderCode = parts[4]) {
            case "Sort": {
                order = "sorted";
                break;
            }
            case "Rev": {
                order = "reverse";
                break;
            }
            case "Ins": {
                order = "insertion";
                break;
            }
            default: {
                order = "unordered";
            }
        }
        Class mapImplClass = null;
        Class cls = ClassUtilities.forName((String)mapClassName, (ClassLoader)ClassUtilities.getClassLoader());
        if (Map.class.isAssignableFrom(cls)) {
            mapImplClass = cls;
        }
        CompactMap.Builder builder = CompactMap.builder().caseSensitive(caseSensitive).compactSize(compactSize);
        if (singleKey != null && !singleKey.isEmpty()) {
            builder.singleValueKey((Object)singleKey);
        }
        switch (order) {
            case "sorted": {
                builder.sortedOrder();
                break;
            }
            case "reverse": {
                builder.reverseOrder();
                break;
            }
            case "insertion": {
                builder.insertionOrder();
                break;
            }
            default: {
                builder.noOrder();
            }
        }
        if (mapImplClass != null) {
            builder.mapType(mapImplClass);
        }
        CompactMap cmap = builder.build();
        Map data = (Map)dataObj;
        for (Map.Entry entry : data.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof JsonObject) {
                key = resolver.toJava(((JsonObject)key).getType(), key);
            }
            if (value instanceof JsonObject) {
                value = resolver.toJava(((JsonObject)value).getType(), value);
            }
            cmap.put(key, value);
        }
        jObj.remove("config");
        jObj.remove("data");
        jObj.setTarget(cmap);
        return cmap;
    }
}

