/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.ClassFactory;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.Resolver;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionFactory
implements ClassFactory {
    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        int initialCapacity;
        int defaultCapacity = resolver.getReadOptions().getDefaultCollectionCapacity();
        float loadFactor = resolver.getReadOptions().getCollectionLoadFactor();
        int minCapacity = resolver.getReadOptions().getMinCollectionCapacity();
        Object[] items = jObj.getItems();
        int n = initialCapacity = items != null ? items.length : defaultCapacity;
        if (Deque.class.isAssignableFrom(c)) {
            return new ArrayDeque(initialCapacity);
        }
        if (Queue.class.isAssignableFrom(c)) {
            return new LinkedList();
        }
        if (List.class.isAssignableFrom(c)) {
            return new ArrayList(initialCapacity);
        }
        if (NavigableSet.class.isAssignableFrom(c)) {
            return new TreeSet();
        }
        if (SortedSet.class.isAssignableFrom(c)) {
            return new TreeSet();
        }
        if (Set.class.isAssignableFrom(c)) {
            int capacity = Math.max(minCapacity, (int)((float)initialCapacity / loadFactor) + 1);
            return new LinkedHashSet(capacity);
        }
        if (Collection.class.isAssignableFrom(c)) {
            return new ArrayList(initialCapacity);
        }
        throw new JsonIoException("CollectionFactory handed Class for which it was not expecting: " + c.getName());
    }
}

