/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonClassWriter;
import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriterContext;
import com.cedarsoftware.util.Converter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

public class Writers {
    private Writers() {
    }

    public static class UUIDWriter
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            UUID uuid = (UUID)o;
            JsonWriter.writeBasicString(output, uuid.toString());
        }
    }

    public static class BigDecimalWriter
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            BigDecimal big = (BigDecimal)o;
            JsonWriter.writeBasicString(output, big.toPlainString());
        }
    }

    public static class CurrencyWriter
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            Currency currency = (Currency)o;
            JsonWriter.writeJsonUtf8String(output, currency.getCurrencyCode());
        }
    }

    public static class PatternWriter
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            Pattern pattern = (Pattern)o;
            JsonWriter.writeJsonUtf8String(output, pattern.pattern());
        }
    }

    public static class BigIntegerWriter
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            BigInteger big = (BigInteger)o;
            JsonWriter.writeBasicString(output, big.toString(10));
        }
    }

    public static class LocaleWriter
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            Locale locale = (Locale)o;
            JsonWriter.writeJsonUtf8String(output, locale.toLanguageTag());
        }
    }

    public static class JsonStringWriter
    extends PrimitiveUtf8StringWriter {
    }

    public static class TimestampWriter
    extends PrimitiveTypeWriter {
        @Override
        protected String getKey() {
            return "timestamp";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            String formatted = (String)Converter.convert((Object)o, String.class);
            JsonWriter.writeJsonUtf8String(output, formatted);
        }
    }

    public static class YearWriter
    extends PrimitiveTypeWriter {
        @Override
        protected String getKey() {
            return "year";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            String formatted = (String)Converter.convert((Object)o, String.class);
            JsonWriter.writeJsonUtf8String(output, formatted);
        }
    }

    public static class PeriodWriter
    extends PrimitiveTypeWriter {
        @Override
        public String getKey() {
            return "period";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            Period p = (Period)o;
            JsonWriter.writeJsonUtf8String(output, p == null ? null : p.toString());
        }
    }

    public static class DurationWriter
    extends PrimitiveTypeWriter {
        @Override
        public String getKey() {
            return "duration";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            Duration d = (Duration)o;
            JsonWriter.writeJsonUtf8String(output, d == null ? null : d.toString());
        }
    }

    public static class ZoneOffsetWriter
    extends PrimitiveTypeWriter {
        @Override
        protected String getKey() {
            return "zoneOffset";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            ZoneOffset zo = (ZoneOffset)o;
            JsonWriter.writeJsonUtf8String(output, zo == null ? null : zo.toString());
        }
    }

    public static class InstantWriter
    extends PrimitiveTypeWriter {
        @Override
        protected String getKey() {
            return "instant";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            Instant instant = (Instant)o;
            JsonWriter.writeJsonUtf8String(output, instant == null ? null : instant.toString());
        }
    }

    public static class OffsetDateTimeWriter
    extends PrimitiveTypeWriter {
        private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_OFFSET_DATE_TIME).toFormatter();

        @Override
        protected String getKey() {
            return "offsetDateTime";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            OffsetDateTime odt = (OffsetDateTime)o;
            JsonWriter.writeJsonUtf8String(output, odt == null ? null : FORMATTER.format(odt));
        }
    }

    public static class OffsetTimeWriter
    extends PrimitiveTypeWriter {
        private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_OFFSET_TIME).toFormatter();

        @Override
        protected String getKey() {
            return "offsetTime";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            OffsetTime ot = (OffsetTime)o;
            JsonWriter.writeJsonUtf8String(output, ot == null ? null : FORMATTER.format(ot));
        }
    }

    public static class MonthDayWriter
    extends PrimitiveTypeWriter {
        @Override
        protected String getKey() {
            return "monthDay";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            MonthDay md = (MonthDay)o;
            JsonWriter.writeJsonUtf8String(output, md == null ? null : md.toString());
        }
    }

    public static class YearMonthWriter
    extends PrimitiveTypeWriter {
        private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 19, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();

        @Override
        protected String getKey() {
            return "yearMonth";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            YearMonth ym = (YearMonth)o;
            JsonWriter.writeJsonUtf8String(output, ym == null ? null : FORMATTER.format(ym));
        }
    }

    public static class ZonedDateTimeWriter
    extends PrimitiveTypeWriter {
        private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_OFFSET_DATE_TIME).appendLiteral('[').appendZoneId().appendLiteral(']').toFormatter();

        @Override
        protected String getKey() {
            return "zonedDateTime";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            ZonedDateTime zdt = (ZonedDateTime)o;
            if (zdt == null) {
                JsonWriter.writeBasicString(output, null);
                return;
            }
            if (zdt.getZone().equals(ZoneOffset.UTC) || zdt.getZone().getId().equals("Z")) {
                zdt = zdt.withZoneSameInstant(ZoneId.of("UTC"));
            }
            JsonWriter.writeJsonUtf8String(output, FORMATTER.format(zdt));
        }
    }

    public static class LocalDateTimeWriter
    extends PrimitiveTypeWriter {
        private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).toFormatter();

        @Override
        protected String getKey() {
            return "localDateTime";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            LocalDateTime ldt = (LocalDateTime)o;
            JsonWriter.writeJsonUtf8String(output, ldt == null ? null : FORMATTER.format(ldt));
        }
    }

    public static class LocalTimeWriter
    extends PrimitiveTypeWriter {
        private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

        @Override
        protected String getKey() {
            return "localTime";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            LocalTime lt = (LocalTime)o;
            JsonWriter.writeJsonUtf8String(output, lt == null ? null : FORMATTER.format(lt));
        }
    }

    public static class LocalDateWriter
    extends PrimitiveTypeWriter {
        private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).toFormatter();

        @Override
        protected String getKey() {
            return "localDate";
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            LocalDate ld = (LocalDate)o;
            JsonWriter.writeJsonUtf8String(output, ld == null ? null : FORMATTER.format(ld));
        }
    }

    public static class LocalDateAsLong
    extends PrimitiveTypeWriter {
        private final ZoneId zoneId;

        public LocalDateAsLong(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public LocalDateAsLong() {
            this(ZoneId.systemDefault());
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext writerContext) throws IOException {
            LocalDate localDate = (LocalDate)o;
            ZonedDateTime zonedDateTime = localDate.atStartOfDay(this.zoneId);
            Instant instant = zonedDateTime.toInstant();
            long epochMilli = instant.toEpochMilli();
            output.write(Long.toString(epochMilli));
        }
    }

    public static class DateAsLongWriter
    extends DateWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            if (o instanceof Date) {
                String formatted = ((Date)o).toLocalDate().toString();
                JsonWriter.writeBasicString(output, formatted);
            } else {
                output.write(Long.toString(((java.util.Date)o).getTime()));
            }
        }
    }

    public static class DateWriter
    implements JsonClassWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            if (o instanceof Date) {
                String formatted = ((Date)o).toLocalDate().toString();
                JsonWriter.writeBasicString(output, formatted);
            } else {
                String formatted = (String)Converter.convert((Object)o, String.class);
                JsonWriter.writeBasicString(output, formatted);
            }
        }

        public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
            if (showType) {
                String key = obj instanceof Date ? "sqlDate" : "date";
                JsonWriter.writeBasicString(output, key);
                output.write(58);
            }
            this.writePrimitiveForm(obj, output, context);
        }

        @Override
        public boolean hasPrimitiveForm(WriterContext context) {
            return true;
        }
    }

    public static class CalendarWriter
    implements JsonClassWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            String formatted = (String)Converter.convert((Object)o, String.class);
            JsonWriter.writeBasicString(output, formatted);
        }

        public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
            if (showType) {
                JsonWriter.writeBasicString(output, "calendar");
                output.write(58);
            }
            this.writePrimitiveForm(obj, output, context);
        }

        @Override
        public boolean hasPrimitiveForm(WriterContext context) {
            return true;
        }
    }

    public static class EnumsAsStringWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        protected String getKey() {
            return "name";
        }

        @Override
        public String extractString(Object o) {
            return ((Enum)o).name();
        }
    }

    public static class ClassWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        public String extractString(Object o) {
            return ((Class)o).getName();
        }
    }

    public static class TimeZoneWriter
    extends PrimitiveUtf8StringWriter {
        @Override
        public String extractString(Object o) {
            return ((TimeZone)o).getID();
        }
    }

    public static class CharacterWriter
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            JsonWriter.writeJsonUtf8String(output, "" + ((Character)o).charValue());
        }
    }

    public static class PrimitiveUtf8StringWriter
    extends PrimitiveTypeWriter {
        public String extractString(Object o) {
            return o == null ? null : o.toString();
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext writerContext) throws IOException {
            WriteOptions options = writerContext != null ? writerContext.getWriteOptions() : null;
            JsonWriter.writeJson5String(output, this.extractString(o), options);
        }
    }

    public static class DoubleWriter
    extends FloatingPointWriter<Double> {
        @Override
        boolean isNanOrInfinity(Double value) {
            return value.isNaN() || value.isInfinite();
        }
    }

    public static class FloatWriter
    extends FloatingPointWriter<Float> {
        @Override
        boolean isNanOrInfinity(Float value) {
            return value.isNaN() || value.isInfinite();
        }
    }

    public static abstract class FloatingPointWriter<T>
    extends PrimitiveTypeWriter {
        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            boolean allowNanInfinity;
            WriteOptions options = context.getWriteOptions();
            boolean bl = allowNanInfinity = options.isAllowNanAndInfinity() || options.isJson5InfinityNaN();
            if (allowNanInfinity || !this.isNanOrInfinity(o)) {
                output.write(o.toString());
            } else {
                output.write("null");
            }
        }

        abstract boolean isNanOrInfinity(T var1);
    }

    public static class PrimitiveValueWriter
    extends PrimitiveTypeWriter {
        public String extractString(Object o) {
            return o.toString();
        }

        @Override
        public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
            output.write(this.extractString(o));
        }
    }

    public static class PrimitiveTypeWriter
    implements JsonClassWriter {
        protected String getKey() {
            return "value";
        }

        public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
            if (showType) {
                JsonWriter.writeBasicString(output, this.getKey());
                output.write(58);
            }
            this.writePrimitiveForm(obj, output, context);
        }

        @Override
        public boolean hasPrimitiveForm(WriterContext writerContext) {
            return true;
        }
    }
}

