/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MapResolver
extends Resolver {
    public MapResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    <T> T toJavaObjects(JsonObject rootObj, Type rootType) {
        this.verifyRootType(rootType);
        return super.toJavaObjects(rootObj, rootType);
    }

    private void verifyRootType(Type rootType) {
        Class rawTypeToCheck;
        if (rootType == null) {
            return;
        }
        Converter converter = this.getConverter();
        Class rawRootType = TypeUtilities.getRawClass((Type)rootType);
        Class<?> typeToCheck = rootType;
        if (rawRootType != null && rawRootType.isArray()) {
            Class ultimateRawType;
            while (true) {
                if (typeToCheck instanceof Class) {
                    Class cls = typeToCheck;
                    if (!cls.isArray()) break;
                    typeToCheck = cls.getComponentType();
                    continue;
                }
                if (!(typeToCheck instanceof GenericArrayType)) break;
                typeToCheck = ((GenericArrayType)((Object)typeToCheck)).getGenericComponentType();
            }
            if (converter.isSimpleTypeConversionSupported(ultimateRawType = TypeUtilities.getRawClass((Type)typeToCheck)) || ultimateRawType != null && ultimateRawType.equals(Object.class)) {
                return;
            }
        } else if (converter.isSimpleTypeConversionSupported(rawRootType)) {
            return;
        }
        if ((rawTypeToCheck = TypeUtilities.getRawClass((Type)typeToCheck)) != null) {
            if (Collection.class.isAssignableFrom(rawTypeToCheck)) {
                return;
            }
            if (Map.class.isAssignableFrom(rawTypeToCheck)) {
                return;
            }
        }
        String typeName = rawRootType != null ? rawRootType.getName() : ((Object)rootType).toString();
        throw new JsonIoException("In readOptions.isReturningJsonObjects() mode, the rootType '" + typeName + "' is not supported. Allowed types are:\n- null\n- primitive types (e.g., int, boolean) and their wrapper classes (e.g., Integer, Boolean)\n- types supported by Converter.convert()\n- Map or any of its subclasses\n- Collection or any of its subclasses\n- Arrays (of any depth) of the above types\nPlease use one of these types as the rootType, or enable readOptions.isReturningJavaObjects().");
    }

    private void substituteSortedCollectionType(JsonObject jsonObj) {
        Class<?> javaType = jsonObj.getRawType();
        if (javaType == null) {
            return;
        }
        if (SortedSet.class.isAssignableFrom(javaType)) {
            jsonObj.setType((Type)((Object)LinkedHashSet.class));
        } else if (SortedMap.class.isAssignableFrom(javaType)) {
            jsonObj.setType((Type)((Object)LinkedHashMap.class));
        }
    }

    @Override
    protected void adjustTypeBeforeResolve(JsonObject rootObj, Type rootType) {
        if (rootObj.getTypeString() != null) {
            this.substituteSortedCollectionType(rootObj);
        }
    }

    @Override
    protected void traverseMap(JsonObject jsonObj) {
        Object[] complexKeys;
        if (jsonObj.getTypeString() != null) {
            this.substituteSortedCollectionType(jsonObj);
        }
        if ((complexKeys = jsonObj.getKeys()) != null) {
            Object[] items = jsonObj.getItems();
            if (items != null) {
                this.traverseArrayForRefs(complexKeys);
                this.traverseArrayForRefs(items);
            }
        } else {
            this.traverseFields(jsonObj);
        }
        this.addMapToRehash(jsonObj);
    }

    private void traverseArrayForRefs(Object[] array) {
        ReferenceTracker refTracker = this.getReferences();
        for (int i = 0; i < array.length; ++i) {
            Object element = array[i];
            if (!(element instanceof JsonObject)) continue;
            JsonObject jObj = (JsonObject)element;
            if (jObj.isReference()) {
                long refId = jObj.getReferenceId();
                JsonObject refObject = refTracker.getOrThrow(refId);
                array[i] = refObject;
                continue;
            }
            this.push(jObj);
        }
    }

    @Override
    protected Object reconcileResult(Object result, JsonObject rootObj, Type rootType) {
        if (rootType != null) {
            return result;
        }
        if (result != null && result.getClass().isArray()) {
            return result;
        }
        Converter converter = this.getConverter();
        Type javaType = rootObj.getType();
        if (javaType != null) {
            Class javaClass = TypeUtilities.getRawClass((Type)javaType);
            if (converter.isSimpleTypeConversionSupported(javaClass) || Number.class.isAssignableFrom(javaClass)) {
                Class<?> basicType = this.getJsonSynonymType(javaClass);
                return converter.convert((Object)rootObj, basicType);
            }
            if (!this.isBuiltInPrimitive(result, converter)) {
                return rootObj;
            }
        }
        if (result != null && converter.isSimpleTypeConversionSupported(result.getClass())) {
            return result;
        }
        return rootObj;
    }

    private Class<?> getJsonSynonymType(Class<?> javaType) {
        if (javaType == StringBuilder.class || javaType == StringBuffer.class) {
            return String.class;
        }
        if (javaType == AtomicInteger.class) {
            return Integer.class;
        }
        if (javaType == AtomicLong.class) {
            return Long.class;
        }
        if (javaType == AtomicBoolean.class) {
            return Boolean.class;
        }
        return javaType;
    }

    private boolean isBuiltInPrimitive(Object obj, Converter converter) {
        if (obj == null) {
            return false;
        }
        return converter.isSimpleTypeConversionSupported(obj.getClass());
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Type compType) {
        JsonObject jsonObj;
        Class<?> type;
        if (o instanceof JsonObject && (type = (jsonObj = (JsonObject)o).getRawType()) != null) {
            ReadOptions readOptions = this.getReadOptions();
            Converter converter = this.getConverter();
            if (readOptions.isNonReferenceableClass(type) && converter.isConversionSupportedFor(Map.class, type)) {
                Object converted = converter.convert((Object)jsonObj, type);
                jsonObj.setFinishedTarget(converted, true);
                return converted;
            }
        }
        return null;
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        Object target = jsonObj.getTarget();
        Map<String, Injector> injectorMap = null;
        if (target != null) {
            injectorMap = this.getReadOptions().getDeepInjectorMap(target.getClass());
        }
        ReferenceTracker refTracker = this.getReferences();
        Converter converter = this.getConverter();
        ReadOptions readOptions = this.getReadOptions();
        for (Map.Entry<Object, Object> e : jsonObj.entrySet()) {
            Class<?> fieldType;
            Injector injector;
            String fieldName = (String)e.getKey();
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, (Object)null);
                continue;
            }
            Class<?> rhsClass = rhs.getClass();
            Injector injector2 = injector = injectorMap == null ? null : injectorMap.get(fieldName);
            if (rhsClass.isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.setItems((Object[])rhs);
                this.push(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                Class<?> injectorType;
                boolean isNonRefClass;
                JsonObject jObj = (JsonObject)rhs;
                if (injector != null && (isNonRefClass = readOptions.isNonReferenceableClass(injectorType = injector.getType()))) {
                    jObj.setValue(converter.convert(jObj.getValue(), injectorType));
                    continue;
                }
                if (jObj.isReference()) {
                    long refId = jObj.getReferenceId();
                    JsonObject refObject = refTracker.getOrThrow(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                Class<?> type = jObj.getRawType();
                if (type != null && readOptions.isNonReferenceableClass(type) && converter.isConversionSupportedFor(Map.class, type)) {
                    Object converted = converter.convert((Object)jObj, type);
                    jObj.setFinishedTarget(converted, true);
                    jsonObj.put(fieldName, converted);
                    continue;
                }
                this.push(jObj);
                continue;
            }
            if (injector == null || (fieldType = injector.getType()) == Object.class || rhsClass == fieldType) continue;
            Object fastValue = MapResolver.fastPrimitiveCoercion(rhs, rhsClass, fieldType);
            if (fastValue != null) {
                jsonObj.put(fieldName, fastValue);
                continue;
            }
            if (converter.isConversionSupportedFor(rhsClass, fieldType)) {
                Object fieldValue = converter.convert(rhs, fieldType);
                jsonObj.put(fieldName, fieldValue);
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, (Object)null);
        }
        Object currentTarget = jsonObj.getTarget();
        if (currentTarget != null && !(currentTarget instanceof Map)) {
            jsonObj.setTarget(null);
        }
    }

    private void handleNestedArray(Object element, Class<?> componentType, Object target, int index) {
        JsonObject jsonObject = null;
        if (element instanceof JsonObject && ((JsonObject)element).isArray()) {
            jsonObject = (JsonObject)element;
        } else if (element != null && element.getClass().isArray()) {
            jsonObject = new JsonObject();
            jsonObject.setItems((Object[])element);
        }
        if (jsonObject != null) {
            if (componentType.isArray()) {
                Object arrayElement;
                jsonObject.setType(componentType);
                ((Object[])target)[index] = arrayElement = this.createInstance(jsonObject);
            }
            this.push(jsonObject);
        }
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        boolean isPrimitive;
        Class<?> targetClass;
        Object[] items = jsonObj.getItems();
        if (ArrayUtilities.isEmpty((Object)items)) {
            return;
        }
        Object target = jsonObj.getTarget() != null ? jsonObj.getTarget() : items;
        ReferenceTracker refTracker = this.getReferences();
        Converter converter = this.getConverter();
        ReadOptions readOptions = this.getReadOptions();
        Class componentType = Object.class;
        if (jsonObj.getTarget() != null && (targetClass = jsonObj.getTarget().getClass()).isArray()) {
            componentType = targetClass.getComponentType();
        }
        Object refArray = (isPrimitive = componentType.isPrimitive()) ? null : target;
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            Object element = items[i];
            if (element == null) {
                if (isPrimitive) {
                    ArrayUtilities.setPrimitiveElement((Object)target, (int)i, null);
                    continue;
                }
                refArray[i] = null;
                continue;
            }
            Class<?> elementClass = element.getClass();
            if (elementClass.isArray() || element instanceof JsonObject && ((JsonObject)element).isArray()) {
                this.handleNestedArray(element, componentType, target, i);
                continue;
            }
            Object fastValue = MapResolver.fastPrimitiveCoercion(element, elementClass, componentType);
            if (fastValue != null) {
                if (isPrimitive) {
                    ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)fastValue);
                    continue;
                }
                refArray[i] = fastValue;
                continue;
            }
            if (converter.isConversionSupportedFor(elementClass, componentType)) {
                Object convertedValue = converter.convert(element, componentType);
                if (isPrimitive) {
                    ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)convertedValue);
                    continue;
                }
                refArray[i] = convertedValue;
                continue;
            }
            if (element instanceof JsonObject) {
                boolean isNonRef;
                JsonObject jsonObject = (JsonObject)element;
                if (!jsonObject.isReference()) {
                    boolean isNonRef2;
                    Class<?> type = jsonObject.getRawType();
                    boolean bl = isNonRef2 = type != null && readOptions.isNonReferenceableClass(type);
                    if (isNonRef2 && converter.isConversionSupportedFor(Map.class, type)) {
                        Object converted = converter.convert((Object)jsonObject, type);
                        if (isPrimitive) {
                            ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)converted);
                        } else {
                            refArray[i] = converted;
                        }
                        jsonObject.setFinished();
                        continue;
                    }
                    this.push(jsonObject);
                    continue;
                }
                long refId = jsonObject.getReferenceId();
                JsonObject refObject = refTracker.getOrThrow(refId);
                Class<?> type = refObject.getRawType();
                boolean bl = isNonRef = type != null && readOptions.isNonReferenceableClass(type);
                if (isNonRef && converter.isConversionSupportedFor(Map.class, type)) {
                    Object convertedRef = converter.convert((Object)refObject, type);
                    refObject.setFinishedTarget(convertedRef, true);
                    if (isPrimitive) {
                        ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)refObject.getTarget());
                        continue;
                    }
                    refArray[i] = refObject.getTarget();
                    continue;
                }
                if (isPrimitive) {
                    ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)refObject);
                    continue;
                }
                refArray[i] = refObject;
                continue;
            }
            if (isPrimitive) {
                ArrayUtilities.setPrimitiveElement((Object)target, (int)i, (Object)element);
                continue;
            }
            refArray[i] = element;
        }
        jsonObj.setFinished();
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        this.substituteSortedCollectionType(jsonObj);
        Object[] items = jsonObj.getItems();
        Collection col = (Collection)jsonObj.getTarget();
        if (col == null) {
            col = (Collection)this.createInstance(jsonObj);
        }
        if (items != null && col instanceof ArrayList) {
            ((ArrayList)col).ensureCapacity(items.length);
        }
        boolean isList = col instanceof List;
        int idx = 0;
        if (items != null) {
            ReadOptions readOptions = this.getReadOptions();
            ReferenceTracker refTracker = this.getReferences();
            for (Object element : items) {
                JsonObject jObj;
                if (element == null) {
                    col.add(null);
                    ++idx;
                    continue;
                }
                if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    col.add(element);
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject();
                    jObj.setType((Type)((Object)Object[].class));
                    jObj.setItems((Object[])element);
                    this.createInstance(jObj);
                    col.add(jObj.getTarget());
                    this.push(jObj);
                } else {
                    jObj = (JsonObject)element;
                    if (jObj.isReference()) {
                        long ref = jObj.getReferenceId();
                        JsonObject refObject = refTracker.getOrThrow(ref);
                        if (refObject.getTarget() != null) {
                            col.add(refObject.getTarget());
                        } else {
                            this.addUnresolvedReference(new Resolver.UnresolvedReference(jsonObj, idx, ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        if (col instanceof EnumSet) {
                            boolean noEnumName;
                            Class<?> rawType = jObj.getRawType();
                            boolean bl = noEnumName = !jObj.containsKey("name") && !jObj.containsKey("Enum.name") && !jObj.hasValue();
                            if (rawType != null && rawType.isEnum() && noEnumName) {
                                jObj.setFinished();
                                ++idx;
                                continue;
                            }
                        }
                        jObj.setType((Type)((Object)Object.class));
                        this.createInstance(jObj);
                        boolean isNonRefClass = readOptions.isNonReferenceableClass(jObj.getRawType());
                        if (!isNonRefClass) {
                            this.traverseSpecificType(jObj);
                        }
                        if (!(col instanceof EnumSet)) {
                            col.add(jObj.getTarget());
                        }
                    }
                }
                ++idx;
            }
        }
        jsonObj.setFinished();
    }

    @Override
    protected Object resolveArray(Type suggestedType, List<Object> list) {
        Class rawType;
        Class clazz = rawType = suggestedType == null ? null : TypeUtilities.getRawClass((Type)suggestedType);
        if (suggestedType == null || rawType == Object.class) {
            return list.toArray();
        }
        JsonObject jsonArray = new JsonObject();
        jsonArray.setType(suggestedType);
        this.substituteSortedCollectionType(jsonArray);
        if (Collection.class.isAssignableFrom(rawType)) {
            jsonArray.setTarget(this.createInstance(jsonArray));
        } else {
            jsonArray.setTarget(Array.newInstance(rawType, list.size()));
        }
        jsonArray.setItems(list.toArray());
        return jsonArray;
    }

    private static Object fastPrimitiveCoercion(Object value, Class<?> valueClass, Class<?> targetType) {
        if (valueClass == Long.class) {
            long longVal = (Long)value;
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return (int)longVal;
            }
            if (targetType == Short.TYPE || targetType == Short.class) {
                return (short)longVal;
            }
            if (targetType == Byte.TYPE || targetType == Byte.class) {
                return (byte)longVal;
            }
            if (targetType == Double.TYPE || targetType == Double.class) {
                return (double)longVal;
            }
            if (targetType == Float.TYPE || targetType == Float.class) {
                return Float.valueOf(longVal);
            }
        } else if (valueClass == Double.class) {
            double doubleVal = (Double)value;
            if (targetType == Float.TYPE || targetType == Float.class) {
                return Float.valueOf((float)doubleVal);
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return (long)doubleVal;
            }
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return (int)doubleVal;
            }
        }
        return null;
    }
}

