/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.MathUtilities;
import com.cedarsoftware.util.TypeUtilities;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class JsonParser {
    private static final JsonObject EMPTY_ARRAY;
    private final FastReader input;
    private final StringBuilder strBuf;
    private final StringBuilder numBuf = new StringBuilder();
    private int curParseDepth = 0;
    private final boolean allowNanAndInfinity;
    private final int maxParseDepth;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final ReferenceTracker references;
    private final Map<String, String> stringCache;
    private final Map<Number, Number> numberCache;
    private final long maxIdValue;
    private final boolean strictJson;
    private final boolean integerTypeBigInteger;
    private final boolean integerTypeBoth;
    private final boolean floatingPointBigDecimal;
    private final boolean floatingPointBoth;
    private final Map<String, String> substitutes = SUBSTITUTES;
    private static final Map<String, String> STATIC_STRING_CACHE;
    private static final Map<Number, Number> STATIC_NUMBER_CACHE;
    private static final Map<String, String> SUBSTITUTES;
    private static final char[] ESCAPE_CHAR_MAP;
    private static final int[] HEX_VALUE_MAP;

    JsonParser(FastReader reader, Resolver resolver) {
        this.stringCache = new ParserStringCache(STATIC_STRING_CACHE);
        this.numberCache = new ParserNumberCache(STATIC_NUMBER_CACHE);
        this.input = reader;
        this.resolver = resolver;
        this.readOptions = resolver.getReadOptions();
        this.references = resolver.getReferences();
        this.maxParseDepth = this.readOptions.getMaxDepth();
        this.allowNanAndInfinity = this.readOptions.isAllowNanAndInfinity();
        this.strBuf = new StringBuilder(this.readOptions.getStringBufferSize());
        this.maxIdValue = this.readOptions.getMaxIdValue();
        this.strictJson = this.readOptions.isStrictJson();
        this.integerTypeBigInteger = this.readOptions.isIntegerTypeBigInteger();
        this.integerTypeBoth = this.readOptions.isIntegerTypeBoth();
        this.floatingPointBigDecimal = this.readOptions.isFloatingPointBigDecimal();
        this.floatingPointBoth = this.readOptions.isFloatingPointBoth();
    }

    Object readValue(Type suggestedType) throws IOException {
        int c;
        if (this.curParseDepth > this.maxParseDepth) {
            this.error("Maximum parsing depth exceeded");
        }
        if ((c = this.skipWhitespaceRead(true)) == 123) {
            JsonObject jObj = this.readJsonObject(suggestedType);
            return jObj;
        }
        if (c == 91) {
            Type elementType = TypeUtilities.extractArrayComponentType((Type)suggestedType);
            return this.readArray(elementType);
        }
        switch (c) {
            case 34: {
                return this.readString('\"');
            }
            case 39: {
                if (this.strictJson) {
                    this.error("Single-quoted strings not allowed in strict JSON mode");
                }
                return this.readString('\'');
            }
            case 93: {
                this.input.pushback(']');
                return EMPTY_ARRAY;
            }
            case 70: 
            case 102: {
                this.readToken("false");
                return false;
            }
            case 110: {
                this.readToken("null");
                return null;
            }
            case 78: {
                return this.readNumber(c);
            }
            case 84: 
            case 116: {
                this.readToken("true");
                return true;
            }
            case 45: 
            case 73: {
                return this.readNumber(c);
            }
            case 46: {
                if (this.strictJson) {
                    this.error("Leading decimal point not allowed in strict JSON mode");
                }
                return this.readNumber(c);
            }
            case 43: {
                if (this.strictJson) {
                    this.error("Explicit positive sign not allowed in strict JSON mode");
                }
                return this.readNumber(c);
            }
        }
        if (c >= 48 && c <= 57) {
            return this.readNumber(c);
        }
        return this.error("Unknown JSON value type");
    }

    private JsonObject readJsonObject(Type suggestedType) throws IOException {
        JsonObject jObj = new JsonObject();
        Type resolvedSuggestedType = TypeUtilities.resolveType((Type)suggestedType, (Type)suggestedType);
        jObj.setType(resolvedSuggestedType);
        FastReader in = this.input;
        int c = this.skipWhitespaceRead(true);
        if (c == 125) {
            return new JsonObject();
        }
        in.pushback((char)c);
        ++this.curParseDepth;
        Class rawClass = TypeUtilities.getRawClass((Type)suggestedType);
        Map<Object, Object> injectors = suggestedType == null || rawClass == Object.class || rawClass == null ? Collections.emptyMap() : this.readOptions.getDeepInjectorMap(rawClass);
        while (true) {
            Type fieldGenericType;
            String field = this.readFieldName();
            Injector injector = (Injector)injectors.get(field = this.substitutes.getOrDefault(field, field));
            Type type = fieldGenericType = injector == null ? null : injector.getGenericType();
            if (fieldGenericType != null) {
                fieldGenericType = TypeUtilities.resolveType((Type)suggestedType, (Type)fieldGenericType);
            }
            Object value = this.readValue(fieldGenericType);
            if (field.length() == 0 || field.charAt(0) != '@') {
                jObj.put(field, value);
            } else {
                switch (field) {
                    case "@type": {
                        Class<?> type2 = this.loadType(value);
                        jObj.setTypeString((String)value);
                        jObj.setType(type2);
                        break;
                    }
                    case "@enum": {
                        this.loadEnum(value, jObj);
                        break;
                    }
                    case "@ref": {
                        this.loadRef(value, jObj);
                        break;
                    }
                    case "@id": {
                        this.loadId(value, jObj);
                        break;
                    }
                    case "@items": {
                        if (value != null && !value.getClass().isArray()) {
                            this.error("Expected @items to have an array [], but found: " + value.getClass().getName());
                        }
                        this.loadItems((Object[])value, jObj);
                        break;
                    }
                    case "@keys": {
                        this.loadKeys(value, jObj);
                        break;
                    }
                    default: {
                        jObj.put(field, value);
                    }
                }
            }
            c = this.skipWhitespaceRead(true);
            if (c == 125) break;
            if (c != 44) {
                this.error("Object not ended with '}', instead found '" + (char)c + "'");
            }
            if ((c = this.skipWhitespaceRead(true)) == 125) {
                if (!this.strictJson) break;
                this.error("Trailing commas not allowed in strict JSON mode");
                break;
            }
            this.input.pushback((char)c);
        }
        --this.curParseDepth;
        return jObj;
    }

    private Object readArray(Type suggestedType) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(64);
        ++this.curParseDepth;
        while (true) {
            int c;
            Object value;
            if ((value = this.readValue(suggestedType)) != EMPTY_ARRAY) {
                list.add(value);
            }
            if ((c = this.skipWhitespaceRead(true)) == 93) break;
            if (c != 44) {
                this.error("Expected ',' or ']' inside array");
            }
            if ((c = this.skipWhitespaceRead(true)) == 93) {
                if (!this.strictJson) break;
                this.error("Trailing commas not allowed in strict JSON mode");
                break;
            }
            this.input.pushback((char)c);
        }
        --this.curParseDepth;
        return this.resolver.resolveArray(suggestedType, list);
    }

    private String readFieldName() throws IOException {
        String field;
        int c = this.skipWhitespaceRead(true);
        if (c == 34) {
            field = this.readString('\"');
        } else if (c == 39) {
            if (this.strictJson) {
                this.error("Single-quoted strings not allowed in strict JSON mode");
            }
            field = this.readString('\'');
        } else if (this.isIdentifierStart(c)) {
            if (this.strictJson) {
                this.error("Unquoted field names not allowed in strict JSON mode");
            }
            field = this.readUnquotedIdentifier(c);
        } else {
            this.error("Expected quote before field name");
            return null;
        }
        c = this.skipWhitespaceRead(true);
        if (c != 58) {
            this.error("Expected ':' between field and value, instead found '" + (char)c + "'");
        }
        return field;
    }

    private boolean isIdentifierStart(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c == 36;
    }

    private boolean isIdentifierPart(int c) {
        return this.isIdentifierStart(c) || c >= 48 && c <= 57;
    }

    private String readUnquotedIdentifier(int firstChar) throws IOException {
        this.strBuf.setLength(0);
        this.strBuf.append((char)firstChar);
        while (true) {
            int c;
            if ((c = this.input.read()) == -1 || !this.isIdentifierPart(c)) {
                if (c == -1) break;
                this.input.pushback((char)c);
                break;
            }
            this.strBuf.append((char)c);
        }
        return this.strBuf.toString();
    }

    private void readToken(String token) {
        int len = token.length();
        if (len <= 5) {
            for (int i = 1; i < len; ++i) {
                int c = this.input.read();
                if (c == -1) {
                    this.error("EOF reached while reading token: " + token);
                }
                if (c >= 65 && c <= 90) {
                    c += 32;
                }
                if (token.charAt(i) == c) continue;
                this.error("Expected token: " + token);
            }
        } else {
            for (int i = 1; i < len; ++i) {
                int c = this.input.read();
                if (c == -1) {
                    this.error("EOF reached while reading token: " + token);
                }
                c = Character.toLowerCase((char)c);
                char loTokenChar = token.charAt(i);
                if (loTokenChar == c) continue;
                this.error("Expected token: " + token);
            }
        }
    }

    private Number readNumber(int c) throws IOException {
        if (this.allowNanAndInfinity && (c == 45 || c == 78 || c == 73)) {
            boolean isNeg;
            boolean bl = isNeg = c == 45;
            if (isNeg) {
                c = this.input.read();
            }
            if (c == 73) {
                this.readToken("infinity");
                return isNeg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (c == 78) {
                this.readToken("nan");
                return Double.NaN;
            }
            this.input.pushback((char)c);
            c = 45;
        }
        return this.readNumberGeneral(c);
    }

    private Number readNumberGeneral(int firstChar) throws IOException {
        int c;
        FastReader in = this.input;
        boolean isFloat = false;
        boolean isNegative = firstChar == 45;
        boolean isPositive = firstChar == 43;
        int startChar = firstChar;
        if (isNegative || isPositive) {
            startChar = in.read();
        }
        if (startChar == 48) {
            int next = in.read();
            if (next == 120 || next == 88) {
                if (this.strictJson) {
                    this.error("Hexadecimal numbers not allowed in strict JSON mode");
                }
                return this.readHexNumber(isNegative);
            }
            if (next != -1) {
                in.pushback((char)next);
            }
        }
        if ((isNegative || isPositive) && startChar != firstChar) {
            in.pushback((char)startChar);
        }
        StringBuilder number = this.numBuf;
        number.setLength(0);
        if (isPositive) {
            c = in.read();
            if (c == -1) {
                return (Number)this.error("Unexpected end of input after '+'");
            }
            number.append((char)c);
            if (c == 46) {
                isFloat = true;
            }
        } else {
            number.append((char)firstChar);
        }
        if (firstChar == 46) {
            isFloat = true;
        }
        while (true) {
            if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                number.append((char)c);
                continue;
            }
            if (c != 46 && c != 101 && c != 69) break;
            number.append((char)c);
            isFloat = true;
        }
        if (c != -1) {
            in.pushback((char)c);
        }
        try {
            Number val = isFloat ? (Number)this.readFloatingPoint(number.toString()) : (Number)this.readInteger(number);
            Number cachedInstance = this.numberCache.get(val);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            this.numberCache.put(val, val);
            return val;
        }
        catch (Exception e) {
            return (Number)this.error("Invalid number: " + number, e);
        }
    }

    private Number readInteger(StringBuilder number) {
        int digitCount;
        int len = number.length();
        if (this.integerTypeBigInteger) {
            return new BigInteger(number.toString());
        }
        boolean isNeg = number.charAt(0) == '-';
        int n = digitCount = isNeg ? len - 1 : len;
        if (digitCount <= 18) {
            int start;
            long n2 = 0L;
            for (int i = start = isNeg ? 1 : 0; i < len; ++i) {
                n2 = n2 * 10L + (long)(number.charAt(i) - 48);
            }
            return isNeg ? -n2 : n2;
        }
        String numStr = number.toString();
        try {
            return Long.parseLong(numStr);
        }
        catch (Exception e) {
            BigInteger bigInt = new BigInteger(numStr);
            if (this.integerTypeBoth) {
                return bigInt;
            }
            return bigInt.longValue();
        }
    }

    private Number readFloatingPoint(String numStr) {
        if (this.floatingPointBigDecimal) {
            return new BigDecimal(numStr);
        }
        Number number = MathUtilities.parseToMinimalNumericType((String)numStr);
        if (this.floatingPointBoth) {
            return number;
        }
        return number.doubleValue();
    }

    private Number readHexNumber(boolean isNegative) throws IOException {
        FastReader in = this.input;
        long value = 0L;
        int digitCount = 0;
        while (true) {
            int digit;
            int c;
            if ((c = in.read()) >= 48 && c <= 57) {
                digit = c - 48;
            } else if (c >= 97 && c <= 102) {
                digit = c - 97 + 10;
            } else if (c >= 65 && c <= 70) {
                digit = c - 65 + 10;
            } else {
                if (c == -1) break;
                in.pushback((char)c);
                break;
            }
            if (++digitCount > 16) {
                this.error("Hexadecimal number too large");
            }
            value = value << 4 | (long)digit;
        }
        if (digitCount == 0) {
            this.error("Expected hexadecimal digit after 0x");
        }
        return isNegative ? -value : value;
    }

    private String readString(char quoteChar) throws IOException {
        StringBuilder str = this.strBuf;
        str.setLength(0);
        FastReader in = this.input;
        char[] ESCAPE_CHARS = ESCAPE_CHAR_MAP;
        int[] HEX_VALUES = HEX_VALUE_MAP;
        while (true) {
            char escaped;
            int c;
            if ((c = in.read()) == -1) {
                this.error("EOF reached while reading JSON string");
            }
            if (c != 92 && c != quoteChar) {
                str.append((char)c);
                continue;
            }
            if (c == quoteChar) {
                if (this.curParseDepth != 0 || (c = this.skipWhitespaceRead(false)) == -1) break;
                throw new JsonIoException("EOF expected, content found after string");
            }
            c = in.read();
            if (c == -1) {
                this.error("EOF reached while reading escape sequence");
            }
            if (c < ESCAPE_CHARS.length && (escaped = ESCAPE_CHARS[c]) != '\u0000') {
                str.append(escaped);
                continue;
            }
            if (c == 117) {
                int value = 0;
                for (int i = 0; i < 4; ++i) {
                    int digit;
                    c = in.read();
                    if (c == -1) {
                        this.error("EOF reached while reading Unicode escape sequence");
                    }
                    int n = digit = c < 128 ? HEX_VALUES[c] : -1;
                    if (digit < 0) {
                        this.error("Expected hexadecimal digit, got: " + (char)c);
                    }
                    value = value << 4 | digit;
                }
                if (value < 55296 || value > 57343) {
                    str.append((char)value);
                    continue;
                }
                if (value <= 56319) {
                    int next = in.read();
                    if (next == 92) {
                        next = in.read();
                        if (next == 117) {
                            int lowSurrogate = 0;
                            for (int i = 0; i < 4; ++i) {
                                int digit;
                                c = in.read();
                                if (c == -1) {
                                    this.error("EOF reached while reading Unicode escape sequence");
                                }
                                int n = digit = c < 128 ? HEX_VALUES[c] : -1;
                                if (digit < 0) {
                                    this.error("Expected hexadecimal digit, got: " + (char)c);
                                }
                                lowSurrogate = lowSurrogate << 4 | digit;
                            }
                            if (lowSurrogate >= 56320 && lowSurrogate <= 57343) {
                                int codePoint = 65536 + (value - 55296 << 10) + (lowSurrogate - 56320);
                                str.appendCodePoint(codePoint);
                                continue;
                            }
                            str.append((char)value);
                            str.append((char)lowSurrogate);
                            continue;
                        }
                        in.pushback((char)next);
                        in.pushback('\\');
                    } else if (next != -1) {
                        in.pushback((char)next);
                    }
                }
                str.append((char)value);
                continue;
            }
            if (c == 10) {
                if (!this.strictJson) continue;
                this.error("Multi-line strings not allowed in strict JSON mode");
                continue;
            }
            if (c == 13) {
                int next;
                if (this.strictJson) {
                    this.error("Multi-line strings not allowed in strict JSON mode");
                }
                if ((next = in.read()) == 10 || next == -1) continue;
                in.pushback((char)next);
                continue;
            }
            this.error("Invalid character escape sequence specified: " + (char)c);
        }
        return this.cacheString(str);
    }

    private String cacheString(StringBuilder str) {
        int length = str.length();
        if (length == 0) {
            return "";
        }
        String s = str.toString();
        if (length < 33) {
            String cachedInstance = this.stringCache.get(s);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            this.stringCache.put(s, s);
        }
        return s;
    }

    private int skipWhitespaceRead(boolean throwOnEof) throws IOException {
        int c;
        block7: {
            int next;
            FastReader in = this.input;
            while (true) {
                if ((c = in.read()) == 32 || c == 9 || c == 10 || c == 13) {
                    continue;
                }
                if (c != 47) break block7;
                next = in.read();
                if (next == 47) {
                    if (this.strictJson) {
                        this.error("Comments not allowed in strict JSON mode");
                    }
                    this.skipSingleLineComment();
                    continue;
                }
                if (next != 42) break;
                if (this.strictJson) {
                    this.error("Comments not allowed in strict JSON mode");
                }
                this.skipBlockComment();
            }
            if (next != -1) {
                this.input.pushback((char)next);
            }
            return c;
        }
        if (c == -1 && throwOnEof) {
            this.error("EOF reached prematurely");
        }
        return c;
    }

    private void skipSingleLineComment() throws IOException {
        int c;
        while ((c = this.input.read()) != -1) {
            int next;
            if (c != 10 && c != 13) continue;
            if (c == 13 && (next = this.input.read()) != 10 && next != -1) {
                this.input.pushback((char)next);
            }
            return;
        }
    }

    private void skipBlockComment() throws IOException {
        int c;
        while ((c = this.input.read()) != -1) {
            if (c != 42) continue;
            int next = this.input.read();
            if (next == 47) {
                return;
            }
            if (next == -1) continue;
            this.input.pushback((char)next);
        }
        this.error("Unterminated block comment");
    }

    private void loadId(Object value, JsonObject jObj) {
        long id;
        if (value == null) {
            this.error("Null value provided for @id field - expected a number");
        }
        if (jObj == null) {
            this.error("Null JsonObject provided to loadId method");
        }
        if (!(value instanceof Number)) {
            this.error("Expected a number for @id, instead got: " + value.getClass().getSimpleName());
        }
        if ((id = ((Number)value).longValue()) < -this.maxIdValue || id > this.maxIdValue) {
            this.error("ID value out of safe range: " + id + " - IDs must be between -" + this.maxIdValue + " and +" + this.maxIdValue);
        }
        this.references.put(id, jObj);
        jObj.setId(id);
    }

    private void loadRef(Object value, JsonValue jObj) {
        long refId;
        if (value == null) {
            this.error("Null value provided for @ref field - expected a number");
        }
        if (jObj == null) {
            this.error("Null JsonValue provided to loadRef method");
        }
        if (!(value instanceof Number)) {
            this.error("Expected a number for @ref, instead got: " + value.getClass().getSimpleName());
        }
        if ((refId = ((Number)value).longValue()) < -this.maxIdValue || refId > this.maxIdValue) {
            this.error("Reference ID value out of safe range: " + refId + " - reference IDs must be between -" + this.maxIdValue + " and +" + this.maxIdValue);
        }
        jObj.setReferenceId(refId);
    }

    private void loadEnum(Object value, JsonObject jObj) {
        if (!(value instanceof String)) {
            this.error("Expected a String for @enum, instead got: " + value);
        }
        Class<?> enumClass = this.stringToClass((String)value);
        jObj.setTypeString((String)value);
        jObj.setType(enumClass);
        if (jObj.getItems() == null) {
            jObj.setItems(ArrayUtilities.EMPTY_OBJECT_ARRAY);
        }
    }

    private Class<?> loadType(Object value) {
        String javaType;
        String substitute;
        if (!(value instanceof String)) {
            this.error("Expected a String for @type, instead got: " + value);
        }
        if ((substitute = this.readOptions.getTypeNameAlias(javaType = (String)value)) != null) {
            javaType = substitute;
        }
        return this.stringToClass(javaType);
    }

    private void loadItems(Object[] value, JsonObject jObj) {
        if (value == null) {
            return;
        }
        jObj.setItems(value);
    }

    private void loadKeys(Object value, JsonObject jObj) {
        if (value == null) {
            return;
        }
        if (!value.getClass().isArray()) {
            this.error("Expected @keys to have an array [], but found: " + value.getClass().getName());
        }
        jObj.setKeys((Object[])value);
    }

    private Class<?> stringToClass(String className) {
        String resolvedName = this.readOptions.getTypeNameAlias(className);
        Class<Object> clazz = ClassUtilities.forName((String)resolvedName, (ClassLoader)this.readOptions.getClassLoader());
        if (clazz == null) {
            if (this.readOptions.isFailOnUnknownType()) {
                this.error("Unknown type (class) '" + className + "' not defined.");
            }
            if ((clazz = this.readOptions.getUnknownTypeClass()) == null) {
                clazz = LinkedHashMap.class;
            }
        }
        return clazz;
    }

    private Object error(String msg) {
        throw new JsonIoException(this.getMessage(msg));
    }

    private Object error(String msg, Exception e) {
        throw new JsonIoException(this.getMessage(msg), e);
    }

    private String getMessage(String msg) {
        return msg + "\n" + this.input.getLastSnippet();
    }

    static {
        String[] commonStrings;
        int i;
        EMPTY_ARRAY = new JsonObject();
        STATIC_STRING_CACHE = new ConcurrentHashMap<String, String>(64);
        STATIC_NUMBER_CACHE = new ConcurrentHashMap<Number, Number>(16);
        SUBSTITUTES = new HashMap<String, String>(16);
        ESCAPE_CHAR_MAP = new char[128];
        HEX_VALUE_MAP = new int[128];
        JsonParser.ESCAPE_CHAR_MAP[92] = 92;
        JsonParser.ESCAPE_CHAR_MAP[47] = 47;
        JsonParser.ESCAPE_CHAR_MAP[34] = 34;
        JsonParser.ESCAPE_CHAR_MAP[39] = 39;
        JsonParser.ESCAPE_CHAR_MAP[98] = 8;
        JsonParser.ESCAPE_CHAR_MAP[102] = 12;
        JsonParser.ESCAPE_CHAR_MAP[110] = 10;
        JsonParser.ESCAPE_CHAR_MAP[114] = 13;
        JsonParser.ESCAPE_CHAR_MAP[116] = 9;
        Arrays.fill(HEX_VALUE_MAP, -1);
        for (i = 48; i <= 57; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = 10 + (i - 97);
        }
        for (i = 65; i <= 70; ++i) {
            JsonParser.HEX_VALUE_MAP[i] = 10 + (i - 65);
        }
        SUBSTITUTES.put("@i", "@id");
        SUBSTITUTES.put("@r", "@ref");
        SUBSTITUTES.put("@e", "@items");
        SUBSTITUTES.put("@t", "@type");
        SUBSTITUTES.put("@k", "@keys");
        SUBSTITUTES.put("$id", "@id");
        SUBSTITUTES.put("$ref", "@ref");
        SUBSTITUTES.put("$items", "@items");
        SUBSTITUTES.put("$type", "@type");
        SUBSTITUTES.put("$keys", "@keys");
        SUBSTITUTES.put("$i", "@id");
        SUBSTITUTES.put("$r", "@ref");
        SUBSTITUTES.put("$e", "@items");
        SUBSTITUTES.put("$t", "@type");
        SUBSTITUTES.put("$k", "@keys");
        for (String s : commonStrings = new String[]{"", "true", "True", "TRUE", "false", "False", "FALSE", "null", "yes", "Yes", "YES", "no", "No", "NO", "on", "On", "ON", "off", "Off", "OFF", "id", "ID", "type", "value", "name", "@id", "@ref", "@items", "@type", "@keys", "-1", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}) {
            STATIC_STRING_CACHE.put(s, s);
        }
        STATIC_NUMBER_CACHE.put(-1L, -1L);
        STATIC_NUMBER_CACHE.put(0L, 0L);
        STATIC_NUMBER_CACHE.put(1L, 1L);
        STATIC_NUMBER_CACHE.put(-1.0, -1.0);
        STATIC_NUMBER_CACHE.put(0.0, 0.0);
        STATIC_NUMBER_CACHE.put(1.0, 1.0);
        STATIC_NUMBER_CACHE.put(Double.MIN_VALUE, Double.MIN_VALUE);
        STATIC_NUMBER_CACHE.put(Double.MAX_VALUE, Double.MAX_VALUE);
        STATIC_NUMBER_CACHE.put(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        STATIC_NUMBER_CACHE.put(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        STATIC_NUMBER_CACHE.put(Double.NaN, Double.NaN);
    }

    private static class ParserStringCache
    extends AbstractMap<String, String> {
        private final Map<String, String> staticCache;
        private final Map<String, String> instanceCache;

        public ParserStringCache(Map<String, String> staticCache) {
            this.staticCache = staticCache;
            this.instanceCache = new HashMap<String, String>(64);
        }

        @Override
        public String get(Object key) {
            String result = this.staticCache.get(key);
            if (result != null) {
                return result;
            }
            return this.instanceCache.get(key);
        }

        @Override
        public String put(String key, String value) {
            return this.instanceCache.put(key, value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
            entries.addAll(this.staticCache.entrySet());
            entries.addAll(this.instanceCache.entrySet());
            return entries;
        }
    }

    private static class ParserNumberCache
    extends AbstractMap<Number, Number> {
        private final Map<Number, Number> staticCache;
        private final Map<Number, Number> instanceCache;

        public ParserNumberCache(Map<Number, Number> staticCache) {
            this.staticCache = staticCache;
            this.instanceCache = new HashMap<Number, Number>(64);
        }

        @Override
        public Number get(Object key) {
            Number result = this.staticCache.get(key);
            if (result != null) {
                return result;
            }
            return this.instanceCache.get(key);
        }

        @Override
        public Number put(Number key, Number value) {
            return this.instanceCache.put(key, value);
        }

        @Override
        public Set<Map.Entry<Number, Number>> entrySet() {
            HashSet<Map.Entry<Number, Number>> entries = new HashSet<Map.Entry<Number, Number>>();
            entries.addAll(this.staticCache.entrySet());
            entries.addAll(this.instanceCache.entrySet());
            return entries;
        }
    }
}

