/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonValue;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Map<Object, Object>,
Serializable {
    private static final int INITIAL_CAPACITY = 16;
    private static volatile int INDEX_THRESHOLD = 16;
    private Object[] keys = new Object[16];
    private Object[] values = new Object[16];
    private int size = 0;
    private Object[] items;
    private transient Map<Object, Integer> index;
    private boolean itemsWereSet;
    private boolean keysWereSet;
    private Integer hash;
    private String typeString;
    private byte jsonTypeCache;

    public JsonType getJsonType() {
        if (this.jsonTypeCache == 0) {
            this.jsonTypeCache = this.isArray() ? (byte)1 : (this.isCollection() ? (byte)2 : (this.isMap() ? (byte)3 : (byte)4));
        }
        switch (this.jsonTypeCache) {
            case 1: {
                return JsonType.ARRAY;
            }
            case 2: {
                return JsonType.COLLECTION;
            }
            case 3: {
                return JsonType.MAP;
            }
        }
        return JsonType.OBJECT;
    }

    public String toString() {
        String jType = this.typeString != null ? this.typeString : (this.type == null ? "not set" : this.type.getTypeName());
        String targetInfo = this.target == null ? "null" : jType;
        return "JsonObject(id:" + this.id + ", type:" + jType + ", target:" + targetInfo + ", size:" + this.size() + ")";
    }

    public boolean isMap() {
        return this.target instanceof Map || this.type != null && Map.class.isAssignableFrom(this.getRawType());
    }

    public boolean isCollection() {
        if (this.target instanceof Collection) {
            return true;
        }
        if (this.isMap()) {
            return false;
        }
        if (this.itemsWereSet && !this.keysWereSet) {
            Class<?> rawType = this.getRawType();
            return rawType != null && !rawType.isArray();
        }
        return false;
    }

    @Override
    public boolean isArray() {
        if (this.target != null) {
            return this.target.getClass().isArray();
        }
        if (this.type != null) {
            return this.getRawType().isArray();
        }
        return this.itemsWereSet && !this.keysWereSet;
    }

    public Object[] getItems() {
        return this.items;
    }

    public void setItems(Object[] array) {
        if (array == null) {
            throw new JsonIoException("Argument array cannot be null");
        }
        this.items = array;
        this.itemsWereSet = true;
        this.hash = null;
        this.jsonTypeCache = 0;
    }

    public Object[] getKeys() {
        return this.keysWereSet ? this.keys : null;
    }

    void setKeys(Object[] keyArray) {
        if (keyArray == null) {
            throw new JsonIoException("Argument keys cannot be null");
        }
        this.keys = keyArray;
        this.keysWereSet = true;
        this.hash = null;
        this.jsonTypeCache = 0;
        this.index = null;
    }

    public String getTypeString() {
        return this.typeString;
    }

    void setTypeString(String typeString) {
        this.typeString = typeString;
    }

    @Override
    public int size() {
        if (this.keysWereSet) {
            return this.itemsWereSet ? Math.min(this.keys.length, this.items.length) : 0;
        }
        return this.size;
    }

    @Deprecated
    public int getLength() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object get(Object key) {
        int idx = this.indexOf(key);
        if (idx < 0) {
            return null;
        }
        return this.keysWereSet && this.itemsWereSet ? this.items[idx] : this.values[idx];
    }

    @Override
    public Object put(Object key, Object value) {
        this.hash = null;
        int idx = this.indexOf(key);
        if (idx >= 0) {
            Object old = this.values[idx];
            this.values[idx] = value;
            return old;
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size] = key;
        this.values[this.size] = value;
        if (this.index != null) {
            this.index.put(key, this.size);
        }
        ++this.size;
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Object[] vals = this.keysWereSet && this.itemsWereSet ? this.items : this.values;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (!Objects.equals(value, vals[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object remove(Object key) {
        if (this.keysWereSet) {
            return null;
        }
        int idx = this.indexOf(key);
        if (idx < 0) {
            return null;
        }
        Object old = this.values[idx];
        int numMoved = this.size - idx - 1;
        if (numMoved > 0) {
            System.arraycopy(this.keys, idx + 1, this.keys, idx, numMoved);
            System.arraycopy(this.values, idx + 1, this.values, idx, numMoved);
        }
        --this.size;
        this.keys[this.size] = null;
        this.values[this.size] = null;
        this.hash = null;
        this.index = null;
        return old;
    }

    @Override
    public void putAll(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        this.hash = null;
        this.ensureCapacity(this.size + map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
        this.items = null;
        this.hash = null;
        this.index = null;
        this.itemsWereSet = false;
        this.keysWereSet = false;
        this.jsonTypeCache = 0;
    }

    public void setValue(Object o) {
        this.put("value", o);
    }

    public Object getValue() {
        return this.get("value");
    }

    public boolean hasValue() {
        return this.size == 1 && this.containsKey("value");
    }

    private int indexOf(Object key) {
        Integer idx;
        if (this.keysWereSet) {
            if (!this.itemsWereSet) {
                return -1;
            }
            int len = this.keys.length;
            for (int i = 0; i < len; ++i) {
                if (!Objects.equals(key, this.keys[i])) continue;
                return i;
            }
            return -1;
        }
        if (this.size == 0) {
            return -1;
        }
        if (this.size <= INDEX_THRESHOLD) {
            for (int i = 0; i < this.size; ++i) {
                if (!Objects.equals(key, this.keys[i])) continue;
                return i;
            }
            return -1;
        }
        if (this.index == null) {
            this.buildIndex();
        }
        return (idx = this.index.get(key)) != null ? idx : -1;
    }

    private void buildIndex() {
        this.index = new HashMap<Object, Integer>(this.size + (this.size >> 1));
        for (int i = 0; i < this.size; ++i) {
            this.index.put(this.keys[i], i);
        }
    }

    private void ensureCapacity(int minCapacity) {
        if (this.keys.length >= minCapacity) {
            return;
        }
        int newCapacity = Math.max(this.keys.length * 2, minCapacity);
        this.keys = Arrays.copyOf(this.keys, newCapacity);
        this.values = Arrays.copyOf(this.values, newCapacity);
    }

    @Override
    public Set<Object> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<Object> values() {
        return new ValuesCollection();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return new EntrySet();
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            int result = 1;
            Object[] vals = this.keysWereSet && this.itemsWereSet ? this.items : this.values;
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                result = 31 * result + (this.keys[i] == null ? 0 : this.keys[i].hashCode());
                result = 31 * result + this.hashCodeSafe(vals[i]);
            }
            if (this.items != null && !this.keysWereSet) {
                result = 31 * result + Arrays.hashCode(this.items);
            }
            this.hash = result;
        }
        return this.hash;
    }

    private int hashCodeSafe(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!obj.getClass().isArray()) {
            return obj.hashCode();
        }
        return this.arrayHashCode(obj, new IdentityHashMap<Object, Integer>());
    }

    private int arrayHashCode(Object array, Map<Object, Integer> seen) {
        if (array == null) {
            return 0;
        }
        if (!array.getClass().isArray()) {
            return array.hashCode();
        }
        Integer cached = seen.get(array);
        if (cached != null) {
            return cached;
        }
        seen.put(array, 0);
        int result = 1;
        if (array instanceof Object[]) {
            for (Object item : (Object[])array) {
                result = 31 * result + this.arrayHashCode(item, seen);
            }
        }
        seen.put(array, result);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        int len = this.size();
        if (len != other.size()) {
            return false;
        }
        Object[] vals = this.keysWereSet && this.itemsWereSet ? this.items : this.values;
        Object[] otherVals = other.keysWereSet && other.itemsWereSet ? other.items : other.values;
        for (int i = 0; i < len; ++i) {
            if (!Objects.equals(this.keys[i], other.keys[i])) {
                return false;
            }
            if (Objects.equals(vals[i], otherVals[i])) continue;
            return false;
        }
        if (!this.keysWereSet && !other.keysWereSet) {
            return Arrays.equals(this.items, other.items);
        }
        return true;
    }

    Map.Entry<Object[], Object[]> asTwoArrays() {
        if (this.keysWereSet && this.itemsWereSet) {
            if (this.keys.length != this.items.length) {
                throw new JsonIoException("@keys and @items must be same length");
            }
            return new AbstractMap.SimpleImmutableEntry<Object[], Object[]>(this.keys, this.items);
        }
        if (this.keysWereSet) {
            throw new JsonIoException("@keys cannot be set without @items");
        }
        if (this.itemsWereSet && this.isMap()) {
            throw new JsonIoException("Map with @items must also have @keys");
        }
        return new AbstractMap.SimpleImmutableEntry<Object[], Object[]>(this.keys, this.values);
    }

    void rehashMaps() {
        int len;
        if (!(this.target instanceof Map)) {
            return;
        }
        Object[] k = this.keys;
        Object[] v = this.keysWereSet && this.itemsWereSet ? this.items : this.values;
        int n = len = this.keysWereSet ? this.keys.length : this.size;
        if (len == 0) {
            return;
        }
        this.hash = null;
        Map targetMap = (Map)this.target;
        for (int i = 0; i < len; ++i) {
            JsonObject jObj;
            Object key = k[i];
            Object value = v[i];
            if (key instanceof JsonObject) {
                jObj = (JsonObject)key;
                if (jObj.target != null) {
                    key = jObj.target;
                } else if (jObj.hasValue()) {
                    key = jObj.getValue();
                }
            }
            if (value instanceof JsonObject) {
                jObj = (JsonObject)value;
                if (jObj.target != null) {
                    value = jObj.target;
                } else if (jObj.hasValue()) {
                    value = jObj.getValue();
                }
            }
            targetMap.put(key, value);
        }
    }

    public static void setLinearSearchThreshold(int threshold) {
        if (threshold < 1) {
            throw new JsonIoException("Threshold must be >= 1, was: " + threshold);
        }
        INDEX_THRESHOLD = threshold;
    }

    public static int getLinearSearchThreshold() {
        return INDEX_THRESHOLD;
    }

    public static enum JsonType {
        ARRAY,
        COLLECTION,
        MAP,
        OBJECT;

    }

    private class KeySet
    extends AbstractSet<Object> {
        private KeySet() {
        }

        @Override
        public int size() {
            return JsonObject.this.size();
        }

        @Override
        public boolean isEmpty() {
            return JsonObject.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return JsonObject.this.containsKey(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private final int len;
                private int idx;
                {
                    this.len = JsonObject.this.size();
                    this.idx = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.idx < this.len;
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return JsonObject.this.keys[this.idx++];
                }
            };
        }
    }

    private class ValuesCollection
    extends AbstractSet<Object> {
        private ValuesCollection() {
        }

        @Override
        public int size() {
            return JsonObject.this.size();
        }

        @Override
        public boolean isEmpty() {
            return JsonObject.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return JsonObject.this.containsValue(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private final Object[] vals;
                private final int len;
                private int idx;
                {
                    this.vals = JsonObject.this.keysWereSet && JsonObject.this.itemsWereSet ? JsonObject.this.items : JsonObject.this.values;
                    this.len = JsonObject.this.size();
                    this.idx = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.idx < this.len;
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.vals[this.idx++];
                }
            };
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Object, Object>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return JsonObject.this.size();
        }

        @Override
        public boolean isEmpty() {
            return JsonObject.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            int idx = JsonObject.this.indexOf(entry.getKey());
            if (idx < 0) {
                return false;
            }
            Object[] vals = JsonObject.this.keysWereSet && JsonObject.this.itemsWereSet ? JsonObject.this.items : JsonObject.this.values;
            return Objects.equals(vals[idx], entry.getValue());
        }
    }

    private class ReusableEntry
    implements Map.Entry<Object, Object> {
        int index;
        Object[] vals;

        private ReusableEntry() {
        }

        @Override
        public Object getKey() {
            return JsonObject.this.keys[this.index];
        }

        @Override
        public Object getValue() {
            return this.vals[this.index];
        }

        @Override
        public Object setValue(Object value) {
            Object old = this.vals[this.index];
            this.vals[this.index] = value;
            JsonObject.this.hash = null;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(JsonObject.this.keys[this.index], e.getKey()) && Objects.equals(this.vals[this.index], e.getValue());
        }

        @Override
        public int hashCode() {
            return (JsonObject.this.keys[this.index] == null ? 0 : JsonObject.this.keys[this.index].hashCode()) ^ (this.vals[this.index] == null ? 0 : this.vals[this.index].hashCode());
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<Object, Object>> {
        private final Object[] vals;
        private final int len;
        private int idx;
        private final ReusableEntry entry;

        private EntryIterator() {
            this.vals = JsonObject.this.keysWereSet && JsonObject.this.itemsWereSet ? JsonObject.this.items : JsonObject.this.values;
            this.len = JsonObject.this.size();
            this.idx = 0;
            this.entry = new ReusableEntry();
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.len;
        }

        @Override
        public Map.Entry<Object, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.entry.index = this.idx++;
            this.entry.vals = this.vals;
            return this.entry;
        }
    }
}

