/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.SealedSupplier;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.CompactCIHashMap;
import com.cedarsoftware.util.CompactCIHashSet;
import com.cedarsoftware.util.CompactCILinkedMap;
import com.cedarsoftware.util.CompactCILinkedSet;
import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.CompactLinkedSet;
import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.CompactSet;
import com.cedarsoftware.util.ConcurrentList;
import com.cedarsoftware.util.ConcurrentNavigableSetNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.geom.Color;
import com.cedarsoftware.util.geom.Dimension;
import com.cedarsoftware.util.geom.Insets;
import com.cedarsoftware.util.geom.Point;
import com.cedarsoftware.util.geom.Rectangle;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.logging.Logger;

public abstract class Resolver {
    private static final Logger LOG = Logger.getLogger(Resolver.class.getName());
    private static final String NO_FACTORY = "_\ufe3f_\u03c8_\u263c";
    final Collection<UnresolvedReference> unresolvedRefs = new ArrayList<UnresolvedReference>();
    protected final Deque<JsonObject> stack = new ArrayDeque<JsonObject>();
    private final Collection<JsonObject> mapsToRehash = new ArrayList<JsonObject>();
    final Collection<Missingfields> missingFields = new ArrayList<Missingfields>();
    private ReadOptions readOptions;
    private ReferenceTracker references;
    private final Converter converter;
    private SealedSupplier sealedSupplier = new SealedSupplier();
    private int maxUnresolvedRefs;
    private int maxMapsToRehash;
    private int maxMissingFields;
    private static final ClassValueMap<Function<JsonObject, Object>> DEFAULT_INSTANTIATORS = new ClassValueMap();

    protected Resolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        this.readOptions = readOptions;
        this.references = references;
        this.converter = converter;
        if (readOptions != null) {
            this.maxUnresolvedRefs = readOptions.getMaxUnresolvedReferences();
            this.maxMapsToRehash = readOptions.getMaxMapsToRehash();
            this.maxMissingFields = readOptions.getMaxMissingFields();
        } else {
            this.maxUnresolvedRefs = Integer.MAX_VALUE;
            this.maxMapsToRehash = Integer.MAX_VALUE;
            this.maxMissingFields = Integer.MAX_VALUE;
        }
    }

    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    public ReferenceTracker getReferences() {
        return this.references;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public String readString(JsonObject jsonObj, String fieldName) {
        return (String)this.converter.convert(jsonObj.get(fieldName), String.class);
    }

    public int readInt(JsonObject jsonObj, String fieldName) {
        return (Integer)this.converter.convert(jsonObj.get(fieldName), Integer.TYPE);
    }

    public long readLong(JsonObject jsonObj, String fieldName) {
        return (Long)this.converter.convert(jsonObj.get(fieldName), Long.TYPE);
    }

    public float readFloat(JsonObject jsonObj, String fieldName) {
        return ((Float)this.converter.convert(jsonObj.get(fieldName), Float.TYPE)).floatValue();
    }

    public double readDouble(JsonObject jsonObj, String fieldName) {
        return (Double)this.converter.convert(jsonObj.get(fieldName), Double.TYPE);
    }

    public boolean readBoolean(JsonObject jsonObj, String fieldName) {
        return (Boolean)this.converter.convert(jsonObj.get(fieldName), Boolean.TYPE);
    }

    public <T> T readObject(JsonObject jsonObj, String fieldName, Class<T> type) {
        Object value = jsonObj.get(fieldName);
        if (value == null) {
            return null;
        }
        JsonReader reader = new JsonReader(this);
        return (T)reader.toJava(type, value);
    }

    public <T> T[] readArray(JsonObject jsonObj, String fieldName, Class<T[]> arrayType) {
        Object value = jsonObj.get(fieldName);
        if (value == null) {
            return null;
        }
        JsonReader reader = new JsonReader(this);
        return (Object[])reader.toJava(arrayType, value);
    }

    public <T> List<T> readList(JsonObject jsonObj, String fieldName, Class<T> elementType) {
        Object value = jsonObj.get(fieldName);
        if (value == null) {
            return null;
        }
        JsonReader reader = new JsonReader(this);
        return (List)reader.toJava((Type)((Object)List.class), value);
    }

    public <K, V> Map<K, V> readMap(JsonObject jsonObj, String fieldName, Class<K> keyType, Class<V> valueType) {
        Object value = jsonObj.get(fieldName);
        if (value == null) {
            return null;
        }
        JsonReader reader = new JsonReader(this);
        return (Map)reader.toJava((Type)((Object)Map.class), value);
    }

    public <T> T toJavaObjects(JsonObject rootObj, Type rootType) {
        Object instance;
        if (rootObj == null) {
            return null;
        }
        if (rootObj.isReference() && (rootObj = this.getReferences().get(rootObj.refId)) != null) {
            return (T)rootObj;
        }
        if (rootObj.isFinished) {
            return (T)rootObj.getTarget();
        }
        if (rootObj.getType() == null) {
            rootObj.setType(rootType);
        }
        Object object = instance = rootObj.getTarget() == null ? this.createInstance(rootObj) : rootObj.getTarget();
        if (rootObj.isFinished) {
            return (T)instance;
        }
        return this.traverseJsonObject(rootObj);
    }

    public <T> T traverseJsonObject(JsonObject root) {
        this.push(root);
        while (!this.stack.isEmpty()) {
            JsonObject jsonObj = this.stack.pop();
            if (jsonObj.isFinished) continue;
            this.traverseSpecificType(jsonObj);
        }
        return (T)root.getTarget();
    }

    protected void traverseSpecificType(JsonObject jsonObj) {
        if (jsonObj.isArray()) {
            this.traverseArray(jsonObj);
        } else if (jsonObj.isCollection()) {
            this.traverseCollection(jsonObj);
        } else if (jsonObj.isMap()) {
            this.traverseMap(jsonObj);
        } else {
            this.traverseObject(jsonObj);
        }
    }

    protected void traverseObject(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        Object special = this.readWithFactoryIfExists(jsonObj, null);
        if (special != null) {
            jsonObj.setTarget(special);
        } else {
            this.traverseFields(jsonObj);
        }
    }

    public SealedSupplier getSealedSupplier() {
        return this.sealedSupplier;
    }

    public void push(JsonObject jsonObject) {
        if (jsonObject.isFinished) {
            return;
        }
        int maxStackDepth = this.readOptions.getMaxStackDepth();
        if (maxStackDepth != Integer.MAX_VALUE && this.stack.size() >= maxStackDepth) {
            throw new JsonIoException("Security limit exceeded: Maximum traversal stack depth (" + maxStackDepth + ") reached. Possible deeply nested attack.");
        }
        this.stack.push(jsonObject);
    }

    public abstract void traverseFields(JsonObject var1);

    protected abstract Object readWithFactoryIfExists(Object var1, Type var2);

    protected abstract void traverseCollection(JsonObject var1);

    protected abstract void traverseArray(JsonObject var1);

    protected void addUnresolvedReference(UnresolvedReference ref) {
        if (this.maxUnresolvedRefs != Integer.MAX_VALUE && this.unresolvedRefs.size() >= this.maxUnresolvedRefs) {
            throw new JsonIoException("Security limit exceeded: Maximum unresolved references (" + this.maxUnresolvedRefs + ") reached. Possible DoS attack.");
        }
        this.unresolvedRefs.add(ref);
    }

    protected void addMissingField(Missingfields field) {
        if (this.maxMissingFields != Integer.MAX_VALUE && this.missingFields.size() >= this.maxMissingFields) {
            throw new JsonIoException("Security limit exceeded: Maximum missing fields (" + this.maxMissingFields + ") reached. Possible DoS attack.");
        }
        this.missingFields.add(field);
    }

    protected void cleanup() {
        this.patchUnresolvedReferences();
        this.rehashMaps();
        this.references.clear();
        this.unresolvedRefs.clear();
        this.mapsToRehash.clear();
        this.handleMissingFields();
        this.missingFields.clear();
        this.stack.clear();
        this.references = null;
        this.readOptions = null;
        this.sealedSupplier.seal();
        this.sealedSupplier = null;
    }

    private void handleMissingFields() {
        JsonReader.MissingFieldHandler missingFieldHandler = this.readOptions.getMissingFieldHandler();
        if (missingFieldHandler != null) {
            for (Missingfields mf : this.missingFields) {
                missingFieldHandler.fieldMissing(mf.target, mf.fieldName, mf.value);
            }
        }
    }

    protected void traverseMap(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        jsonObj.setFinished();
        Map.Entry<Object[], Object[]> pair = jsonObj.asTwoArrays();
        Object[] keys = pair.getKey();
        Object[] items = pair.getValue();
        if (keys == null) {
            return;
        }
        this.buildCollection(keys);
        this.buildCollection(items);
        int maxMapsToRehash = this.readOptions.getMaxMapsToRehash();
        if (maxMapsToRehash != Integer.MAX_VALUE && this.mapsToRehash.size() >= maxMapsToRehash) {
            throw new JsonIoException("Security limit exceeded: Maximum maps to rehash (" + maxMapsToRehash + ") reached. Possible DoS attack.");
        }
        this.mapsToRehash.add(jsonObj);
    }

    private void buildCollection(Object[] arrayContent) {
        JsonObject collection = new JsonObject();
        collection.setItems(arrayContent);
        collection.setTarget(arrayContent);
        this.push(collection);
    }

    Object createInstance(JsonObject jsonObj) {
        Object mate;
        Class<?> targetType;
        block12: {
            Class<?> factoryType;
            Object sourceValue;
            Class<?> sourceType;
            Object instance;
            Object target = jsonObj.getTarget();
            if (target != null) {
                return target;
            }
            targetType = this.resolveTargetType(jsonObj);
            Function instantiator = (Function)DEFAULT_INSTANTIATORS.get(targetType);
            if (instantiator != null && (instance = instantiator.apply(jsonObj)) != null) {
                return jsonObj.setTarget(instance);
            }
            if (this.converter.isSimpleTypeConversionSupported(targetType)) {
                Object result = this.converter.convert((Object)jsonObj, targetType);
                return jsonObj.setFinishedTarget(result, true);
            }
            if (!Throwable.class.isAssignableFrom(targetType) && this.isConverterSimpleType(targetType) && (sourceType = this.determineSourceType(jsonObj, sourceValue = jsonObj.hasValue() ? jsonObj.getValue() : jsonObj)) != null && this.converter.isConversionSupportedFor(sourceType, targetType)) {
                try {
                    Object value = this.converter.convert(sourceValue, targetType);
                    return jsonObj.setFinishedTarget(value, true);
                }
                catch (Exception value) {
                    // empty catch block
                }
            }
            if ((mate = this.createInstanceUsingClassFactory(factoryType = this.determineFactoryType(jsonObj, targetType), jsonObj)) != NO_FACTORY) {
                return mate;
            }
            if (!Throwable.class.isAssignableFrom(targetType)) {
                Class<?> legacySourceType;
                Object legacySourceValue;
                Object object = legacySourceValue = jsonObj.hasValue() ? jsonObj.getValue() : null;
                Class<Object> clazz = legacySourceValue != null ? legacySourceValue.getClass() : (legacySourceType = !jsonObj.isEmpty() ? Map.class : null);
                if (legacySourceType != null && this.converter.isConversionSupportedFor(legacySourceType, targetType)) {
                    try {
                        Object value = this.converter.convert(legacySourceValue != null ? legacySourceValue : jsonObj, targetType);
                        return jsonObj.setFinishedTarget(value, true);
                    }
                    catch (Exception e) {
                        if (!Boolean.parseBoolean(System.getProperty("json-io.debug", "false"))) break block12;
                        LOG.fine("Legacy conversion failed for " + legacySourceType + " to " + targetType + ": " + e.getMessage());
                    }
                }
            }
        }
        if (this.shouldCreateArray(jsonObj, targetType)) {
            mate = this.createArrayInstance(jsonObj, targetType);
            return jsonObj.setTarget(mate);
        }
        return this.createInstanceUsingType(jsonObj);
    }

    private Class<?> resolveTargetType(JsonObject jsonObj) {
        Class<?> coercedEnumClass;
        Class<?> targetType = this.coerceClassIfNeeded(jsonObj.getRawType());
        jsonObj.setType(targetType);
        Class enumClass = ClassUtilities.getClassIfEnum(targetType);
        if (enumClass != null && (coercedEnumClass = this.getCoercedEnumClass(enumClass)) != null) {
            targetType = coercedEnumClass;
            jsonObj.setType(coercedEnumClass);
        }
        return targetType;
    }

    private Class<?> coerceClassIfNeeded(Class<?> type) {
        Class<?> clazz = this.readOptions.getCoercedClass(type);
        return clazz == null ? type : clazz;
    }

    private Class<?> getCoercedEnumClass(Class<?> enumClass) {
        Class<?> coercedClass = this.readOptions.getCoercedClass(enumClass);
        if (coercedClass != null) {
            return ClassUtilities.getClassIfEnum(coercedClass);
        }
        return null;
    }

    private Class<?> determineSourceType(JsonObject jsonObj, Object sourceValue) {
        if (sourceValue != null && sourceValue != jsonObj) {
            return sourceValue.getClass();
        }
        if (!jsonObj.isEmpty()) {
            return Map.class;
        }
        return null;
    }

    private Class<?> determineFactoryType(JsonObject jsonObj, Class<?> targetType) {
        Class enumClass = ClassUtilities.getClassIfEnum(targetType);
        if (enumClass != null) {
            boolean isEnumSet = jsonObj.getItems() != null;
            return isEnumSet ? EnumSet.class : enumClass;
        }
        return targetType;
    }

    private boolean shouldCreateArray(JsonObject jsonObj, Class<?> targetType) {
        Object[] items = jsonObj.getItems();
        return targetType.isArray() || items != null && targetType == Object.class && jsonObj.getKeys() == null;
    }

    private boolean isConverterSimpleType(Class<?> clazz) {
        if (clazz == Color.class) {
            return true;
        }
        if (clazz == Dimension.class) {
            return true;
        }
        if (clazz == Point.class) {
            return true;
        }
        if (clazz == Rectangle.class) {
            return true;
        }
        return clazz == Insets.class;
    }

    private Object createArrayInstance(JsonObject jsonObj, Class<?> targetType) {
        Object[] items = jsonObj.getItems();
        int size = items == null ? 0 : items.length;
        Class componentType = targetType.isArray() ? targetType.getComponentType() : Object.class;
        return Array.newInstance(componentType, size);
    }

    private Object createInstanceUsingType(JsonObject jsonObj) {
        Object instance;
        boolean isUnknownObject;
        Class<?> c = jsonObj.getRawType();
        boolean bl = isUnknownObject = c == Object.class && !this.readOptions.isReturningJsonObjects();
        if (isUnknownObject && this.readOptions.getUnknownTypeClass() == null) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.setType((Type)((Object)Map.class));
            instance = jsonObject;
        } else {
            Class<?> targetClass = isUnknownObject ? this.readOptions.getUnknownTypeClass() : c;
            instance = ClassUtilities.newInstance((Converter)this.converter, targetClass, (Object)jsonObj);
        }
        return jsonObj.setTarget(instance);
    }

    Object createInstanceUsingClassFactory(Class c, JsonObject jsonObj) {
        JsonReader.ClassFactory classFactory = this.readOptions.getClassFactory(c);
        if (classFactory == null) {
            return NO_FACTORY;
        }
        Object target = classFactory.newInstance(c, jsonObj, this);
        if (classFactory.isObjectFinal()) {
            return jsonObj.setFinishedTarget(target, true);
        }
        return jsonObj.setTarget(target);
    }

    private void patchUnresolvedReferences() {
        for (UnresolvedReference ref : this.unresolvedRefs) {
            Object objToFix = ref.referencingObj.getTarget();
            JsonObject objReferenced = this.references.getOrThrow(ref.refId);
            Object referencedTarget = objReferenced.getTarget();
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    ((List)objToFix).set(ref.index, referencedTarget);
                    continue;
                }
                if (objToFix instanceof Collection) {
                    ((Collection)objToFix).add(referencedTarget);
                    continue;
                }
                if (objToFix instanceof Object[]) {
                    ((Object[])objToFix)[((UnresolvedReference)ref).index] = referencedTarget;
                    continue;
                }
                ArrayUtilities.setPrimitiveElement((Object)objToFix, (int)ref.index, (Object)referencedTarget);
                continue;
            }
            Map<String, Injector> injectors = this.getReadOptions().getDeepInjectorMap(objToFix.getClass());
            Injector injector = injectors.get(ref.field);
            if (injector == null) continue;
            try {
                injector.inject(objToFix, referencedTarget);
            }
            catch (Exception e) {
                throw new JsonIoException("Error setting field while resolving references '" + ref.field + "', @ref = " + ref.refId, e);
            }
        }
        this.unresolvedRefs.clear();
    }

    private void rehashMaps() {
        for (JsonObject jsonObj : this.mapsToRehash) {
            jsonObj.rehashMaps();
        }
    }

    public boolean valueToTarget(JsonObject jsonObject) {
        if (jsonObject.getType() == null) {
            return false;
        }
        Class<?> javaType = jsonObject.getRawType();
        if (javaType.isArray() && this.converter.isSimpleTypeConversionSupported(javaType.getComponentType(), javaType.getComponentType())) {
            Object[] jsonItems = jsonObject.getItems();
            Class<?> componentType = javaType.getComponentType();
            if (jsonItems == null) {
                jsonObject.setFinishedTarget(null, true);
                return true;
            }
            int len = jsonItems.length;
            Object javaArray = Array.newInstance(componentType, len);
            if (!componentType.isPrimitive()) {
                Object[] typedArray = (Object[])javaArray;
                for (int i = 0; i < len; ++i) {
                    try {
                        JsonObject jObj;
                        Class<?> type = componentType;
                        Object item = jsonItems[i];
                        if (item instanceof JsonObject && (jObj = (JsonObject)item).getType() != null) {
                            type = jObj.getRawType();
                        }
                        typedArray[i] = this.converter.convert(item, type);
                        continue;
                    }
                    catch (Exception e) {
                        JsonIoException jioe = new JsonIoException(e.getMessage());
                        jioe.setStackTrace(e.getStackTrace());
                        throw jioe;
                    }
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    try {
                        JsonObject jObj;
                        Class<?> type = componentType;
                        Object item = jsonItems[i];
                        if (item instanceof JsonObject && (jObj = (JsonObject)item).getType() != null) {
                            type = jObj.getRawType();
                        }
                        ArrayUtilities.setPrimitiveElement((Object)javaArray, (int)i, (Object)this.converter.convert(item, type));
                        continue;
                    }
                    catch (Exception e) {
                        JsonIoException jioe = new JsonIoException(e.getMessage());
                        jioe.setStackTrace(e.getStackTrace());
                        throw jioe;
                    }
                }
            }
            jsonObject.setFinishedTarget(javaArray, true);
            return true;
        }
        if (!this.converter.isSimpleTypeConversionSupported(javaType)) {
            return false;
        }
        try {
            Object value = this.converter.convert((Object)jsonObject, javaType);
            jsonObject.setFinishedTarget(value, true);
            return true;
        }
        catch (Exception e) {
            JsonIoException jioe = new JsonIoException(e.getMessage());
            jioe.setStackTrace(e.getStackTrace());
            throw jioe;
        }
    }

    protected void setArrayElement(Object array, int index, Object element) {
        if (array instanceof Object[]) {
            try {
                ((Object[])array)[index] = element;
            }
            catch (ArrayStoreException e) {
                String elementType = element == null ? "null" : element.getClass().getName();
                String arrayType = array.getClass().getComponentType().getName() + "[]";
                throw new IllegalArgumentException("Cannot set '" + elementType + "' (value: " + element + ") into '" + arrayType + "' at index " + index);
            }
        } else {
            ArrayUtilities.setPrimitiveElement((Object)array, (int)index, (Object)element);
        }
    }

    protected abstract Object resolveArray(Type var1, List<Object> var2);

    static {
        DEFAULT_INSTANTIATORS.put(ArrayList.class, jsonObj -> new ArrayList());
        DEFAULT_INSTANTIATORS.put(LinkedList.class, jsonObj -> new LinkedList());
        DEFAULT_INSTANTIATORS.put(CopyOnWriteArrayList.class, jsonObj -> new CopyOnWriteArrayList());
        DEFAULT_INSTANTIATORS.put(ConcurrentList.class, jsonObj -> new ConcurrentList());
        DEFAULT_INSTANTIATORS.put(CompactCIHashMap.class, jsonObj -> new CompactCIHashMap());
        DEFAULT_INSTANTIATORS.put(CompactCILinkedMap.class, jsonObj -> new CompactCILinkedMap());
        DEFAULT_INSTANTIATORS.put(CompactLinkedMap.class, jsonObj -> new CompactLinkedMap());
        DEFAULT_INSTANTIATORS.put(ConcurrentHashMap.class, jsonObj -> new ConcurrentHashMap());
        DEFAULT_INSTANTIATORS.put(ConcurrentSkipListMap.class, jsonObj -> new ConcurrentSkipListMap());
        DEFAULT_INSTANTIATORS.put(Vector.class, jsonObj -> new Vector());
        DEFAULT_INSTANTIATORS.put(HashMap.class, jsonObj -> new HashMap());
        DEFAULT_INSTANTIATORS.put(TreeMap.class, jsonObj -> new TreeMap());
        DEFAULT_INSTANTIATORS.put(CompactCIHashSet.class, jsonObj -> new CompactCIHashSet());
        DEFAULT_INSTANTIATORS.put(CompactCILinkedSet.class, jsonObj -> new CompactCILinkedSet());
        DEFAULT_INSTANTIATORS.put(CompactLinkedSet.class, jsonObj -> new CompactLinkedSet());
        DEFAULT_INSTANTIATORS.put(ConcurrentSkipListSet.class, jsonObj -> new ConcurrentSkipListSet());
        DEFAULT_INSTANTIATORS.put(ConcurrentNavigableSetNullSafe.class, jsonObj -> new ConcurrentNavigableSetNullSafe());
        DEFAULT_INSTANTIATORS.put(ConcurrentSet.class, jsonObj -> new ConcurrentSet());
        DEFAULT_INSTANTIATORS.put(HashSet.class, jsonObj -> new HashSet());
        DEFAULT_INSTANTIATORS.put(LinkedHashSet.class, jsonObj -> new LinkedHashSet());
        DEFAULT_INSTANTIATORS.put(TreeSet.class, jsonObj -> new TreeSet());
        DEFAULT_INSTANTIATORS.put(LinkedHashMap.class, jsonObj -> new LinkedHashMap());
        DEFAULT_INSTANTIATORS.put(CompactMap.class, jsonObj -> {
            if (!jsonObj.containsKey("config") || !jsonObj.containsKey("data")) {
                return new CompactMap();
            }
            Object configValue = jsonObj.get("config");
            if (!(configValue instanceof String)) {
                return new CompactMap();
            }
            String config = (String)configValue;
            int slashCount = 0;
            for (int i = 0; i < config.length() && (config.charAt(i) != '/' || ++slashCount < 2); ++i) {
            }
            if (slashCount < 2) {
                return new CompactMap();
            }
            return null;
        });
        DEFAULT_INSTANTIATORS.put(CompactSet.class, jsonObj -> {
            if (!jsonObj.containsKey("config") || !jsonObj.containsKey("data")) {
                return new CompactSet();
            }
            Object configValue = jsonObj.get("config");
            if (!(configValue instanceof String) || StringUtilities.count((String)((String)configValue), (char)'/') < 2) {
                return new CompactSet();
            }
            return null;
        });
    }

    protected static class Missingfields {
        private final Object target;
        private final String fieldName;
        private final Object value;

        public Missingfields(Object target, String fieldName, Object value) {
            this.target = target;
            this.fieldName = fieldName;
            this.value = value;
        }
    }

    static final class UnresolvedReference {
        private final JsonObject referencingObj;
        private String field;
        private final long refId;
        private int index = -1;

        UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }
}

