/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class ObjectResolver
extends Resolver {
    protected ObjectResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        jsonObj.setFinished();
        Object javaMate = jsonObj.getTarget();
        Class<?> cls = javaMate.getClass();
        ReadOptions readOptions = this.getReadOptions();
        Map<String, Injector> injectorMap = readOptions.getDeepInjectorMap(cls);
        JsonReader.MissingFieldHandler missingFieldHandler = readOptions.getMissingFieldHandler();
        for (Map.Entry<Object, Object> entry : jsonObj.entrySet()) {
            String key = (String)entry.getKey();
            Injector injector = injectorMap.get(key);
            Object rhs = entry.getValue();
            if (injector != null) {
                this.assignField(jsonObj, injector, rhs);
                continue;
            }
            if (missingFieldHandler == null) continue;
            this.handleMissingField(jsonObj, rhs, key);
        }
    }

    public void assignField(JsonObject jsonObj, Injector injector, Object rhs) {
        Object special;
        Object target = jsonObj.getTarget();
        Type fieldType = injector.getGenericType();
        Class rawFieldType = TypeUtilities.getRawClass((Type)fieldType);
        if (rhs == null) {
            if (rawFieldType.isPrimitive()) {
                injector.inject(target, this.getConverter().convert(null, rawFieldType));
            } else {
                injector.inject(target, null);
            }
            return;
        }
        if (rhs instanceof JsonObject) {
            JsonObject jObj;
            Type explicitType;
            if (fieldType instanceof ParameterizedType) {
                this.markUntypedObjects(fieldType, (JsonObject)rhs);
            }
            if ((explicitType = (jObj = (JsonObject)rhs).getType()) != null && !TypeUtilities.hasUnresolvedType((Type)explicitType)) {
                jObj.setType(explicitType);
            } else {
                Type resolvedFieldType = TypeUtilities.resolveTypeUsingInstance((Object)target, (Type)fieldType);
                jObj.setType(resolvedFieldType);
            }
        }
        if ((special = this.readWithFactoryIfExists(rhs, rawFieldType)) != null) {
            injector.inject(target, special);
        } else if (rhs.getClass().isArray()) {
            Object[] elements = (Object[])rhs;
            JsonObject jsonArray = new JsonObject();
            jsonArray.setType(fieldType);
            jsonArray.setItems(elements);
            this.createInstance(jsonArray);
            injector.inject(target, jsonArray.getTarget());
            this.push(jsonArray);
        } else if (rhs instanceof JsonObject) {
            JsonObject jsRhs = (JsonObject)rhs;
            Long ref = jsRhs.getReferenceId();
            if (ref != null) {
                JsonObject refObject = this.getReferences().getOrThrow(ref);
                if (refObject.getTarget() != null) {
                    injector.inject(target, refObject.getTarget());
                } else {
                    this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, injector.getName(), (long)ref));
                }
            } else {
                Object fieldObject = jsRhs.getTarget();
                injector.inject(target, fieldObject);
                boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jsRhs.getRawType());
                if (!isNonRefClass) {
                    this.push(jsRhs);
                }
            }
        } else if (rhs instanceof String && ((String)rhs).trim().isEmpty() && rawFieldType != String.class) {
            injector.inject(target, null);
        } else {
            injector.inject(target, rhs);
        }
    }

    protected void handleMissingField(JsonObject jsonObj, Object rhs, String missingField) {
        Object target = jsonObj.getTarget();
        try {
            if (rhs == null) {
                this.storeMissingField(target, missingField, null);
                return;
            }
            Object special = this.readWithFactoryIfExists(rhs, null);
            if (special != null) {
                this.storeMissingField(target, missingField, special);
            } else if (rhs.getClass().isArray()) {
                this.storeMissingField(target, missingField, null);
            } else if (rhs instanceof JsonObject) {
                JsonObject jObj = (JsonObject)rhs;
                Long ref = jObj.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = this.getReferences().getOrThrow(ref);
                    this.storeMissingField(target, missingField, refObject.getTarget());
                } else if (jObj.getType() != null) {
                    Object javaInstance = this.createInstance(jObj);
                    boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jObj.getRawType());
                    if (!isNonRefClass && !jObj.isFinished) {
                        this.push((JsonObject)rhs);
                    }
                    this.storeMissingField(target, missingField, javaInstance);
                } else {
                    this.storeMissingField(target, missingField, null);
                }
            } else {
                this.storeMissingField(target, missingField, rhs);
            }
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw e;
            }
            String message = e.getClass().getSimpleName() + " missing field '" + missingField + "' on target: " + ObjectResolver.safeToString(target) + " with value: " + rhs;
            throw new JsonIoException(message, e);
        }
    }

    private void storeMissingField(Object target, String missingField, Object value) {
        this.missingFields.add(new Resolver.Missingfields(target, missingField, value));
    }

    private static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            return o.getClass().toString();
        }
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        ParameterizedType pt;
        Type[] typeArgs;
        if (jsonObj.isFinished) {
            return;
        }
        jsonObj.setFinished();
        Converter converter = this.getConverter();
        Object[] items = jsonObj.getItems();
        if (items == null) {
            return;
        }
        Collection col = (Collection)jsonObj.getTarget();
        if (col instanceof ArrayList) {
            ((ArrayList)col).ensureCapacity(items.length);
        }
        boolean isList = col instanceof List;
        int idx = 0;
        Type fullType = jsonObj.getType();
        Object elementType = Object.class;
        if (fullType instanceof ParameterizedType && (typeArgs = (pt = (ParameterizedType)fullType).getActualTypeArguments()).length > 0) {
            elementType = typeArgs[0];
        }
        Class rawElementType = TypeUtilities.getRawClass(elementType);
        ReadOptions readOptions = this.getReadOptions();
        for (Object element : items) {
            JsonObject jObj;
            if (element == null) {
                col.add(null);
                ++idx;
                continue;
            }
            if (element instanceof String || element instanceof Boolean || element instanceof Long || element instanceof Double) {
                col.add(element);
                ++idx;
                continue;
            }
            Class<?> elementClass = element.getClass();
            if (element instanceof JsonObject) {
                jObj = (JsonObject)element;
                Long ref = jObj.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = this.getReferences().getOrThrow(ref);
                    if (refObject.getTarget() != null) {
                        col.add(refObject.getTarget());
                    } else {
                        this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, idx, (long)ref));
                        if (isList) {
                            col.add(null);
                        }
                    }
                } else {
                    jObj.setType((Type)elementType);
                    this.createInstance(jObj);
                    boolean isNonRefClass = this.getReadOptions().isNonReferenceableClass(jObj.getRawType());
                    if (!isNonRefClass) {
                        this.traverseSpecificType(jObj);
                    }
                    if (!(col instanceof EnumSet)) {
                        col.add(jObj.getTarget());
                    }
                }
            } else if (elementClass.isArray()) {
                jObj = new JsonObject();
                Object arrayComponentType = TypeUtilities.extractArrayComponentType((Type)elementType);
                if (arrayComponentType == null) {
                    arrayComponentType = Object.class;
                }
                jObj.setType((Type)arrayComponentType);
                jObj.setItems((Object[])element);
                this.createInstance(jObj);
                col.add(jObj.getTarget());
                this.push(jObj);
            } else {
                Object special = this.readWithFactoryIfExists(element, rawElementType);
                if (special != null) {
                    col.add(special);
                } else if (converter.isSimpleTypeConversionSupported(elementClass)) {
                    col.add(element);
                } else {
                    col.add(element);
                }
            }
            ++idx;
        }
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        jsonObj.setFinished();
        Object[] jsonItems = jsonObj.getItems();
        if (jsonItems == null || jsonItems.length == 0) {
            return;
        }
        int len = jsonItems.length;
        ReadOptions readOptions = this.getReadOptions();
        ReferenceTracker refTracker = this.getReferences();
        Object array = jsonObj.getTarget();
        Class<?> fallbackCompType = array.getClass().getComponentType();
        Class<?> effectiveComponentType = TypeUtilities.extractArrayComponentType((Type)jsonObj.getType());
        if (effectiveComponentType == null) {
            effectiveComponentType = fallbackCompType;
        }
        Class effectiveRawComponentType = TypeUtilities.getRawClass(effectiveComponentType);
        boolean isEnumComponentType = effectiveRawComponentType.isEnum();
        for (int i = 0; i < len; ++i) {
            Object element = jsonItems[i];
            if (element == null) {
                this.setArrayElement(array, i, null);
                continue;
            }
            Object special = this.readWithFactoryIfExists(element, effectiveRawComponentType);
            if (special != null) {
                if (isEnumComponentType && special instanceof String) {
                    special = Enum.valueOf(effectiveRawComponentType, (String)special);
                }
                this.setArrayElement(array, i, special);
                continue;
            }
            if (element.getClass().isArray()) {
                Object jsonArray;
                if (char[].class == effectiveRawComponentType) {
                    jsonArray = (Object[])element;
                    if (((Object[])jsonArray).length == 0) {
                        this.setArrayElement(array, i, new char[0]);
                        continue;
                    }
                    char[] chars = ((String)jsonArray[0]).toCharArray();
                    this.setArrayElement(array, i, chars);
                    continue;
                }
                jsonArray = new JsonObject();
                ((JsonObject)jsonArray).setItems((Object[])element);
                ((JsonValue)jsonArray).setType(effectiveComponentType);
                this.setArrayElement(array, i, this.createInstance((JsonObject)jsonArray));
                this.push((JsonObject)jsonArray);
                continue;
            }
            if (element instanceof JsonObject) {
                JsonObject jsonElement = (JsonObject)element;
                Long ref = jsonElement.getReferenceId();
                if (ref != null) {
                    JsonObject refObject = refTracker.getOrThrow(ref);
                    if (refObject.getTarget() != null) {
                        this.setArrayElement(array, i, refObject.getTarget());
                        continue;
                    }
                    this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, i, (long)ref));
                    continue;
                }
                jsonElement.setType(effectiveComponentType);
                Object arrayElement = this.createInstance(jsonElement);
                this.setArrayElement(array, i, arrayElement);
                boolean isNonRefClass = readOptions.isNonReferenceableClass(arrayElement.getClass());
                if (isNonRefClass || jsonElement.isFinished) continue;
                this.push(jsonElement);
                continue;
            }
            if (element instanceof String && ((String)element).trim().isEmpty() && effectiveRawComponentType != String.class && effectiveRawComponentType != Object.class) {
                this.setArrayElement(array, i, null);
                continue;
            }
            this.setArrayElement(array, i, element);
        }
        jsonObj.clear();
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Type inferredType) {
        JsonReader.JsonClassReader reader;
        Object value;
        Class<?> targetClass;
        JsonObject jsonObj;
        Class<?> rawInferred;
        Convention.throwIfNull((Object)o, (String)"Bug in json-io, null must be checked before calling this method.");
        ReadOptions readOptions = this.getReadOptions();
        Converter converter = this.getConverter();
        Class<?> clazz = rawInferred = inferredType != null ? TypeUtilities.getRawClass((Type)inferredType) : null;
        if (rawInferred == null && !(o instanceof JsonObject)) {
            return null;
        }
        if (rawInferred != null && readOptions.isNotCustomReaderClass(rawInferred)) {
            return null;
        }
        if (o instanceof JsonObject) {
            jsonObj = (JsonObject)o;
            if (jsonObj.isReference()) {
                return null;
            }
            if (jsonObj.getTarget() == null) {
                targetClass = jsonObj.getRawType();
                if (targetClass == null || rawInferred == null) {
                    return null;
                }
                Object factoryCreated = this.createInstance(jsonObj);
                if (factoryCreated != null && jsonObj.isFinished()) {
                    return factoryCreated;
                }
            } else {
                targetClass = jsonObj.getRawType();
            }
        } else {
            targetClass = rawInferred.equals(Object.class) ? o.getClass() : rawInferred;
            jsonObj = new JsonObject();
            jsonObj.setValue(o);
            jsonObj.setType(targetClass);
        }
        if (targetClass != rawInferred && readOptions.isNotCustomReaderClass(targetClass)) {
            return null;
        }
        if (jsonObj.getTarget() == null && jsonObj.hasValue() && converter.isSimpleTypeConversionSupported((value = jsonObj.getValue()).getClass(), targetClass)) {
            Object converted = converter.convert(value, targetClass);
            return jsonObj.setFinishedTarget(converted, true);
        }
        JsonReader.ClassFactory classFactory = readOptions.getClassFactory(targetClass);
        if (classFactory != null && jsonObj.getTarget() == null) {
            Object target = this.createInstanceUsingClassFactory(targetClass, jsonObj);
            if (jsonObj.isFinished()) {
                return target;
            }
        }
        if ((reader = readOptions.getCustomReader(targetClass)) == null) {
            return null;
        }
        Object read = reader.read(o, this);
        return read != null ? jsonObj.setFinishedTarget(read, true) : null;
    }

    /*
     * WARNING - void declaration
     */
    private void markUntypedObjects(Type type, JsonObject rhs) {
        if (rhs.isFinished) {
            return;
        }
        ArrayDeque<Object[]> stack = new ArrayDeque<Object[]>();
        Class fieldClass = TypeUtilities.getRawClass((Type)type);
        Map<String, Injector> classFields = this.getReadOptions().getDeepInjectorMap(fieldClass);
        stack.addFirst(new Object[]{type, rhs});
        while (!stack.isEmpty()) {
            Object[] item = (Object[])stack.removeFirst();
            Type t = (Type)item[0];
            Object instance = item[1];
            if (instance == null) continue;
            if (t instanceof ParameterizedType) {
                JsonObject jObj;
                Class clazz = TypeUtilities.getRawClass((Type)t);
                ParameterizedType pType = (ParameterizedType)t;
                Type[] typeArgs = pType.getActualTypeArguments();
                if (typeArgs.length < 1 || clazz == null) continue;
                Type resolvedType = TypeUtilities.resolveType((Type)type, (Type)t);
                ObjectResolver.stampTypeOnJsonObject(instance, resolvedType);
                if (Map.class.isAssignableFrom(clazz)) {
                    JsonObject jsonObj = (JsonObject)instance;
                    Map.Entry<Object[], Object[]> pair = jsonObj.asTwoArrays();
                    Object[] objectArray = pair.getKey();
                    Object[] items = pair.getValue();
                    ObjectResolver.getTemplateTraverseWorkItem(stack, objectArray, typeArgs[0]);
                    ObjectResolver.getTemplateTraverseWorkItem(stack, items, typeArgs[1]);
                    continue;
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    Object[] array;
                    if (instance.getClass().isArray()) {
                        int len = Array.getLength(instance);
                        for (int i = 0; i < len; ++i) {
                            Object object = Array.get(instance, i);
                            if (object == null) continue;
                            if (object.getClass().isArray()) {
                                void var18_31;
                                int innerLen = Array.getLength(object);
                                ArrayList<Object> items = new ArrayList<Object>(innerLen);
                                boolean bl = false;
                                while (var18_31 < innerLen) {
                                    items.add(Array.get(object, (int)var18_31));
                                    ++var18_31;
                                }
                                JsonObject jsonObject = new JsonObject();
                                jsonObject.setType(clazz);
                                jsonObject.setItems((Object[])object);
                                stack.addFirst(new Object[]{t, items});
                                Array.set(instance, i, jsonObject);
                                continue;
                            }
                            stack.addFirst(new Object[]{t, object});
                        }
                        continue;
                    }
                    if (instance instanceof Collection) {
                        Collection col = (Collection)instance;
                        for (Object e : col) {
                            stack.addFirst(new Object[]{typeArgs[0], e});
                        }
                        continue;
                    }
                    if (!(instance instanceof JsonObject) || (array = (jObj = (JsonObject)instance).getItems()) == null) continue;
                    for (Object object : array) {
                        stack.addFirst(new Object[]{typeArgs[0], object});
                    }
                    continue;
                }
                if (!(instance instanceof JsonObject)) continue;
                jObj = (JsonObject)instance;
                for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
                    Injector injector;
                    String fieldName = (String)entry.getKey();
                    if (fieldName.startsWith("this$") || (injector = classFields.get(fieldName)) == null) continue;
                    Type type2 = injector.getGenericType();
                    Type resolved = TypeUtilities.resolveType((Type)t, (Type)type2);
                    if (TypeUtilities.hasUnresolvedType((Type)resolved)) {
                        resolved = typeArgs[0];
                    }
                    stack.addFirst(new Object[]{resolved, entry.getValue()});
                }
                continue;
            }
            ObjectResolver.stampTypeOnJsonObject(instance, t);
        }
    }

    private static void getTemplateTraverseWorkItem(Deque<Object[]> stack, Object[] items, Type type) {
        if (items == null || items.length < 1) {
            return;
        }
        Class rawType = TypeUtilities.getRawClass((Type)type);
        if (rawType != null && Collection.class.isAssignableFrom(rawType)) {
            stack.add(new Object[]{type, items});
        } else {
            for (Object item : items) {
                stack.add(new Object[]{type, item});
            }
        }
    }

    private static void stampTypeOnJsonObject(Object o, Type t) {
        JsonObject jObj;
        if (o instanceof JsonObject && t != null && (jObj = (JsonObject)o).getType() == null) {
            jObj.type = t;
        }
    }

    @Override
    protected Object resolveArray(Type suggestedType, List<Object> list) {
        if (suggestedType == null || TypeUtilities.getRawClass((Type)suggestedType) == Object.class) {
            return list.toArray();
        }
        JsonObject jsonArray = new JsonObject();
        jsonArray.setType(suggestedType);
        Class rawType = TypeUtilities.getRawClass((Type)suggestedType);
        if (Collection.class.isAssignableFrom(rawType)) {
            jsonArray.setTarget(this.createInstance(jsonArray));
        } else {
            jsonArray.setTarget(Array.newInstance(rawType, list.size()));
        }
        jsonArray.setItems(list.toArray());
        return jsonArray;
    }
}

