/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonParser;
import com.cedarsoftware.io.MapResolver;
import com.cedarsoftware.io.ObjectResolver;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.FastByteArrayInputStream;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JsonReader
implements Closeable {
    private final FastReader input;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final JsonParser parser;
    private final Converter localConverter;
    private final boolean isRoot;

    protected FastReader getReader(InputStream inputStream) {
        return new FastReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), 65536, 10);
    }

    public JsonReader(InputStream input, ReadOptions readOptions) {
        this(input, readOptions == null ? ReadOptionsBuilder.getDefaultReadOptions() : readOptions, new DefaultReferenceTracker(readOptions == null ? ReadOptionsBuilder.getDefaultReadOptions() : readOptions));
    }

    public JsonReader(InputStream inputStream, ReadOptions readOptions, ReferenceTracker references) {
        this.isRoot = true;
        this.readOptions = readOptions == null ? ReadOptionsBuilder.getDefaultReadOptions() : readOptions;
        Converter converter = new Converter(this.readOptions.getConverterOptions());
        this.input = this.getReader(inputStream);
        this.resolver = this.readOptions.isReturningJsonObjects() ? new MapResolver(this.readOptions, references, converter) : new ObjectResolver(this.readOptions, references, converter);
        this.parser = new JsonParser(this.input, this.resolver);
        this.localConverter = new Converter(this.readOptions.getConverterOptions());
    }

    public JsonReader(ReadOptions readOptions) {
        this((InputStream)new FastByteArrayInputStream(new byte[0]), readOptions);
    }

    public JsonReader(Resolver resolver) {
        this.isRoot = false;
        this.resolver = resolver;
        this.readOptions = resolver.getReadOptions();
        this.localConverter = resolver.getConverter();
        this.input = this.getReader(new ByteArrayInputStream(new byte[0]));
        this.parser = new JsonParser(this.input, resolver);
    }

    public <T> T readObject(Type rootType) {
        Object returnValue;
        this.verifyRootType(rootType);
        try {
            returnValue = this.parser.readValue(rootType);
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException(this.getErrorMessage("error parsing JSON value"), e);
        }
        return (T)this.toJava(rootType, returnValue);
    }

    public Object toJava(Type rootType, Object root) {
        if (root == null) {
            return null;
        }
        boolean isJava = this.resolver.getReadOptions().isReturningJavaObjects();
        if (this.isRootArray(root)) {
            Object o = this.handleArrayRoot(rootType, root);
            if (isJava && o instanceof JsonObject && ((JsonObject)o).target != null) {
                o = ((JsonObject)o).target;
            }
            return o;
        }
        if (root instanceof JsonObject) {
            Object o = this.handleObjectRoot(rootType, (JsonObject)root);
            if (isJava && o instanceof JsonObject && ((JsonObject)o).target != null) {
                o = ((JsonObject)o).target;
            }
            return o;
        }
        return this.convertIfNeeded(rootType, root);
    }

    private boolean isRootArray(Object value) {
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            return true;
        }
        return value instanceof JsonObject && ((JsonObject)value).isArray();
    }

    private Object handleArrayRoot(Type rootType, Object returnValue) {
        JsonObject rootObj;
        if (returnValue.getClass().isArray()) {
            rootObj = new JsonObject();
            rootObj.setType(rootType);
            rootObj.setTarget(returnValue);
            rootObj.setItems((Object[])returnValue);
        } else {
            rootObj = (JsonObject)returnValue;
        }
        Object graph = this.resolveObjects(rootObj, rootType);
        if (graph == null) {
            graph = rootObj.getItems();
        }
        return this.convertIfNeeded(rootType, graph);
    }

    private Object convertIfNeeded(Type rootType, Object returnValue) {
        if (rootType == null) {
            return returnValue;
        }
        Class rootClass = TypeUtilities.getRawClass((Type)rootType);
        if (rootClass.isAssignableFrom(returnValue.getClass())) {
            return returnValue;
        }
        if (rootClass.isEnum() && returnValue instanceof String) {
            String enumValue = (String)returnValue;
            if (enumValue == null || enumValue.trim().isEmpty()) {
                throw new JsonIoException("Invalid enum value: null or empty string for enum type " + rootClass.getName());
            }
            int maxEnumLength = this.readOptions.getMaxEnumNameLength();
            if (enumValue.length() > maxEnumLength) {
                throw new JsonIoException("Security limit exceeded: Enum name too long (" + enumValue.length() + " chars, max " + maxEnumLength + ") for enum type " + rootClass.getName());
            }
            try {
                return Enum.valueOf(rootClass, enumValue.trim());
            }
            catch (IllegalArgumentException e) {
                throw new JsonIoException("Invalid enum value '" + enumValue + "' for enum type " + rootClass.getName(), e);
            }
        }
        try {
            return this.localConverter.convert(returnValue, rootClass);
        }
        catch (Exception e) {
            throw new JsonIoException("Return type mismatch. Expecting: " + rootClass.getName() + ", found: " + returnValue.getClass().getName(), e);
        }
    }

    private <T> void verifyRootType(Type rootType) {
        Class rawTypeToCheck;
        if (rootType == null || this.readOptions.isReturningJavaObjects()) {
            return;
        }
        Class rawRootType = TypeUtilities.getRawClass((Type)rootType);
        Class<?> typeToCheck = rootType;
        if (rawRootType != null && rawRootType.isArray()) {
            Class ultimateRawType;
            while (true) {
                if (typeToCheck instanceof Class) {
                    Class cls = typeToCheck;
                    if (!cls.isArray()) break;
                    typeToCheck = cls.getComponentType();
                    continue;
                }
                if (!(typeToCheck instanceof GenericArrayType)) break;
                typeToCheck = ((GenericArrayType)((Object)typeToCheck)).getGenericComponentType();
            }
            if (this.localConverter.isSimpleTypeConversionSupported(ultimateRawType = TypeUtilities.getRawClass((Type)typeToCheck)) || ultimateRawType != null && ultimateRawType.equals(Object.class)) {
                return;
            }
        } else if (this.localConverter.isSimpleTypeConversionSupported(rawRootType)) {
            return;
        }
        if ((rawTypeToCheck = TypeUtilities.getRawClass((Type)typeToCheck)) != null) {
            if (Collection.class.isAssignableFrom(rawTypeToCheck)) {
                return;
            }
            if (Map.class.isAssignableFrom(rawTypeToCheck)) {
                return;
            }
        }
        String typeName = rawRootType != null ? rawRootType.getName() : ((Object)rootType).toString();
        throw new JsonIoException("In readOptions.isReturningJsonObjects() mode, the rootType '" + typeName + "' is not supported. Allowed types are:\n- null\n- primitive types (e.g., int, boolean) and their wrapper classes (e.g., Integer, Boolean)\n- types supported by Converter.convert()\n- Map or any of its subclasses\n- Collection or any of its subclasses\n- Arrays (of any depth) of the above types\nPlease use one of these types as the rootType, or enable readOptions.isReturningJavaObjects().");
    }

    private Object handleObjectRoot(Type rootType, JsonObject jsonObj) {
        Object graph;
        Class<?> rawJObjClass;
        Class rawRootType;
        boolean returnJson = this.readOptions.isReturningJsonObjects();
        if (this.isSubstituteSortedCollectionNeeded(returnJson, rawRootType = rootType == null ? null : TypeUtilities.getRawClass((Type)rootType), rawJObjClass = jsonObj.getRawType())) {
            Class<?> fallbackType = this.getSubstituteCollection(rawJObjClass);
            jsonObj.setType(fallbackType);
        }
        if ((graph = this.resolveObjects(jsonObj, rootType)) == null) {
            return jsonObj;
        }
        if (rootType != null) {
            if (rawRootType != null && rawRootType.isAssignableFrom(graph.getClass())) {
                return graph;
            }
            if (rawRootType != null && this.localConverter.isConversionSupportedFor(graph.getClass(), rawRootType)) {
                return this.localConverter.convert(graph, rawRootType);
            }
            HashSet<Class<Cloneable>> skipRoots = new HashSet<Class<Cloneable>>();
            skipRoots.add(Object.class);
            skipRoots.add(Serializable.class);
            skipRoots.add(Cloneable.class);
            Set commonAncestors = ClassUtilities.findLowestCommonSupertypesExcluding(graph.getClass(), (Class)rawRootType, skipRoots);
            if (commonAncestors.isEmpty()) {
                throw new ClassCastException("Return type mismatch, expected: " + (rawRootType != null ? rawRootType.getName() : rootType.toString()) + ", actual: " + graph.getClass().getName());
            }
            return graph;
        }
        if (returnJson) {
            Type javaType = jsonObj.getType();
            if (javaType != null) {
                Class javaClass = TypeUtilities.getRawClass((Type)javaType);
                if (this.localConverter.isSimpleTypeConversionSupported(javaClass) || Number.class.isAssignableFrom(javaClass)) {
                    Class<?> basicType = this.getJsonSynonymType(javaClass);
                    return this.localConverter.convert((Object)jsonObj, basicType);
                }
                if (!this.isBuiltInPrimitive(graph)) {
                    return jsonObj;
                }
            }
            if (this.localConverter.isSimpleTypeConversionSupported(graph.getClass())) {
                return graph;
            }
            return jsonObj;
        }
        return graph;
    }

    private boolean isSubstituteSortedCollectionNeeded(boolean returnJson, Class<?> rootType, Class<?> javaType) {
        return returnJson && rootType == null && javaType != null && this.getSubstituteCollection(javaType) != null;
    }

    private Class<?> getSubstituteCollection(Class<?> javaType) {
        if (SortedSet.class.isAssignableFrom(javaType)) {
            return Set.class;
        }
        if (SortedMap.class.isAssignableFrom(javaType)) {
            return Map.class;
        }
        return null;
    }

    private Class<?> getJsonSynonymType(Class<?> javaType) {
        if (javaType == StringBuilder.class || javaType == StringBuffer.class) {
            return String.class;
        }
        if (javaType == AtomicInteger.class) {
            return Integer.class;
        }
        if (javaType == AtomicLong.class) {
            return Long.class;
        }
        if (javaType == AtomicBoolean.class) {
            return Boolean.class;
        }
        return javaType;
    }

    private boolean isBuiltInPrimitive(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> cls = obj.getClass();
        return this.localConverter.isSimpleTypeConversionSupported(cls);
    }

    protected <T> T resolveObjects(JsonObject rootObj, Type rootType) {
        boolean shouldManageUnsafe = false;
        if (this.readOptions.isUseUnsafe()) {
            ClassUtilities.setUseUnsafe((boolean)true);
            shouldManageUnsafe = this.isRoot;
        }
        try {
            Object value;
            if (rootType == null) {
                rootType = rootObj.getType() == null ? Object.class : rootObj.getType();
            }
            Object t = value = this.resolver.toJavaObjects(rootObj, (Type)rootType);
            return t;
        }
        catch (Exception e) {
            if (this.readOptions.isCloseStream()) {
                ExceptionUtilities.safelyIgnoreException(this::close);
            }
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
        finally {
            if (shouldManageUnsafe) {
                ClassUtilities.setUseUnsafe((boolean)false);
            }
            if (this.isRoot) {
                this.resolver.cleanup();
            }
        }
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
        finally {
            JsonParser.clearThreadLocalBuffers();
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input == null) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg.length() + 100);
        sb.append(msg).append("\nLast read: ").append(this.input.getLastSnippet()).append("\nline: ").append(this.input.getLine()).append(", col: ").append(this.input.getCol());
        return sb.toString();
    }

    static class DefaultReferenceTracker
    implements ReferenceTracker {
        final Map<Long, JsonObject> references = new HashMap<Long, JsonObject>();
        private final ReadOptions readOptions;

        public DefaultReferenceTracker(ReadOptions readOptions) {
            this.readOptions = readOptions;
        }

        @Override
        public JsonObject put(Long l, JsonObject o) {
            int maxReferences = this.readOptions.getMaxObjectReferences();
            if (this.references.size() >= maxReferences) {
                throw new JsonIoException("Security limit exceeded: Maximum number of object references (" + maxReferences + ") reached. Possible DoS attack.");
            }
            return this.references.put(l, o);
        }

        @Override
        public void clear() {
            this.references.clear();
        }

        @Override
        public int size() {
            return this.references.size();
        }

        @Override
        public JsonObject getOrThrow(Long id) {
            JsonObject target = this.get(id);
            if (target == null) {
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            return target;
        }

        @Override
        public JsonObject get(Long id) {
            JsonObject target = this.references.get(id);
            if (target == null) {
                return null;
            }
            HashSet<Long> visited = new HashSet<Long>();
            int chainDepth = 0;
            while (target.isReference()) {
                int maxChainDepth = this.readOptions.getMaxReferenceChainDepth();
                if (++chainDepth > maxChainDepth) {
                    throw new JsonIoException("Security limit exceeded: Reference chain depth (" + chainDepth + ") exceeds maximum (" + maxChainDepth + "). Possible circular reference attack.");
                }
                if (visited.contains(id)) {
                    throw new JsonIoException("Circular reference detected in reference chain starting with id: " + id + " at depth: " + chainDepth);
                }
                visited.add(id);
                Long nextId = target.getReferenceId();
                if (nextId == null) {
                    throw new JsonIoException("Reference id is null for object with id: " + id);
                }
                id = nextId;
                target = this.references.get(id);
                if (target != null) continue;
                return null;
            }
            return target;
        }
    }

    public static interface JsonClassReader<T> {
        default public T read(Object jsonObj, Resolver resolver) {
            throw new UnsupportedOperationException("You must implement this method and read the JSON content from jsonObj and copy the values from jsonObj to the target class, jsonObj.getTarget()");
        }
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }

    public static interface ClassFactory {
        default public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
            return ClassUtilities.newInstance((Converter)resolver.getConverter(), c, (Object)jObj);
        }

        default public boolean isObjectFinal() {
            return false;
        }
    }
}

