/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.util.TypeUtilities;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JsonValue {
    public static final String KEYS = "@keys";
    public static final String ITEMS = "@items";
    public static final String ID = "@id";
    public static final String REF = "@ref";
    public static final String TYPE = "@type";
    public static final String ENUM = "@enum";
    public static final String SHORT_TYPE = "@t";
    public static final String SHORT_ITEMS = "@e";
    public static final String SHORT_KEYS = "@k";
    public static final String SHORT_ID = "@i";
    public static final String SHORT_REF = "@r";
    public static final String VALUE = "value";
    Type type = null;
    protected Object target = null;
    protected boolean isFinished = false;
    protected long id = -1L;
    protected Long refId = null;
    protected int line;
    protected int col;
    private static final Map<Type, Boolean> typeResolvedCache = new ConcurrentHashMap<Type, Boolean>();

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public boolean isReference() {
        return this.refId != null;
    }

    public Long getReferenceId() {
        return this.refId;
    }

    public void setReferenceId(Long id) {
        this.refId = id;
        this.isFinished = true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished() {
        this.isFinished = true;
    }

    public Object setTarget(Object target) {
        this.target = target;
        if (target != null) {
            this.setType(target.getClass());
        }
        return target;
    }

    public Object setFinishedTarget(Object o, boolean isFinished) {
        this.isFinished = isFinished;
        return this.setTarget(o);
    }

    public Object getTarget() {
        return this.target;
    }

    public abstract boolean isArray();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null || type == this.type || type.equals(this.type)) {
            return;
        }
        if (type == Object.class && this.type != null) {
            return;
        }
        Boolean isResolved = typeResolvedCache.get(type);
        if (isResolved == null) {
            isResolved = !TypeUtilities.hasUnresolvedType((Type)type);
            typeResolvedCache.put(type, isResolved);
        }
        if (!isResolved.booleanValue()) {
            throw new JsonIoException("Unresolved type: " + type);
        }
        this.type = type;
    }

    public Class<?> getRawType() {
        return TypeUtilities.getRawClass((Type)this.type);
    }

    public String getRawTypeName() {
        if (this.type != null) {
            return TypeUtilities.getRawClass((Type)this.type).getName();
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean hasId() {
        return this.id > 0L;
    }

    void clear() {
        this.id = -1L;
        this.type = null;
        this.refId = null;
    }

    @Deprecated
    String getJavaTypeName() {
        return this.getRawType().getName();
    }

    @Deprecated
    public void setJavaType(Class<?> type) {
        this.setType(type);
    }

    @Deprecated
    public Class<?> getJavaType() {
        return this.getRawType();
    }
}

