/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.SealedSupplier;
import com.cedarsoftware.io.util.SealableList;
import com.cedarsoftware.io.util.SealableMap;
import com.cedarsoftware.io.util.SealableNavigableMap;
import com.cedarsoftware.io.util.SealableNavigableSet;
import com.cedarsoftware.io.util.SealableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class UnmodifiableFactory
implements JsonReader.ClassFactory {
    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        SealedSupplier supplier = resolver.getSealedSupplier();
        if (NavigableSet.class.isAssignableFrom(c) || SortedSet.class.isAssignableFrom(c)) {
            return new SealableNavigableSet(supplier);
        }
        if (Set.class.isAssignableFrom(c)) {
            return new SealableSet(supplier);
        }
        if (List.class.isAssignableFrom(c) || Collection.class.isAssignableFrom(c)) {
            return new SealableList(supplier);
        }
        if (NavigableMap.class.isAssignableFrom(c) || SortedMap.class.isAssignableFrom(c)) {
            return new SealableNavigableMap(supplier);
        }
        if (Map.class.isAssignableFrom(c)) {
            return new SealableMap(supplier);
        }
        throw new JsonIoException("SealableFactory handed Class for which it was not expecting: " + c.getName());
    }
}

