/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.prettyprint;

public class JsonPrettyPrinter {
    public static String prettyPrint(String json) {
        if (json == null || json.isEmpty()) {
            return json;
        }
        if (JsonPrettyPrinter.isPrimitive(json = json.trim())) {
            return json;
        }
        StringBuilder prettyJson = new StringBuilder();
        int indentLevel = 0;
        boolean inString = false;
        boolean escape = false;
        block6: for (int i = 0; i < json.length(); ++i) {
            char currentChar = json.charAt(i);
            if (escape) {
                prettyJson.append(currentChar);
                escape = false;
                continue;
            }
            if (currentChar == '\\') {
                escape = true;
                prettyJson.append(currentChar);
                continue;
            }
            if (currentChar == '\"') {
                inString = !inString;
                prettyJson.append(currentChar);
                continue;
            }
            if (!inString) {
                switch (currentChar) {
                    case '[': 
                    case '{': {
                        prettyJson.append(currentChar);
                        if (JsonPrettyPrinter.isNextCharClosing(json, i)) continue block6;
                        prettyJson.append('\n');
                        JsonPrettyPrinter.appendIndentation(prettyJson, ++indentLevel);
                        break;
                    }
                    case ']': 
                    case '}': {
                        if (!JsonPrettyPrinter.isPrevCharOpening(json, i)) {
                            prettyJson.append('\n');
                            JsonPrettyPrinter.appendIndentation(prettyJson, --indentLevel);
                        } else {
                            --indentLevel;
                        }
                        prettyJson.append(currentChar);
                        break;
                    }
                    case ',': {
                        prettyJson.append(currentChar);
                        if (JsonPrettyPrinter.isNextCharClosing(json, i)) continue block6;
                        prettyJson.append('\n');
                        JsonPrettyPrinter.appendIndentation(prettyJson, indentLevel);
                        break;
                    }
                    case ':': {
                        prettyJson.append(currentChar);
                        break;
                    }
                    default: {
                        if (Character.isWhitespace(currentChar)) continue block6;
                        prettyJson.append(currentChar);
                        break;
                    }
                }
                continue;
            }
            prettyJson.append(currentChar);
        }
        return prettyJson.toString();
    }

    private static boolean isPrimitive(String json) {
        return JsonPrettyPrinter.isJsonNull(json) || JsonPrettyPrinter.isJsonBoolean(json) || JsonPrettyPrinter.isJsonNumber(json) || JsonPrettyPrinter.isJsonString(json);
    }

    private static boolean isJsonNull(String json) {
        return "null".equals(json);
    }

    private static boolean isJsonBoolean(String json) {
        return "true".equals(json) || "false".equals(json);
    }

    private static boolean isJsonNumber(String json) {
        try {
            Double.parseDouble(json);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isJsonString(String json) {
        return json.startsWith("\"") && json.endsWith("\"");
    }

    private static boolean isNextCharClosing(String json, int index) {
        for (int i = index + 1; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '}' || c == ']';
        }
        return false;
    }

    private static boolean isPrevCharOpening(String json, int index) {
        for (int i = index - 1; i >= 0; --i) {
            char c = json.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '{' || c == '[';
        }
        return false;
    }

    private static void appendIndentation(StringBuilder sb, int indentLevel) {
        int INDENT_SIZE = 2;
        for (int i = 0; i < indentLevel * 2; ++i) {
            sb.append(' ');
        }
    }
}

