/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import java.util.Map;

public class ConvertableFactory<T>
implements JsonReader.ClassFactory {
    private final Class<? extends T> type;

    public ConvertableFactory(Class<? extends T> c) {
        this.type = c;
    }

    public T newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        if (jObj.hasValue()) {
            Object converted = resolver.getConverter().convert(jObj.getValue(), this.getType());
            return (T)jObj.setFinishedTarget(converted, true);
        }
        this.resolveReferences(resolver, jObj);
        Class<?> javaType = jObj.getRawType();
        Object converted = resolver.getConverter().convert((Object)jObj, javaType);
        return (T)jObj.setFinishedTarget(converted, true);
    }

    private void resolveReferences(Resolver resolver, JsonObject jObj) {
        ReferenceTracker refTracker = resolver.getReferences();
        for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
            JsonObject value;
            JsonObject child;
            if (!(entry.getValue() instanceof JsonObject) || !(child = (JsonObject)entry.getValue()).isReference() || (value = refTracker.get(child.getReferenceId())) == null) continue;
            entry.setValue(value);
        }
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

