/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonParser;
import com.cedarsoftware.io.MapResolver;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ObjectResolver;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayInputStream;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.convert.Converter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonReader
implements Closeable {
    private final FastReader input;
    private final Resolver resolver;
    private final ReadOptions readOptions;
    private final JsonParser parser;

    protected FastReader getReader(InputStream inputStream) {
        return new FastReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), 8192, 10);
    }

    public JsonReader(InputStream input, ReadOptions readOptions) {
        this(input, readOptions, new DefaultReferenceTracker());
    }

    public JsonReader(InputStream inputStream, ReadOptions readOptions, ReferenceTracker references) {
        this.readOptions = readOptions == null ? ReadOptionsBuilder.getDefaultReadOptions() : readOptions;
        Converter converter = new Converter(this.readOptions.getConverterOptions());
        this.input = this.getReader(inputStream);
        this.resolver = this.readOptions.isReturningJsonObjects() ? new MapResolver(this.readOptions, references, converter) : new ObjectResolver(this.readOptions, references, converter);
        this.parser = new JsonParser(this.input, this.resolver);
    }

    public JsonReader(ReadOptions readOptions) {
        this((InputStream)new FastByteArrayInputStream(new byte[0]), readOptions);
    }

    public <T> T readObject(Class<T> rootType) {
        Object returnValue;
        try {
            returnValue = this.parser.readValue(rootType);
            if (returnValue == null) {
                return null;
            }
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException(this.getErrorMessage("error parsing JSON value"), e);
        }
        if (returnValue instanceof JsonObject) {
            return (T)this.determineReturnValueWhenJsonObjectRoot(rootType, returnValue);
        }
        if (returnValue instanceof Object[]) {
            JsonObject rootObj = new JsonObject();
            rootObj.setTarget(returnValue);
            rootObj.setJsonArray((Object[])returnValue);
            T graph = this.toJavaObjects(rootObj, rootType);
            boolean asMaps = this.readOptions.isReturningJsonObjects();
            return (T)(asMaps ? returnValue : graph);
        }
        if (rootType != null) {
            Converter converter = this.resolver.getConverter();
            if (converter.isConversionSupportedFor(returnValue.getClass(), rootType)) {
                return (T)converter.convert(returnValue, rootType);
            }
            throw new JsonIoException(this.getErrorMessage("Return type mismatch, expected: " + rootType.getName() + ", actual: " + returnValue.getClass().getName()));
        }
        return (T)returnValue;
    }

    private <T> T determineReturnValueWhenJsonObjectRoot(Class<T> rootType, T returnValue) {
        boolean asMaps = this.readOptions.isReturningJsonObjects();
        T graph = this.toJavaObjects((JsonObject)returnValue, rootType);
        if (rootType == null) {
            return !asMaps || this.isJsonPrimitive(graph) ? graph : returnValue;
        }
        if (graph == null) {
            throw new JsonIoException("Cannot use root: {" + rootType.getName() + "} when 'returnAsNativeJsonObjects()' is set. Either use null for root, or set readOptions.returnAsJavaObjects() for this root.");
        }
        if (!rootType.isAssignableFrom(graph.getClass()) && !ClassUtilities.doesOneWrapTheOther(rootType, graph.getClass())) {
            return this.attemptTypeConversion(graph, rootType, returnValue);
        }
        return (T)(Map.class.isAssignableFrom(rootType) ? this.pickNotEmpty((Map)graph, (Map)returnValue) : graph);
    }

    private <T> T attemptTypeConversion(T graph, Class<T> rootType, T returnValue) {
        Converter converter = this.getResolver().getConverter();
        if (converter.isConversionSupportedFor(graph.getClass(), rootType)) {
            return (T)(graph instanceof Map ? converter.convert(this.pickNotEmpty((Map)graph, (Map)returnValue), rootType) : converter.convert(graph, rootType));
        }
        throw new JsonIoException("Return type mismatch, expected: " + rootType.getName() + ", actual: " + graph.getClass().getName() + "\nYou could be encountering an 'unknownType' (class) that cannot be created, in which case a LinkedHashMap is returned.\nYou may need to add a ClassFactory to create the unknown class.");
    }

    private boolean isJsonPrimitive(Object obj) {
        return obj instanceof Long || obj instanceof BigInteger || obj instanceof Double || obj instanceof BigDecimal || obj instanceof Boolean || obj instanceof String;
    }

    private Map<?, ?> pickNotEmpty(Map<?, ?> a, Map<?, ?> b) {
        return a.isEmpty() ? b : a;
    }

    protected <T> T toJavaObjects(JsonObject rootObj, Class<T> root) {
        try {
            if (root == null) {
                root = rootObj.getJavaType() == null ? Object.class : rootObj.getJavaType();
            }
            T t = this.resolver.toJavaObjects(rootObj, root);
            return t;
        }
        catch (Exception e) {
            if (this.readOptions.isCloseStream()) {
                MetaUtils.safelyIgnoreException(this::close);
            }
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
        finally {
            this.resolver.cleanup();
        }
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input != null) {
            return msg + "\nLast read: " + this.input.getLastSnippet() + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol();
        }
        return msg;
    }

    static class DefaultReferenceTracker
    implements ReferenceTracker {
        final Map<Long, JsonObject> references = new HashMap<Long, JsonObject>();

        DefaultReferenceTracker() {
        }

        @Override
        public JsonObject put(Long l, JsonObject o) {
            return this.references.put(l, o);
        }

        @Override
        public void clear() {
            this.references.clear();
        }

        @Override
        public int size() {
            return this.references.size();
        }

        @Override
        public JsonObject get(JsonObject jObj) {
            if (!jObj.isReference()) {
                return jObj;
            }
            return this.get(jObj.getReferenceId());
        }

        @Override
        public JsonObject get(Long id) {
            JsonObject target = this.references.get(id);
            if (target == null) {
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            while (target.isReference()) {
                id = target.getReferenceId();
                if ((target = this.references.get(id)) != null) continue;
                throw new JsonIoException("Forward reference @ref: " + id + ", but no object defined (@id) with that value");
            }
            return target;
        }
    }

    public static interface JsonClassReader {
        default public Object read(Object jsonObj, Resolver resolver) {
            throw new UnsupportedOperationException("You must implement this method and read the JSON content from jsonObj and copy the values from jsonObj to the target class, jsonObj.getTarget()");
        }
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }

    public static interface ClassFactory {
        default public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
            return MetaUtils.newInstance(resolver.getConverter(), c, null);
        }

        default public boolean isObjectFinal() {
            return false;
        }

        default public void gatherRemainingValues(Resolver resolver, JsonObject jObj, List<Object> arguments, Set<String> excludedFields) {
            Convention.throwIfNull((Object)jObj, (String)"JsonObject cannot be null");
            for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
                JsonObject sub;
                Object value;
                if (excludedFields.contains(entry.getKey().toString()) || entry.getValue() == null || !(entry.getValue() instanceof JsonObject) || (value = resolver.toJavaObjects(sub = (JsonObject)entry.getValue(), sub.getJavaType())) == null || sub.getJavaType() == null) continue;
                arguments.add(value);
            }
        }
    }
}

