/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.Primitives;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;

public class MapResolver
extends Resolver {
    protected MapResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Class<?> compType) {
        return null;
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        Object target = jsonObj.getTarget();
        Map<String, Injector> injectorMap = target == null ? null : this.getReadOptions().getDeepInjectorMap(target.getClass());
        for (Map.Entry<Object, Object> e : jsonObj.entrySet()) {
            String fieldName = (String)e.getKey();
            Injector injector = injectorMap == null ? null : injectorMap.get(fieldName);
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, (Object)null);
                continue;
            }
            if (rhs.getClass().isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.setJsonArray((Object[])rhs);
                this.push(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                boolean isNonRefClass;
                JsonObject jObj = (JsonObject)rhs;
                if (injector != null && (isNonRefClass = this.getReadOptions().isNonReferenceableClass(injector.getType()))) {
                    jObj.setValue(this.getConverter().convert(jObj.getValue(), injector.getType()));
                    continue;
                }
                Long refId = jObj.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = this.getReferences().get(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                this.push(jObj);
                continue;
            }
            if (injector == null) continue;
            Class<?> fieldType = injector.getType();
            if (Primitives.isPrimitive(fieldType) || BigDecimal.class.equals(fieldType) || BigInteger.class.equals(fieldType) || Date.class.equals(fieldType)) {
                Object convert = this.getConverter().convert(rhs, fieldType);
                jsonObj.put(fieldName, convert);
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, (Object)null);
        }
        jsonObj.setTarget(null);
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        Object[] items = jsonObj.getJsonArray();
        if (items == null || items.length == 0) {
            return;
        }
        Converter converter = this.getConverter();
        for (Object element : items) {
            JsonObject jsonObject;
            if (element instanceof Object[]) {
                jsonObject = new JsonObject();
                jsonObject.setJsonArray((Object[])element);
                this.push(jsonObject);
                continue;
            }
            if (!(element instanceof JsonObject)) continue;
            jsonObject = (JsonObject)element;
            Long refId = jsonObject.getReferenceId();
            if (refId == null) {
                Class<?> type = jsonObject.getJavaType();
                if (type != null && converter.isConversionSupportedFor(Map.class, type)) {
                    items[i] = converter.convert((Object)jsonObject, type);
                    jsonObject.setFinished();
                    continue;
                }
                this.push(jsonObject);
                continue;
            }
            JsonObject refObject = this.getReferences().get(refId);
            Class<?> type = refObject.getJavaType();
            if (type != null && converter.isConversionSupportedFor(Map.class, type)) {
                refObject.setFinishedTarget(converter.convert((Object)refObject, type), true);
                items[i] = refObject.getTarget();
                continue;
            }
            items[i] = refObject;
        }
        jsonObj.setFinished();
        jsonObj.setTarget(null);
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        this.traverseCollection(jsonObj);
    }

    @Override
    public void assignField(JsonObject jsonObj, Injector injector, Object rhs) {
    }
}

