/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.Primitives;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Map;

public class MapResolver
extends Resolver {
    protected MapResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Class compType, Deque<JsonObject> stack) {
        return null;
    }

    @Override
    public void traverseFields(Deque<JsonObject> stack, JsonObject jsonObj) {
        Object target = jsonObj.getTarget();
        Map<String, Injector> injectorMap = target == null ? null : this.getReadOptions().getDeepInjectorMap(target.getClass());
        for (Map.Entry<Object, Object> e : jsonObj.entrySet()) {
            String fieldName = (String)e.getKey();
            Injector injector = injectorMap == null ? null : injectorMap.get(fieldName);
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, (Object)null);
                continue;
            }
            if (rhs.getClass().isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.put("@items", rhs);
                stack.addFirst(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                boolean isNonRefClass;
                JsonObject jObj = (JsonObject)rhs;
                if (injector != null && (isNonRefClass = this.getReadOptions().isNonReferenceableClass(injector.getType()))) {
                    jObj.setValue(this.getConverter().convert(jObj.getValue(), injector.getType()));
                    continue;
                }
                Long refId = jObj.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = this.getReferences().get(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                stack.addFirst(jObj);
                continue;
            }
            if (injector == null) continue;
            Class<?> fieldType = injector.getType();
            if (Primitives.isPrimitive(fieldType) || BigDecimal.class.equals(fieldType) || BigInteger.class.equals(fieldType) || Date.class.equals(fieldType)) {
                Object convert = this.getConverter().convert(rhs, fieldType);
                jsonObj.put(fieldName, convert);
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, (Object)null);
        }
        jsonObj.setTarget(null);
    }

    @Override
    protected void traverseCollection(Deque<JsonObject> stack, JsonObject jsonObj) {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return;
        }
        int idx = 0;
        ArrayList<Object> copy = new ArrayList<Object>(items.length);
        for (Object element : items) {
            JsonObject jsonObject;
            copy.add(element);
            if (element instanceof Object[]) {
                jsonObject = new JsonObject();
                jsonObject.put("@items", element);
                stack.addFirst(jsonObject);
            } else if (element instanceof JsonObject) {
                jsonObject = (JsonObject)element;
                Long refId = jsonObject.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = this.getReferences().get(refId);
                    copy.set(idx, refObject);
                } else {
                    stack.addFirst(jsonObject);
                }
            }
            ++idx;
        }
        jsonObj.setTarget(null);
        for (int i = 0; i < items.length; ++i) {
            items[i] = copy.get(i);
        }
    }

    @Override
    protected void traverseArray(Deque<JsonObject> stack, JsonObject jsonObj) {
        this.traverseCollection(stack, jsonObj);
    }
}

