/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect.accessors;

import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.reflect.accessors.AbstractAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodAccessor
extends AbstractAccessor {
    private final Method method;

    public MethodAccessor(Field field, Method method) {
        super(field);
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            MetaUtils.trySetAccessible(method);
        }
        this.method = method;
    }

    @Override
    public Object retrieve(Object o) throws IllegalAccessException, InvocationTargetException {
        return this.method.invoke(o, new Object[0]);
    }

    @Override
    public boolean isPublic() {
        return super.isPublic() || Modifier.isPublic(this.method.getModifiers());
    }
}

