/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.factory.AbstractTemporalFactory;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class OffsetDateTimeFactory
extends AbstractTemporalFactory<OffsetDateTime> {
    private ZoneId zoneId;

    public OffsetDateTimeFactory(DateTimeFormatter dateFormatter, ZoneId zoneId) {
        super(dateFormatter);
        this.zoneId = zoneId;
    }

    public OffsetDateTimeFactory() {
        this(DateTimeFormatter.ISO_OFFSET_DATE_TIME, ZoneOffset.systemDefault());
    }

    @Override
    protected OffsetDateTime fromNumber(Number l) {
        Instant instant = Instant.ofEpochMilli(l.longValue());
        return OffsetDateTime.from(instant.atZone(this.zoneId));
    }

    @Override
    protected OffsetDateTime fromString(String s) {
        try {
            return OffsetDateTime.parse(s, this.dateTimeFormatter);
        }
        catch (Exception e) {
            Date date = Readers.DateReader.parseDate(s);
            return date.toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
    }

    @Override
    protected OffsetDateTime fromJsonObject(JsonObject job) {
        LocalDateTime dateTime = this.parseLocalDateTime(job.get("dateTime"));
        ZoneOffset zoneOffset = this.parseOffset(job.get("offset"));
        if (dateTime == null || zoneOffset == null) {
            throw new JsonIoException("Invalid json for OffsetDateTime");
        }
        return OffsetDateTime.of(dateTime, zoneOffset);
    }

    private LocalDateTime parseLocalDateTime(Object o) {
        if (o instanceof String) {
            return LocalDateTime.parse((String)o, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        if (o instanceof JsonObject) {
            JsonReader reader = ReaderContext.instance().getReader();
            return reader.convertParsedMapsToJava((JsonObject)o, LocalDateTime.class);
        }
        return null;
    }

    private ZoneOffset parseOffset(Object o) {
        if (o instanceof String) {
            return ZoneOffset.of((String)o);
        }
        if (o instanceof JsonObject) {
            JsonReader reader = ReaderContext.instance().getReader();
            return reader.convertParsedMapsToJava((JsonObject)o, ZoneOffset.class);
        }
        return null;
    }
}

