/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.Convention;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.WriteOptionsBuilder;
import com.cedarsoftware.util.reflect.Accessor;
import com.cedarsoftware.util.reflect.ClassDescriptor;
import com.cedarsoftware.util.reflect.ClassDescriptors;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaUtils {
    private static final Map<Class<?>, Map<String, Field>> classMetaCache = new ConcurrentHashMap();
    private static final Set<Class<?>> prims = new HashSet();
    private static final Map<String, Class<?>> nameToClass = new HashMap();
    private static final Byte[] byteCache = new Byte[256];
    private static final Pattern extraQuotes = Pattern.compile("(\"*)([^\"]*)(\"*)");
    private static final Class<?>[] emptyClassArray = new Class[0];
    private static final ConcurrentMap<Class<?>, Object[]> constructors = new ConcurrentHashMap();
    private static final Collection<?> unmodifiableCollection = Collections.unmodifiableCollection(new ArrayList());
    private static final Set<?> unmodifiableSet = Collections.unmodifiableSet(new HashSet());
    private static final SortedSet<?> unmodifiableSortedSet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Map<?, ?> unmodifiableMap = Collections.unmodifiableMap(new HashMap());
    private static final SortedMap<?, ?> unmodifiableSortedMap = Collections.unmodifiableSortedMap(new TreeMap());
    static final ThreadLocal<SimpleDateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    private static boolean useUnsafe = false;
    private static Unsafe unsafe;

    private MetaUtils() {
    }

    public static void setUseUnsafe(boolean state) {
        useUnsafe = state;
        if (state) {
            try {
                unsafe = new Unsafe();
            }
            catch (InvocationTargetException e) {
                useUnsafe = false;
            }
        }
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        if (items == null || items.length == 0) {
            return Collections.unmodifiableList(new ArrayList());
        }
        ArrayList list = new ArrayList();
        Collections.addAll(list, items);
        return Collections.unmodifiableList(list);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        if (items == null || items.length == 0) {
            return unmodifiableSet;
        }
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, items);
        return set;
    }

    public static <K, V> Map<K, V> mapOf() {
        return Collections.unmodifiableMap(new LinkedHashMap());
    }

    public static <K, V> Map<K, V> mapOf(K k, V v) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k, v);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }

    public static Field getField(Class<?> c, String field) {
        return MetaUtils.getDeepDeclaredFields(c).get(field);
    }

    public static Map<String, Field> getDeepDeclaredFields(Class<?> c) {
        Map<String, Field> classFields = classMetaCache.get(c);
        if (classFields != null) {
            return classFields;
        }
        classFields = new LinkedHashMap<String, Field>();
        for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
            Field[] local;
            for (Field field : local = curr.getDeclaredFields()) {
                String fieldName;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || "metaClass".equals(fieldName = field.getName()) && "groovy.lang.MetaClass".equals(field.getType().getName()) || field.getDeclaringClass().isAssignableFrom(Enum.class) && ("hash".equals(fieldName) || "ordinal".equals(fieldName) || "internal".equals(fieldName))) continue;
                if (classFields.containsKey(fieldName)) {
                    classFields.put(curr.getSimpleName() + '.' + fieldName, field);
                } else {
                    classFields.put(fieldName, field);
                }
                if (Modifier.isPublic(modifiers) && Modifier.isPublic(field.getDeclaringClass().getModifiers())) continue;
                MetaUtils.trySetAccessible(field);
            }
        }
        classMetaCache.put(c, classFields);
        return new LinkedHashMap<String, Field>(classFields);
    }

    public static int getDistance(Class<?> a, Class<?> b) {
        if (a.isInterface()) {
            return MetaUtils.getDistanceToInterface(a, b);
        }
        Class<?> curr = b;
        int distance = 0;
        while (curr != a) {
            ++distance;
            if ((curr = curr.getSuperclass()) != null) continue;
            return Integer.MAX_VALUE;
        }
        return distance;
    }

    /*
     * WARNING - void declaration
     */
    static int getDistanceToInterface(Class<?> to, Class<?> from) {
        void var6_9;
        Class<?>[] interfaces;
        LinkedHashSet possibleCandidates = new LinkedHashSet();
        Class<?>[] classArray = interfaces = from.getInterfaces();
        int n = classArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            Class<?> interfase = classArray[var6_9];
            if (to.equals(interfase)) {
                return 1;
            }
            if (to.isAssignableFrom(interfase)) {
                possibleCandidates.add(interfase);
            }
            ++var6_9;
        }
        if (from.getSuperclass() != null && to.isAssignableFrom(from.getSuperclass())) {
            possibleCandidates.add(from.getSuperclass());
        }
        int minimum = Integer.MAX_VALUE;
        for (Class clazz : possibleCandidates) {
            int distance = MetaUtils.getDistanceToInterface(to, clazz);
            if (distance >= minimum) continue;
            minimum = ++distance;
        }
        return minimum;
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || prims.contains(c);
    }

    public static boolean isLogicalPrimitive(Class<?> c) {
        return c.isPrimitive() || prims.contains(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || java.util.Date.class.isAssignableFrom(c) || c.isEnum() || c.equals(Class.class);
    }

    public static Optional<Class> getClassIfEnum(Class c) {
        if (c.isEnum()) {
            return Optional.of(c);
        }
        if (!Enum.class.isAssignableFrom(c)) {
            return Optional.empty();
        }
        Class<?> enclosingClass = c.getEnclosingClass();
        return enclosingClass != null && enclosingClass.isEnum() ? Optional.of(enclosingClass) : Optional.empty();
    }

    public static Class<?> classForName(String name, ClassLoader classLoader) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            Class<?> c = nameToClass.get(name);
            if (c != null) {
                return c;
            }
            return MetaUtils.loadClass(name, classLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            if (className.equals("[B")) {
                primitiveArray = byte[].class;
            } else if (className.equals("[S")) {
                primitiveArray = short[].class;
            } else if (className.equals("[I")) {
                primitiveArray = int[].class;
            } else if (className.equals("[J")) {
                primitiveArray = long[].class;
            } else if (className.equals("[F")) {
                primitiveArray = float[].class;
            } else if (className.equals("[D")) {
                primitiveArray = double[].class;
            } else if (className.equals("[Z")) {
                primitiveArray = boolean[].class;
            } else if (className.equals("[C")) {
                primitiveArray = char[].class;
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<Object> currentClass = null;
        if (null == primitiveArray) {
            try {
                currentClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                currentClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
        if (arrayType) {
            Class clazz = currentClass = null != primitiveArray ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    static String removeLeadingAndTrailingQuotes(String s) {
        Matcher m = extraQuotes.matcher(s);
        if (m.find()) {
            s = m.group(2);
        }
        return s;
    }

    static void throwIfSecurityConcern(Class<?> securityConcern, Class<?> c) {
        if (securityConcern.isAssignableFrom(c)) {
            throw new IllegalArgumentException("For security reasons, json-io does not allow instantiation of: " + securityConcern.getName());
        }
    }

    public static Object newInstance(Class<?> c) {
        MetaUtils.throwIfSecurityConcern(ProcessBuilder.class, c);
        MetaUtils.throwIfSecurityConcern(Process.class, c);
        MetaUtils.throwIfSecurityConcern(ClassLoader.class, c);
        MetaUtils.throwIfSecurityConcern(Constructor.class, c);
        MetaUtils.throwIfSecurityConcern(Method.class, c);
        MetaUtils.throwIfSecurityConcern(Field.class, c);
        if (c.getName().equals("java.lang.ProcessImpl")) {
            throw new IllegalArgumentException("For security reasons, json-io does not allow instantiation of: java.lang.ProcessImpl");
        }
        if (unmodifiableSortedMap.getClass().isAssignableFrom(c)) {
            return new TreeMap();
        }
        if (unmodifiableMap.getClass().isAssignableFrom(c)) {
            return new LinkedHashMap();
        }
        if (unmodifiableSortedSet.getClass().isAssignableFrom(c)) {
            return new TreeSet();
        }
        if (unmodifiableSet.getClass().isAssignableFrom(c)) {
            return new LinkedHashSet();
        }
        if (unmodifiableCollection.getClass().isAssignableFrom(c)) {
            return new ArrayList();
        }
        if (Collections.EMPTY_LIST.getClass().equals(c)) {
            return Collections.emptyList();
        }
        if (c.isInterface()) {
            throw new JsonIoException("Cannot instantiate unknown interface: " + c.getName());
        }
        Object[] constructorInfo = (Object[])constructors.get(c);
        if (constructorInfo != null) {
            Constructor constructor = (Constructor)constructorInfo[0];
            if (constructor == null && useUnsafe) {
                try {
                    return unsafe.allocateInstance(c);
                }
                catch (Exception e) {
                    throw new JsonIoException("Could not instantiate " + c.getName(), e);
                }
            }
            if (constructor == null) {
                throw new JsonIoException("No constructor found to instantiate " + c.getName());
            }
            Boolean useNull = (Boolean)constructorInfo[1];
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length == 0) {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new JsonIoException("Could not instantiate " + c.getName(), e);
                }
            }
            Object[] values = MetaUtils.fillArgs(paramTypes, useNull);
            try {
                return constructor.newInstance(values);
            }
            catch (Exception e) {
                throw new JsonIoException("Could not instantiate " + c.getName(), e);
            }
        }
        Object[] ret = MetaUtils.newInstanceEx(c);
        constructors.put(c, new Object[]{ret[1], ret[2]});
        return ret[0];
    }

    private static Object[] newInstanceEx(Class<?> c) {
        try {
            Constructor<?> constructor = c.getConstructor(emptyClassArray);
            return new Object[]{constructor.newInstance(new Object[0]), constructor, true};
        }
        catch (Exception e) {
            return MetaUtils.tryOtherConstruction(c);
        }
    }

    static Object[] tryOtherConstruction(Class<?> c) {
        Object[] values;
        Class<?>[] argTypes;
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new JsonIoException("Cannot instantiate '" + c.getName() + "' - Primitive, interface, array[] or void");
        }
        List<Constructor<?>> constructorList = Arrays.asList(constructors);
        constructorList.sort((c1, c2) -> {
            int c2Vis;
            int c1Vis = c1.getModifiers();
            if (c1Vis == (c2Vis = c2.getModifiers())) {
                return MetaUtils.compareConstructors(c1, c2);
            }
            if (Modifier.isPublic(c1Vis) != Modifier.isPublic(c2Vis)) {
                return Modifier.isPublic(c1Vis) ? -1 : 1;
            }
            if (Modifier.isProtected(c1Vis) != Modifier.isProtected(c2Vis)) {
                return Modifier.isProtected(c1Vis) ? -1 : 1;
            }
            if (Modifier.isPrivate(c1Vis) != Modifier.isPrivate(c2Vis)) {
                return Modifier.isPrivate(c1Vis) ? 1 : -1;
            }
            return 0;
        });
        for (Constructor<?> constructor : constructorList) {
            MetaUtils.trySetAccessible(constructor);
            argTypes = constructor.getParameterTypes();
            values = MetaUtils.fillArgs(argTypes, true);
            try {
                return new Object[]{constructor.newInstance(values), constructor, true};
            }
            catch (Exception exception) {
            }
        }
        for (Constructor<?> constructor : constructorList) {
            if (!MetaUtils.trySetAccessible(constructor)) continue;
            argTypes = constructor.getParameterTypes();
            values = MetaUtils.fillArgs(argTypes, false);
            try {
                return new Object[]{constructor.newInstance(values), constructor, false};
            }
            catch (Exception exception) {
            }
        }
        if (useUnsafe) {
            try {
                return new Object[]{unsafe.allocateInstance(c), null, null};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new JsonIoException("Could not instantiate " + c.getName() + " using any constructor");
    }

    private static int compareConstructors(Constructor<?> c1, Constructor<?> c2) {
        Class<?>[] c2ParamTypes;
        Class<?>[] c1ParamTypes = c1.getParameterTypes();
        if (c1ParamTypes.length != (c2ParamTypes = c2.getParameterTypes()).length) {
            return c1ParamTypes.length - c2ParamTypes.length;
        }
        int len = c1ParamTypes.length;
        for (int i = 0; i < len; ++i) {
            Class<?> class1 = c1ParamTypes[i];
            Class<?> class2 = c2ParamTypes[i];
            int compare = class1.getName().compareTo(class2.getName());
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    static Object getArgForType(Class<?> argType, boolean allowNull) {
        if (argType.isPrimitive()) {
            return MetaUtils.convert(argType, null);
        }
        if (allowNull) {
            return null;
        }
        if (prims.contains(argType)) {
            return MetaUtils.convert(argType, null);
        }
        if (argType == String.class) {
            return "";
        }
        if (argType == java.util.Date.class) {
            return new java.util.Date();
        }
        if (List.class.isAssignableFrom(argType)) {
            return new ArrayList();
        }
        if (SortedSet.class.isAssignableFrom(argType)) {
            return new TreeSet();
        }
        if (Set.class.isAssignableFrom(argType)) {
            return new LinkedHashSet();
        }
        if (SortedMap.class.isAssignableFrom(argType)) {
            return new TreeMap();
        }
        if (Map.class.isAssignableFrom(argType)) {
            return new LinkedHashMap();
        }
        if (Collection.class.isAssignableFrom(argType)) {
            return new ArrayList();
        }
        if (Calendar.class.isAssignableFrom(argType)) {
            return Calendar.getInstance();
        }
        if (TimeZone.class.isAssignableFrom(argType)) {
            return TimeZone.getDefault();
        }
        if (argType == BigInteger.class) {
            return BigInteger.TEN;
        }
        if (argType == BigDecimal.class) {
            return BigDecimal.TEN;
        }
        if (argType == StringBuilder.class) {
            return new StringBuilder();
        }
        if (argType == StringBuffer.class) {
            return new StringBuffer();
        }
        if (argType == Locale.class) {
            return Locale.FRANCE;
        }
        if (argType == Class.class) {
            return String.class;
        }
        if (argType == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (argType == Date.class) {
            return new Date(System.currentTimeMillis());
        }
        if (argType == LocalDate.class) {
            return LocalDate.now();
        }
        if (argType == LocalDateTime.class) {
            return LocalDateTime.now();
        }
        if (argType == ZonedDateTime.class) {
            return ZonedDateTime.now();
        }
        if (argType == ZoneId.class) {
            return ZoneId.systemDefault();
        }
        if (argType == AtomicBoolean.class) {
            return new AtomicBoolean(true);
        }
        if (argType == AtomicInteger.class) {
            return new AtomicInteger(7);
        }
        if (argType == AtomicLong.class) {
            return new AtomicLong(7L);
        }
        if (argType == URL.class) {
            try {
                return new URL("http://localhost");
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (argType == Object.class) {
            return new Object();
        }
        if (argType.isArray()) {
            return new Object[0];
        }
        return null;
    }

    static Object[] fillArgs(Class<?>[] argTypes, boolean useNull) {
        Object[] values = new Object[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            Class<?> argType = argTypes[i];
            values[i] = MetaUtils.getArgForType(argType, useNull);
        }
        return values;
    }

    public static void buildHints(JsonReader reader, JsonObject jObj, Map<Class<?>, List<ParameterHint>> hints, Set<String> fieldsAlreadyInHints) {
        Convention.throwIfNull(jObj, "JsonObject cannot be null");
        Convention.throwIfNull(reader, "JsonReader cannot be null");
        for (Map.Entry entry : jObj.entrySet()) {
            if (fieldsAlreadyInHints.contains(entry.getKey().toString())) continue;
            Object o = entry.getValue();
            Object value = null;
            if (o instanceof JsonObject) {
                JsonObject sub = (JsonObject)o;
                value = reader.convertParsedMapsToJava(sub, MetaUtils.classForName(sub.getType(), reader.getClassLoader()));
                if (value == null) continue;
                if (sub.getType() != null) {
                    Class<?> typeClass = MetaUtils.classForName(sub.getType(), reader.getClassLoader());
                    hints.computeIfAbsent(typeClass, k -> new ArrayList()).add(new ParameterHint(entry.getKey().toString(), value));
                }
                if (sub.getTargetClass() == null) continue;
                hints.computeIfAbsent(sub.getTargetClass(), k -> new ArrayList()).add(new ParameterHint(entry.getKey().toString(), value));
                continue;
            }
            if (o == null) continue;
            hints.computeIfAbsent(o.getClass(), k -> new ArrayList()).add(new ParameterHint(entry.getKey().toString(), o));
        }
    }

    public static Object findAndConstructWithAppropriateConstructor(Class<?> c, Map<Class<?>, List<ParameterHint>> paramHints) {
        try {
            Constructor<?>[] constructors = c.getDeclaredConstructors();
            Object[] constructorArgs = new Object[constructors.length];
            double bestScore = Double.MIN_VALUE;
            int choice = 0;
            int choiceParameterCount = 0;
            for (int i = 0; i < constructors.length; ++i) {
                Object[] arguments;
                Parameter[] parameters = constructors[i].getParameters();
                constructorArgs[i] = arguments = new Object[parameters.length];
                double score = MetaUtils.fillArgsWithHints(parameters, arguments, paramHints);
                if (!(score >= bestScore) || parameters.length < choiceParameterCount) continue;
                bestScore = score;
                choice = i;
                choiceParameterCount = parameters.length;
            }
            Object[] arguments = (Object[])constructorArgs[choice];
            Constructor<?> constructor = constructors[choice];
            try {
                return constructor.newInstance(arguments);
            }
            catch (IllegalAccessException iae) {
                return constructor.newInstance(arguments);
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Error calling constructor for: " + c.getName(), e);
        }
    }

    public static double fillArgsWithHints(Parameter[] parameters, Object[] arguments, Map<Class<?>, List<ParameterHint>> hints) {
        int found = 0;
        for (int i = 0; i < parameters.length; ++i) {
            boolean wasSet;
            Parameter param = parameters[i];
            String name = param.isNamePresent() ? param.getName() : null;
            arguments[i] = null;
            List<ParameterHint> hintList = hints.get(param.getType());
            if (hintList != null && !hintList.isEmpty()) {
                wasSet = MetaUtils.setParameterIfPossible(arguments, hintList, i, name);
            } else {
                Optional<List> optionalList = hints.entrySet().stream().filter(entry -> param.getType().isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).findFirst();
                List list = optionalList.orElse(new ArrayList());
                wasSet = MetaUtils.setParameterIfPossible(arguments, list, i, name);
            }
            if (arguments[i] == null && !wasSet) {
                arguments[i] = MetaUtils.getArgForType(param.getType(), true);
            }
            if (!wasSet) continue;
            ++found;
        }
        if (parameters.length == 0) {
            return 1.0;
        }
        return found / parameters.length;
    }

    private static boolean setParameterIfPossible(Object[] arguments, List<ParameterHint> list, int i, String name) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (list.size() == 1) {
            arguments[i] = list.get((int)0).object;
            return true;
        }
        Optional<ParameterHint> optional = list.stream().filter(h -> name == null || name.equalsIgnoreCase(h.parameterName)).findFirst();
        arguments[i] = optional.isPresent() ? optional.get().object : list.get(0);
        return true;
    }

    static Object convert(Class<?> c, Object rhs) {
        try {
            if (c == Boolean.TYPE || c == Boolean.class) {
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "false";
                    }
                    return Boolean.parseBoolean((String)rhs);
                }
                return rhs != null ? rhs : Boolean.FALSE;
            }
            if (c == Byte.TYPE || c == Byte.class) {
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0";
                    }
                    return Byte.parseByte((String)rhs);
                }
                return rhs != null ? byteCache[((Number)rhs).byteValue() + 128] : (byte)0;
            }
            if (c == Character.TYPE || c == Character.class) {
                if (rhs == null) {
                    return Character.valueOf('\u0000');
                }
                if (rhs instanceof String) {
                    if (rhs.equals("\"")) {
                        return Character.valueOf('\"');
                    }
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "\u0000";
                    }
                    return Character.valueOf(((CharSequence)rhs).charAt(0));
                }
                if (rhs instanceof Character) {
                    return rhs;
                }
            } else {
                if (c == Double.TYPE || c == Double.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0.0";
                        }
                        return Double.parseDouble((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).doubleValue() : 0.0;
                }
                if (c == Float.TYPE || c == Float.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0.0f";
                        }
                        return Float.valueOf(Float.parseFloat((String)rhs));
                    }
                    return Float.valueOf(rhs != null ? ((Number)rhs).floatValue() : 0.0f);
                }
                if (c == Integer.TYPE || c == Integer.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Integer.parseInt((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).intValue() : 0;
                }
                if (c == Long.TYPE || c == Long.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Long.parseLong((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).longValue() : 0L;
                }
                if (c == Short.TYPE || c == Short.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Short.parseShort((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).shortValue() : (short)0;
                }
                if (c == java.util.Date.class) {
                    if (rhs instanceof String) {
                        return Readers.DateReader.parseDate((String)rhs);
                    }
                    if (rhs instanceof Long) {
                        return new java.util.Date((Long)rhs);
                    }
                } else {
                    if (c == BigInteger.class) {
                        return Readers.bigIntegerFrom(rhs);
                    }
                    if (c == BigDecimal.class) {
                        return Readers.bigDecimalFrom(rhs);
                    }
                }
            }
        }
        catch (Exception e) {
            String className = c == null ? "null" : c.getName();
            throw new JsonIoException("Error creating primitive wrapper instance for Class: " + className, e);
        }
        throw new JsonIoException("Class '" + c.getName() + "' does not have primitive wrapper.");
    }

    public static String getLogMessage(String methodName, Object[] args) {
        return MetaUtils.getLogMessage(methodName, args, 64);
    }

    public static String getLogMessage(String methodName, Object[] args, int argCharLen) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        for (Object arg : args) {
            sb.append(MetaUtils.getJsonStringToMaxLength(arg, argCharLen));
            sb.append("  ");
        }
        String result = sb.toString().trim();
        return result + ')';
    }

    private static String getJsonStringToMaxLength(Object obj, int argCharLen) {
        String arg = JsonWriter.toJson(obj, new WriteOptionsBuilder().withShortMetaKeys().neverShowTypeInfo().build());
        if (arg.length() > argCharLen) {
            arg = arg.substring(0, argCharLen) + "...";
        }
        return arg;
    }

    public static Map<Class<?>, Collection<Accessor>> convertStringFieldNamesToAccessors(Map<Class<?>, Collection<String>> map) {
        HashMap copy = new HashMap();
        if (map == null) {
            return copy;
        }
        for (Map.Entry<Class<?>, Collection<String>> entry : map.entrySet()) {
            Class<?> c = entry.getKey();
            Collection<String> fields = entry.getValue();
            Map<String, Field> classFields = MetaUtils.getDeepDeclaredFields(c);
            for (String field : fields) {
                Field f = classFields.get(field);
                if (f == null) {
                    throw new JsonIoException("Unable to locate field: " + field + " on class: " + c.getName() + ". Make sure the fields in the FIELD_SPECIFIERS map existing on the associated class.");
                }
                ClassDescriptor descriptor = ClassDescriptors.instance().getClassDescriptor(f.getDeclaringClass());
                Collection list = copy.computeIfAbsent(f.getDeclaringClass(), l -> new LinkedHashSet());
                list.add(descriptor.getAccessors().get(f.getName()));
            }
        }
        return copy;
    }

    public static <K, V> V getValue(Map map, K key) {
        return map.get(key);
    }

    public static <K, V> V getValueWithDefaultForNull(Map map, K key, V defaultValue) {
        Object value = map.get(key);
        return value == null ? defaultValue : value;
    }

    public static <K, V> V getValueWithDefaultForMissing(Map map, K key, V defaultValue) {
        if (!map.containsKey(key)) {
            return defaultValue;
        }
        return map.get(key);
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        try {
            if (instance == null) {
                throw new JsonIoException("Attempting to set field: " + field.getName() + " on null object.");
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new JsonIoException("Cannot set field: " + field.getName() + " on class: " + instance.getClass().getName() + " as field is not accessible.  Add or create a ClassFactory implementation to create the needed class, and use JsonReader.assignInstantiator() to associate your ClassFactory to the class: " + instance.getClass().getName(), e);
        }
    }

    public static boolean trySetAccessible(AccessibleObject object) {
        return MetaUtils.safelyIgnoreException(() -> {
            object.setAccessible(true);
            return true;
        }, false);
    }

    public static <T> T safelyIgnoreException(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    static {
        prims.add(Byte.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Float.class);
        prims.add(Boolean.class);
        prims.add(Short.class);
        nameToClass.put("string", String.class);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("date", java.util.Date.class);
        nameToClass.put("class", Class.class);
        for (int i = 0; i < byteCache.length; ++i) {
            MetaUtils.byteCache[i] = (byte)(i - 128);
        }
    }

    static final class Unsafe {
        private final Object sunUnsafe;
        private final Method allocateInstance;

        public Unsafe() throws InvocationTargetException {
            try {
                Constructor<?> unsafeConstructor = MetaUtils.classForName("sun.misc.Unsafe", MetaUtils.class.getClassLoader()).getDeclaredConstructor(new Class[0]);
                unsafeConstructor.setAccessible(true);
                this.sunUnsafe = unsafeConstructor.newInstance(new Object[0]);
                this.allocateInstance = this.sunUnsafe.getClass().getMethod("allocateInstance", Class.class);
                this.allocateInstance.setAccessible(true);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }

        public Object allocateInstance(Class<?> clazz) {
            try {
                return this.allocateInstance.invoke(this.sunUnsafe, clazz);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create instance of class: " + name, e);
            }
            catch (InvocationTargetException e) {
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create instance of class: " + name, e.getCause() != null ? e.getCause() : e);
            }
        }
    }

    public static class ParameterHint {
        String parameterName;
        Object object;

        public String getParameterName() {
            return this.parameterName;
        }

        public Object getObject() {
            return this.object;
        }

        public ParameterHint(String parameterName, Object object) {
            this.parameterName = parameterName;
            this.object = object;
        }
    }

    public static interface Callable<V> {
        public V call() throws Throwable;
    }

    public static final class Dumpty
    extends Enum<Dumpty> {
        private static final /* synthetic */ Dumpty[] $VALUES;

        public static Dumpty[] values() {
            return (Dumpty[])$VALUES.clone();
        }

        public static Dumpty valueOf(String name) {
            return Enum.valueOf(Dumpty.class, name);
        }

        private static /* synthetic */ Dumpty[] $values() {
            return new Dumpty[0];
        }

        static {
            $VALUES = Dumpty.$values();
        }
    }
}

