/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import java.util.HashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private final Map<K, Node<K, V>> cacheMap;
    private final DoublyLinkedList<K, V> doublyLinkedList;
    private final int capacity;

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.cacheMap = new HashMap<K, Node<K, V>>();
        this.doublyLinkedList = new DoublyLinkedList();
    }

    public V get(K key) {
        if (this.cacheMap.containsKey(key)) {
            Node<K, V> node = this.cacheMap.get(key);
            this.doublyLinkedList.moveToHead(node);
            return node.value;
        }
        return null;
    }

    public void put(K key, V value) {
        if (this.cacheMap.containsKey(key)) {
            Node<K, V> node = this.cacheMap.get(key);
            node.value = value;
            this.doublyLinkedList.moveToHead(node);
        } else {
            if (this.cacheMap.size() == this.capacity) {
                K removedKey = this.doublyLinkedList.removeTail();
                this.cacheMap.remove(removedKey);
            }
            Node<K, V> newNode = new Node<K, V>(key, value);
            this.cacheMap.put(key, newNode);
            this.doublyLinkedList.addToHead(newNode);
        }
    }

    private static class DoublyLinkedList<K, V> {
        private final Node<K, V> head = new Node<Object, Object>(null, null);
        private final Node<K, V> tail = new Node<Object, Object>(null, null);

        DoublyLinkedList() {
            this.head.next = this.tail;
            this.tail.prev = this.head;
        }

        void moveToHead(Node<K, V> node) {
            this.removeNode(node);
            this.addToHead(node);
        }

        void addToHead(Node<K, V> node) {
            node.prev = this.head;
            node.next = this.head.next;
            this.head.next.prev = node;
            this.head.next = node;
        }

        void removeNode(Node<K, V> node) {
            Node nextNode;
            Node prevNode = node.prev;
            prevNode.next = nextNode = node.next;
            nextNode.prev = prevNode;
        }

        K removeTail() {
            if (this.tail.prev == this.head) {
                return null;
            }
            Node tailItem = this.tail.prev;
            this.removeNode(tailItem);
            return tailItem.key;
        }
    }

    private static class Node<K, V> {
        K key;
        V value;
        Node<K, V> prev;
        Node<K, V> next;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

