/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.MetaUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WriteOptionsBuilder {
    private final ConcurrentMap<String, Object> writeOptions = new ConcurrentHashMap<String, Object>();

    public WriteOptionsBuilder withDefaultOptimizations() {
        return this.withIsoDateTimeFormat().withShortMetaKeys().skipNullFields();
    }

    public WriteOptionsBuilder skipNullFields() {
        this.writeOptions.put("SKIP_NULL", Boolean.TRUE);
        return this;
    }

    public WriteOptionsBuilder withPrettyPrint() {
        this.writeOptions.put("PRETTY_PRINT", Boolean.TRUE);
        return this;
    }

    public WriteOptionsBuilder writeLongsAsStrings() {
        this.writeOptions.put("WLAS", Boolean.TRUE);
        return this;
    }

    public WriteOptionsBuilder doNotWritePrivateEnumFields() {
        this.writeOptions.put("ENUM_PUBLIC_ONLY", Boolean.TRUE);
        return this;
    }

    public WriteOptionsBuilder writeEnumsAsPrimitive() {
        this.writeOptions.put("ENUMS_AS_PRIMITIVE", Boolean.TRUE);
        return this;
    }

    public WriteOptionsBuilder forceMapOutputAsKeysAndItems() {
        this.writeOptions.put("FORCE_MAP_FORMAT_ARRAY_KEYS_ITEMS", Boolean.TRUE);
        return this;
    }

    public WriteOptionsBuilder withClassLoader(ClassLoader classLoader) {
        this.writeOptions.put("CLASSLOADER", classLoader);
        return this;
    }

    public WriteOptionsBuilder withIsoDateTimeFormat() {
        return this.withDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public WriteOptionsBuilder withIsoDateFormat() {
        return this.withDateFormat("yyyy-MM-dd");
    }

    public WriteOptionsBuilder withDateFormat(String format) {
        this.writeOptions.put("DATE_FORMAT", format);
        return this;
    }

    public WriteOptionsBuilder withShortMetaKeys() {
        this.writeOptions.put("SHORT_META_KEYS", true);
        return this;
    }

    public WriteOptionsBuilder withNoTypeInformation() {
        this.writeOptions.put("TYPE", Boolean.FALSE);
        return this;
    }

    public WriteOptionsBuilder forceTypeInformation() {
        this.writeOptions.put("TYPE", Boolean.TRUE);
        return this;
    }

    public WriteOptionsBuilder withFieldNameBlackList(Class c, List<String> fields) {
        MetaUtils.computeMapIfAbsent(this.writeOptions, "FIELD_NAME_BLACK_LIST").put(c, fields);
        return this;
    }

    public WriteOptionsBuilder withFieldNameBlackListMap(Map<Class, List<String>> map) {
        MetaUtils.computeMapIfAbsent(this.writeOptions, "FIELD_NAME_BLACK_LIST").putAll(map);
        return this;
    }

    public WriteOptionsBuilder withFieldSpecifier(Class c, List<String> fields) {
        MetaUtils.computeMapIfAbsent(this.writeOptions, "FIELD_SPECIFIERS").put(c, fields);
        return this;
    }

    public WriteOptionsBuilder withFieldSpecifiersMap(Map<Class, List<String>> map) {
        MetaUtils.computeMapIfAbsent(this.writeOptions, "FIELD_SPECIFIERS").putAll(map);
        return this;
    }

    public WriteOptionsBuilder withCustomTypeName(Class type, String newTypeName) {
        return this.withCustomTypeName(type.getName(), newTypeName);
    }

    public WriteOptionsBuilder withCustomTypeName(String type, String newTypeName) {
        this.assertTypesAreBeingOutput();
        MetaUtils.computeMapIfAbsent(this.writeOptions, "TYPE_NAME_MAP").put(type, newTypeName);
        return this;
    }

    public WriteOptionsBuilder withCustomTypeNameMap(Map<String, String> map) {
        this.assertTypesAreBeingOutput();
        MetaUtils.computeMapIfAbsent(this.writeOptions, "TYPE_NAME_MAP").putAll(map);
        return this;
    }

    public WriteOptionsBuilder withCustomWriter(Class c, JsonWriter.JsonClassWriter writer) {
        MetaUtils.computeMapIfAbsent(this.writeOptions, "CUSTOM_WRITERS").put(c, writer);
        return this;
    }

    public WriteOptionsBuilder withCustomWriterMap(Map<Class, JsonWriter.JsonClassWriter> map) {
        MetaUtils.computeMapIfAbsent(this.writeOptions, "CUSTOM_WRITERS").putAll(map);
        return this;
    }

    public WriteOptionsBuilder withNonCustomizableClass(Class c) {
        MetaUtils.computeSetIfAbsent(this.writeOptions, "NOT_CUSTOM_WRITERS").add(c);
        return this;
    }

    public WriteOptionsBuilder withNonCustomizableClasses(Collection<Class> collection) {
        MetaUtils.computeSetIfAbsent(this.writeOptions, "NOT_CUSTOM_WRITERS").addAll(collection);
        return this;
    }

    public Map<String, Object> build() {
        return this.writeOptions;
    }

    private void assertTypesAreBeingOutput() {
        Boolean setting = (Boolean)this.writeOptions.get("TYPE");
        if (setting != null && !setting.booleanValue()) {
            throw new IllegalStateException("TYPE_NAME_MAP is not needed when types are not going to be output");
        }
    }
}

